/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer;

import android.annotation.SuppressLint;
import android.app.Application;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.HasTracerConfiguration;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerActivityLifecycleCallbacks;
import ru.ok.tracer.TracerApplicationInfo;
import ru.ok.tracer.TracerConfiguration;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.apptoken.AppTokenUtils;
import ru.ok.tracer.base.builduuid.BuildUuidUtils;
import ru.ok.tracer.base.compat.PackageInfoCompat;
import ru.ok.tracer.base.compat.PackageManagerCompat;
import ru.ok.tracer.base.drop.DropManager;
import ru.ok.tracer.base.http.HttpClient;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.session.SessionState;
import ru.ok.tracer.session.SessionStateStorage;
import ru.ok.tracer.session.TagsStorage;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;
import ru.ok.tracer.utils.config.ConfigStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\n\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u00101\u001a\u000202H\u0007J\n\u00103\u001a\u0004\u0018\u000104H\u0007J\u0015\u00105\u001a\u0002022\u0006\u0010\r\u001a\u00020\fH\u0000\u00a2\u0006\u0002\b6J\u0016\u00107\u001a\b\u0012\u0004\u0012\u00020#082\u0006\u0010\r\u001a\u000209H\u0002J\u001e\u0010:\u001a\u0002022\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040!H\u0007J\u001a\u0010<\u001a\u0002022\u0006\u0010=\u001a\u00020\u00042\b\u0010>\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010?\u001a\u0002022\u0006\u0010=\u001a\u00020\u00042\b\u0010>\u001a\u0004\u0018\u00010\u0004H\u0007J\u001e\u0010@\u001a\u0002022\u0014\u0010;\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00040!H\u0007J\u0012\u0010A\u001a\u0002022\b\u0010B\u001a\u0004\u0018\u00010\u0004H\u0007R\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u00048G\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\r\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\f@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u001b\u0010\u0010\u001a\u00020\u00118FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\u0015\u001a\u0004\b\u0012\u0010\u0013R\u001b\u0010\u0016\u001a\u00020\u00178FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\u0015\u001a\u0004\b\u0018\u0010\u0019R&\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\u001b8\u0006@BX\u0087\u000e\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u001d\u0010\u0002\u001a\u0004\b\u001c\u0010\u001eR\u000e\u0010\u001f\u001a\u00020 X\u0082\u0004\u00a2\u0006\u0002\n\u0000R>\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!2\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u00020#0!8F@@X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u001e\u0010*\u001a\u00020)2\u0006\u0010\u0007\u001a\u00020)@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u001e\u0010.\u001a\u00020-2\u0006\u0010\u0007\u001a\u00020-@BX\u0086.\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100\u00a8\u0006C"}, d2={"Lru/ok/tracer/Tracer;", "", "()V", "appToken", "", "getAppToken", "()Ljava/lang/String;", "<set-?>", "Lru/ok/tracer/TracerApplicationInfo;", "applicationInfo", "getApplicationInfo", "()Lru/ok/tracer/TracerApplicationInfo;", "Landroid/content/Context;", "context", "getContext", "()Landroid/content/Context;", "dropManager", "Lru/ok/tracer/base/drop/DropManager;", "getDropManager", "()Lru/ok/tracer/base/drop/DropManager;", "dropManager$delegate", "Lkotlin/Lazy;", "httpClient", "Lru/ok/tracer/base/http/HttpClient;", "getHttpClient", "()Lru/ok/tracer/base/http/HttpClient;", "httpClient$delegate", "", "isDisabled", "isDisabled$annotations", "()Z", "isInitialized", "Ljava/util/concurrent/atomic/AtomicBoolean;", "", "Lru/ok/tracer/TracerFeature;", "Lru/ok/tracer/TracerConfiguration;", "runtimeConfigs", "getRuntimeConfigs", "()Ljava/util/Map;", "setRuntimeConfigs$tracer_commons_release", "(Ljava/util/Map;)V", "Lru/ok/tracer/session/SessionStateStorage;", "stateStorage", "getStateStorage", "()Lru/ok/tracer/session/SessionStateStorage;", "Lru/ok/tracer/session/TagsStorage;", "tagsStorage", "getTagsStorage", "()Lru/ok/tracer/session/TagsStorage;", "disable", "", "getLastSessionState", "Lru/ok/tracer/session/SessionState;", "init", "init$tracer_commons_release", "requestTracerConfiguration", "", "Lru/ok/tracer/HasTracerConfiguration;", "setCustomProperties", "map", "setCustomProperty", "key", "value", "setKey", "setKeys", "setUserId", "userId", "tracer-commons_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class Tracer {
    @NotNull
    public static final Tracer INSTANCE = new Tracer();
    private static volatile boolean isDisabled;
    private static TracerApplicationInfo applicationInfo;
    private static Context context;
    private static SessionStateStorage stateStorage;
    private static TagsStorage tagsStorage;
    @NotNull
    private static final AtomicBoolean isInitialized;
    @NotNull
    private static final Lazy httpClient$delegate;
    @NotNull
    private static final Lazy dropManager$delegate;
    @NotNull
    private static volatile Map<TracerFeature, ? extends TracerConfiguration> runtimeConfigs;

    private Tracer() {
    }

    public static final boolean isDisabled() {
        return isDisabled;
    }

    @JvmStatic
    public static /* synthetic */ void isDisabled$annotations() {
    }

    @NotNull
    public final TracerApplicationInfo getApplicationInfo() {
        TracerApplicationInfo tracerApplicationInfo = applicationInfo;
        if (tracerApplicationInfo != null) {
            return tracerApplicationInfo;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"applicationInfo");
        return null;
    }

    @NotNull
    public final Context getContext() {
        Context context = Tracer.context;
        if (context != null) {
            return context;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"context");
        return null;
    }

    @NotNull
    public final SessionStateStorage getStateStorage() {
        SessionStateStorage sessionStateStorage = stateStorage;
        if (sessionStateStorage != null) {
            return sessionStateStorage;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"stateStorage");
        return null;
    }

    @NotNull
    public final TagsStorage getTagsStorage() {
        TagsStorage tagsStorage = Tracer.tagsStorage;
        if (tagsStorage != null) {
            return tagsStorage;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"tagsStorage");
        return null;
    }

    @NotNull
    public final HttpClient getHttpClient() {
        Lazy lazy = httpClient$delegate;
        return (HttpClient)lazy.getValue();
    }

    @NotNull
    public final DropManager getDropManager() {
        Lazy lazy = dropManager$delegate;
        return (DropManager)lazy.getValue();
    }

    @NotNull
    public final Map<TracerFeature, TracerConfiguration> getRuntimeConfigs() {
        if (!isInitialized.get()) {
            throw new IllegalStateException("Tracer is not initialized");
        }
        return runtimeConfigs;
    }

    public final void setRuntimeConfigs$tracer_commons_release(@NotNull Map<TracerFeature, ? extends TracerConfiguration> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"<set-?>");
        runtimeConfigs = map2;
    }

    @JvmName(name="getAppToken")
    @Nullable
    public final String getAppToken() {
        if (isDisabled) {
            Logger.d$default("Tracer is disabled", null, 2, null);
            return null;
        }
        String string = CoreTracerConfiguration.Companion.get().getOverrideAppToken();
        if (string == null) {
            string = AppTokenUtils.getAppToken((Context)this.getContext());
        }
        return string;
    }

    @JvmStatic
    public static final void disable() {
        isDisabled = true;
        Logger.d$default("Tracer is disabled", null, 2, null);
    }

    /*
     * WARNING - void declaration
     */
    public final void init$tracer_commons_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (isInitialized.getAndSet(true)) {
            throw new IllegalStateException("Tracer already initialized!");
        }
        Tracer.context = context;
        if (context instanceof HasTracerConfiguration) {
            try {
                void $this$associateByTo$iv$iv;
                Iterable $this$associateBy$iv = this.requestTracerConfiguration((HasTracerConfiguration)context);
                boolean $i$f$associateBy = false;
                int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
                Iterable iterable = $this$associateBy$iv;
                Map destination$iv$iv = new LinkedHashMap(capacity$iv);
                boolean $i$f$associateByTo = false;
                for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                    void p0;
                    TracerConfiguration tracerConfiguration = (TracerConfiguration)element$iv$iv;
                    Map map2 = destination$iv$iv;
                    boolean bl = false;
                    map2.put(p0.getFeature(), element$iv$iv);
                }
                runtimeConfigs = destination$iv$iv;
            }
            catch (Exception ex) {
                Logger.e(ex);
            }
        } else {
            Logger.w$default("Application does not implement HasTracerConfiguration", null, 2, null);
        }
        CoreTracerConfiguration config = CoreTracerConfiguration.Companion.get();
        PackageManager packageManager = context.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"context.packageManager");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        PackageInfo packageInfo = PackageManagerCompat.getPackageInfoCompat((PackageManager)packageManager, (String)string, (int)0);
        String string2 = packageInfo.packageName;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageInfo.packageName");
        String string3 = packageInfo.versionName;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"packageInfo.versionName");
        long l = PackageInfoCompat.getLongVersionCodeCompat((PackageInfo)packageInfo);
        String string4 = BuildUuidUtils.getBuildUuid((Context)context);
        String string5 = config.getOverrideEnvironment$tracer_commons_release();
        if (string5 == null) {
            string5 = BuildUuidUtils.getBuildEnvironment((Context)context);
        }
        applicationInfo = new TracerApplicationInfo(string2, string3, l, string4, string5);
        ConfigStorage.INSTANCE.init$tracer_commons_release((Function0<? extends File>)((Function0)new Function0<File>(context){
            final /* synthetic */ Context $context;
            {
                this.$context = $context;
                super(0);
            }

            @NotNull
            public final File invoke() {
                return FilesKt.resolve((File)FileUtils.mkdirsChecked((File)TracerFiles.INSTANCE.getTracerDir(this.$context)), (String)"settings.data");
            }
        }));
        stateStorage = new SessionStateStorage(context);
        tagsStorage = new TagsStorage(context, config.getMaxKeysCount$tracer_commons_release());
        Map<String, String> initialKeys = config.getInitialKeys$tracer_commons_release();
        if (!initialKeys.isEmpty()) {
            this.getTagsStorage().setKeys$tracer_commons_release(initialKeys);
        }
        Logger.d$default("Tracer initialized!", null, 2, null);
        Context context2 = context.getApplicationContext();
        Intrinsics.checkNotNull((Object)context2, (String)"null cannot be cast to non-null type android.app.Application");
        Application application = (Application)context2;
        application.registerActivityLifecycleCallbacks((Application.ActivityLifecycleCallbacks)new TracerActivityLifecycleCallbacks(this.getStateStorage()));
    }

    @JvmStatic
    public static final void setUserId(@Nullable String userId) {
        try {
            INSTANCE.getStateStorage().setUserId$tracer_commons_release(userId);
        }
        catch (Exception ex) {
            Logger.e(ex);
        }
    }

    @JvmStatic
    public static final void setKey(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Tracer.setKeys(MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)value)));
    }

    @JvmStatic
    public static final void setKeys(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        if (isDisabled) {
            Logger.d$default("Tracer is disabled", null, 2, null);
            return;
        }
        try {
            INSTANCE.getTagsStorage().setKeys$tracer_commons_release(map2);
        }
        catch (Exception ex) {
            Logger.e(ex);
        }
    }

    @JvmStatic
    public static final void setCustomProperty(@NotNull String key, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Tracer.setCustomProperties(MapsKt.mapOf((Pair)TuplesKt.to((Object)key, (Object)value)));
    }

    @JvmStatic
    public static final void setCustomProperties(@NotNull Map<String, String> map2) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        if (isDisabled) {
            Logger.d$default("Tracer is disabled", null, 2, null);
            return;
        }
        try {
            INSTANCE.getStateStorage().setCustomProperties$tracer_commons_release(map2);
        }
        catch (Exception ex) {
            Logger.e(ex);
        }
    }

    @JvmStatic
    @Nullable
    public static final SessionState getLastSessionState() {
        SessionState sessionState;
        if (isDisabled) {
            Logger.d$default("Tracer is disabled", null, 2, null);
            return null;
        }
        try {
            sessionState = INSTANCE.getStateStorage().getPrevSessionState();
        }
        catch (Exception ex) {
            Logger.e(ex);
            return null;
        }
        return sessionState;
    }

    private final List<TracerConfiguration> requestTracerConfiguration(HasTracerConfiguration context) {
        return context.getTracerConfiguration();
    }

    static {
        isInitialized = new AtomicBoolean();
        httpClient$delegate = LazyKt.lazy((Function0)httpClient.2.INSTANCE);
        dropManager$delegate = LazyKt.lazy((Function0)dropManager.2.INSTANCE);
        runtimeConfigs = MapsKt.emptyMap();
    }
}

