/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.session;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.os.Build;
import android.provider.Settings;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.HostedTracerLibraryInfo;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.base.deviceid.DeviceIdUtils;
import ru.ok.tracer.base.manifest.TracerLiteManifestUtils;
import ru.ok.tracer.base.sessionuuuid.SessionUuidUtils;
import ru.ok.tracer.manifest.TracerLiteManifest;
import ru.ok.tracer.upload.SystemInfoKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u000e\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u0002\u001a\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0000\u001a\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u001a\b\u0010\t\u001a\u00020\bH\u0002\u001a\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"collectLibrariesInfo", "", "Lru/ok/tracer/HostedTracerLibraryInfo;", "createSystemState", "Lru/ok/tracer/SystemState;", "context", "Landroid/content/Context;", "isEmulator", "", "isInForeground", "isRooted", "tracer-commons_release"})
@JvmName(name="SystemStateUtils")
public final class SystemStateUtils {
    @NotNull
    public static final SystemState createSystemState(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        String string = Tracer.INSTANCE.getApplicationInfo().getVersionName();
        long l = Tracer.INSTANCE.getApplicationInfo().getLongVersionCode();
        String string2 = Tracer.INSTANCE.getApplicationInfo().getPackageName();
        String string3 = Tracer.INSTANCE.getApplicationInfo().getEnvironment();
        String string4 = Tracer.INSTANCE.getApplicationInfo().getBuildUuid();
        String string5 = SessionUuidUtils.getCurrentSessionUuid();
        String string6 = Build.MODEL;
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"MODEL");
        String string7 = DeviceIdUtils.getDeviceId((Context)context);
        String string8 = Build.MANUFACTURER;
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"MANUFACTURER");
        return new SystemState(string, l, string2, string3, string4, string5, string6, string7, string8, String.valueOf(Build.VERSION.SDK_INT), !SystemStateUtils.isInForeground(), SystemStateUtils.isRooted(context), SystemInfoKt.getSystemProperties(context), SystemStateUtils.collectLibrariesInfo());
    }

    private static final boolean isInForeground() {
        ActivityManager.RunningAppProcessInfo appProcessInfo = new ActivityManager.RunningAppProcessInfo();
        ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)appProcessInfo);
        return appProcessInfo.importance == 100 || appProcessInfo.importance == 200;
    }

    private static final boolean isRooted(Context context) {
        boolean bl;
        boolean isEmulator = SystemStateUtils.isEmulator(context);
        String buildTags = Build.TAGS;
        if (!isEmulator && buildTags != null && StringsKt.contains$default((CharSequence)buildTags, (CharSequence)"test-keys", (boolean)false, (int)2, null)) {
            bl = true;
        } else {
            File file = new File("/system/app/Superuser.apk");
            if (file.exists()) {
                bl = true;
            } else {
                file = new File("/system/xbin/su");
                bl = !isEmulator && file.exists();
            }
        }
        return bl;
    }

    private static final boolean isEmulator(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return Intrinsics.areEqual((Object)"sdk", (Object)Build.PRODUCT) || Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT) || androidId == null;
    }

    /*
     * WARNING - void declaration
     */
    private static final Set<HostedTracerLibraryInfo> collectLibrariesInfo() {
        void var3_3;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = TracerLiteManifestUtils.findTracerLiteManifests();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void manifest;
            TracerLiteManifest tracerLiteManifest = (TracerLiteManifest)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = manifest.namespace();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"manifest.namespace()");
            String string2 = manifest.versionName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"manifest.versionName()");
            collection.add(new HostedTracerLibraryInfo(string, string2, manifest.buildUuid(), manifest.environment()));
        }
        return CollectionsKt.toSet((Iterable)((List)var3_3));
    }
}

