/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.utils;

import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001:\u0001\u000fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\bH\u0016J\b\u0010\u000e\u001a\u00020\fH\u0002R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\t\u001a\u00060\nR\u00020\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/ok/tracer/utils/SequentialExecutor;", "Ljava/util/concurrent/Executor;", "delegate", "(Ljava/util/concurrent/Executor;)V", "isRunning", "Ljava/util/concurrent/atomic/AtomicBoolean;", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Ljava/lang/Runnable;", "queueRunnable", "Lru/ok/tracer/utils/SequentialExecutor$QueueRunnable;", "execute", "", "command", "run", "QueueRunnable", "tracer-commons_release"})
public final class SequentialExecutor
implements Executor {
    @NotNull
    private final Executor delegate;
    @NotNull
    private final ConcurrentLinkedQueue<Runnable> queue;
    @NotNull
    private final QueueRunnable queueRunnable;
    @NotNull
    private final AtomicBoolean isRunning;

    public SequentialExecutor(@NotNull Executor delegate) {
        Intrinsics.checkNotNullParameter((Object)delegate, (String)"delegate");
        this.delegate = delegate;
        this.queue = new ConcurrentLinkedQueue();
        this.queueRunnable = new QueueRunnable();
        this.isRunning = new AtomicBoolean(false);
    }

    @Override
    public void execute(@NotNull Runnable command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        this.queue.add(command);
        if (this.isRunning.compareAndSet(false, true)) {
            this.delegate.execute(this.queueRunnable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void run() {
        boolean bl;
        try {
            while (this.queue.poll() != null) {
                Runnable command;
                command.run();
            }
            this.isRunning.set(false);
            bl = !((Collection)this.queue).isEmpty();
        }
        catch (Throwable throwable) {
            this.isRunning.set(false);
            if (!((Collection)this.queue).isEmpty() && this.isRunning.compareAndSet(false, true)) {
                this.delegate.execute(this.queueRunnable);
            }
            throw throwable;
        }
        if (bl && this.isRunning.compareAndSet(false, true)) {
            this.delegate.execute(this.queueRunnable);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lru/ok/tracer/utils/SequentialExecutor$QueueRunnable;", "Ljava/lang/Runnable;", "(Lru/ok/tracer/utils/SequentialExecutor;)V", "run", "", "tracer-commons_release"})
    private final class QueueRunnable
    implements Runnable {
        @Override
        public void run() {
            SequentialExecutor.this.run();
        }
    }
}

