/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.ok.tracer.HostedTracerLibraryInfo;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.SystemStateSerializerKt;
import ru.ok.tracer.base.session.SessionId;
import ru.ok.tracer.base.sessionuuuid.SessionUuidUtils;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0018\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\u000b2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\bH\u0002J\u0010\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\tH\u0002J\u000e\u0010\u0011\u001a\u00020\u00062\u0006\u0010\u0012\u001a\u00020\u0004J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0012\u001a\u00020\u0004\u00a8\u0006\u0014"}, d2={"Lru/ok/tracer/SystemStateSerializer;", "", "()V", "fromJson", "Lru/ok/tracer/SystemState;", "jsonString", "", "librariesInfoFromJsonArray", "", "Lru/ok/tracer/HostedTracerLibraryInfo;", "librariesInfo", "Lorg/json/JSONArray;", "librariesInfoToJsonArray", "libraryInfoFromJsonObject", "libraryInfo", "Lorg/json/JSONObject;", "libraryInfoToJsonObject", "toJson", "systemState", "toJsonObject", "tracer-commons_release"})
public final class SystemStateSerializer {
    @NotNull
    public static final SystemStateSerializer INSTANCE = new SystemStateSerializer();

    private SystemStateSerializer() {
    }

    @NotNull
    public final String toJson(@NotNull SystemState systemState) {
        Intrinsics.checkNotNullParameter((Object)systemState, (String)"systemState");
        JSONObject json = this.toJsonObject(systemState);
        String string = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.toString()");
        return string;
    }

    @NotNull
    public final JSONObject toJsonObject(@NotNull SystemState systemState) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)systemState, (String)"systemState");
        JSONObject $this$toJsonObject_u24lambda_u240 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$toJsonObject_u24lambda_u240.put("versionName", (Object)systemState.getVersionName());
        $this$toJsonObject_u24lambda_u240.put("versionCode", systemState.getVersionCode());
        $this$toJsonObject_u24lambda_u240.put("packageName", (Object)systemState.getPackageName());
        $this$toJsonObject_u24lambda_u240.put("environment", (Object)systemState.getEnvironment());
        $this$toJsonObject_u24lambda_u240.put("buildUuid", (Object)systemState.getBuildUuid());
        $this$toJsonObject_u24lambda_u240.put("sessionUuid", (Object)systemState.getSessionId().getUuid());
        $this$toJsonObject_u24lambda_u240.put("sampled", systemState.getSessionId().getSampled());
        $this$toJsonObject_u24lambda_u240.put("device", (Object)systemState.getDevice());
        $this$toJsonObject_u24lambda_u240.put("deviceId", (Object)systemState.getDeviceId());
        $this$toJsonObject_u24lambda_u240.put("vendor", (Object)systemState.getVendor());
        $this$toJsonObject_u24lambda_u240.put("osVersion", (Object)systemState.getOsVersion());
        $this$toJsonObject_u24lambda_u240.put("inBackground", systemState.isInBackground());
        $this$toJsonObject_u24lambda_u240.put("isRooted", systemState.isRooted());
        $this$toJsonObject_u24lambda_u240.put("properties", (Object)new JSONObject(systemState.getProperties()));
        $this$toJsonObject_u24lambda_u240.put("hostedLibrariesInfo", (Object)INSTANCE.librariesInfoToJsonArray(systemState.getHostedLibrariesInfo()));
        return jSONObject;
    }

    private final JSONArray librariesInfoToJsonArray(Set<HostedTracerLibraryInfo> librariesInfo) {
        Object object;
        Collection collection = librariesInfo;
        if (collection == null || collection.isEmpty()) {
            object = null;
        } else {
            Collection $this$librariesInfoToJsonArray_u24lambda_u241 = collection = new JSONArray();
            boolean bl = false;
            for (HostedTracerLibraryInfo libraryInfo : librariesInfo) {
                $this$librariesInfoToJsonArray_u24lambda_u241.put(INSTANCE.libraryInfoToJsonObject(libraryInfo));
            }
            object = collection;
        }
        return object;
    }

    private final JSONObject libraryInfoToJsonObject(HostedTracerLibraryInfo libraryInfo) {
        JSONObject jSONObject;
        JSONObject $this$libraryInfoToJsonObject_u24lambda_u242 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$libraryInfoToJsonObject_u24lambda_u242.put("packageName", (Object)libraryInfo.getPackageName());
        $this$libraryInfoToJsonObject_u24lambda_u242.put("versionName", (Object)libraryInfo.getVersionName());
        $this$libraryInfoToJsonObject_u24lambda_u242.put("buildUuid", (Object)libraryInfo.getBuildUuid());
        $this$libraryInfoToJsonObject_u24lambda_u242.put("environment", (Object)libraryInfo.getEnvironment());
        return jSONObject;
    }

    @NotNull
    public final SystemState fromJson(@NotNull String jsonString) {
        String string;
        String string2;
        Object object;
        JSONArray namesJson;
        Intrinsics.checkNotNullParameter((Object)jsonString, (String)"jsonString");
        JSONObject obj = new JSONObject(jsonString);
        Map propsMap = new LinkedHashMap();
        JSONObject objProps = obj.getJSONObject("properties");
        JSONArray jSONArray = namesJson = objProps.names();
        int namesLen = jSONArray != null ? jSONArray.length() : 0;
        for (int i = 0; i < namesLen; ++i) {
            Object object2;
            Object object3 = namesJson;
            if (object3 == null || (object3 = object3.getString(i)) == null) continue;
            Object $this$fromJson_u24lambda_u243 = object2 = object3;
            boolean bl = false;
            object = propsMap;
            Intrinsics.checkNotNullExpressionValue((Object)objProps.getString((String)$this$fromJson_u24lambda_u243), (String)"objProps.getString(this)");
            object.put($this$fromJson_u24lambda_u243, string2);
        }
        String string3 = obj.getString("versionName");
        long l = obj.getLong("versionCode");
        Object p0 = object = obj.optString("packageName");
        boolean bl = false;
        Object object4 = ((CharSequence)p0).length() > 0 ? object : null;
        if (object4 == null) {
            object4 = SystemStateSerializerKt.access$getImpliedPackageName();
        }
        Object object5 = object4;
        p0 = object = obj.optString("environment");
        boolean bl2 = false;
        Object object6 = ((CharSequence)p0).length() > 0 ? object : null;
        String p02 = string2 = obj.optString("buildUuid");
        boolean bl3 = false;
        object = ((CharSequence)p02).length() > 0 ? string2 : null;
        String p03 = string = obj.optString("sessionUuid");
        boolean bl4 = false;
        String string4 = ((CharSequence)p03).length() > 0 ? string : null;
        if (string4 == null) {
            string4 = SessionUuidUtils.createSessionUuid();
        }
        boolean bl5 = obj.optBoolean("sampled", false);
        String string5 = string4;
        string2 = new SessionId(string5, bl5);
        String string6 = obj.getString("device");
        string = obj.getString("deviceId");
        String string7 = obj.getString("vendor");
        String string8 = obj.getString("osVersion");
        boolean bl6 = obj.getBoolean("inBackground");
        boolean bl7 = obj.getBoolean("isRooted");
        Set<HostedTracerLibraryInfo> set = this.librariesInfoFromJsonArray(obj.optJSONArray("hostedLibrariesInfo"));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getString(\"versionName\")");
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"getString(\"device\")");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(\"deviceId\")");
        Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getString(\"vendor\")");
        Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getString(\"osVersion\")");
        return new SystemState((SessionId)string2, string3, l, (String)object5, (String)object6, (String)object, string6, string, string7, string8, bl6, bl7, propsMap, set);
    }

    private final Set<HostedTracerLibraryInfo> librariesInfoFromJsonArray(JSONArray librariesInfo) {
        Set set;
        if (librariesInfo == null || librariesInfo.length() == 0) {
            set = SetsKt.emptySet();
        } else {
            Set set2;
            Set $this$librariesInfoFromJsonArray_u24lambda_u247 = set2 = SetsKt.createSetBuilder();
            boolean bl = false;
            int n = librariesInfo.length();
            for (int i = 0; i < n; ++i) {
                JSONObject libraryInfo = librariesInfo.getJSONObject(i);
                Collection collection = $this$librariesInfoFromJsonArray_u24lambda_u247;
                Intrinsics.checkNotNullExpressionValue((Object)libraryInfo, (String)"libraryInfo");
                collection.add(INSTANCE.libraryInfoFromJsonObject(libraryInfo));
            }
            set = SetsKt.build((Set)set2);
        }
        return set;
    }

    private final HostedTracerLibraryInfo libraryInfoFromJsonObject(JSONObject libraryInfo) {
        String p0;
        String string;
        String string2 = libraryInfo.getString("packageName");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"libraryInfo.getString(\"packageName\")");
        String string3 = libraryInfo.getString("versionName");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"libraryInfo.getString(\"versionName\")");
        String string4 = string = libraryInfo.optString("buildUuid");
        String string5 = string3;
        String string6 = string2;
        boolean bl = false;
        boolean bl2 = ((CharSequence)p0).length() > 0;
        String string7 = bl2 ? string : null;
        p0 = string = libraryInfo.optString("environment");
        String string8 = string7;
        boolean bl3 = false;
        boolean bl4 = ((CharSequence)p0).length() > 0;
        String string9 = bl4 ? string : null;
        String string10 = string8;
        String string11 = string5;
        String string12 = string6;
        return new HostedTracerLibraryInfo(string12, string11, string10, string9);
    }
}

