/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer;

import android.app.Activity;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.MainThread;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.session.SessionStateStorage;
import ru.ok.tracer.utils.DefaultActivityLifecycleCallbacks;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00142\u00020\u0001:\u0001\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\u0010\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0017J\b\u0010\u0012\u001a\u00020\u000eH\u0003J\b\u0010\u0013\u001a\u00020\u000eH\u0003R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/ok/tracer/TracerActivityLifecycleCallbacks;", "Lru/ok/tracer/utils/DefaultActivityLifecycleCallbacks;", "stateStorage", "Lru/ok/tracer/session/SessionStateStorage;", "(Lru/ok/tracer/session/SessionStateStorage;)V", "handler", "Landroid/os/Handler;", "onLastActivityStoppedRunnable", "Ljava/lang/Runnable;", "renewSessionAfterRealtime", "", "startedActivityCount", "", "onActivityStarted", "", "activity", "Landroid/app/Activity;", "onActivityStopped", "onFirstActivityStarted", "onLastActivityStopped", "Companion", "tracer-commons_release"})
public final class TracerActivityLifecycleCallbacks
implements DefaultActivityLifecycleCallbacks {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SessionStateStorage stateStorage;
    private int startedActivityCount;
    private long renewSessionAfterRealtime;
    @NotNull
    private final Handler handler;
    @NotNull
    private final Runnable onLastActivityStoppedRunnable;
    @Deprecated
    private static final long ACTIVITY_STOPPED_DEBOUNCE_MILLIS = 700L;
    @Deprecated
    private static final long RENEW_SESSION_TIMEOUT_MILLIS = TimeUnit.MINUTES.toMillis(30L);

    public TracerActivityLifecycleCallbacks(@NotNull SessionStateStorage stateStorage) {
        Intrinsics.checkNotNullParameter((Object)stateStorage, (String)"stateStorage");
        this.stateStorage = stateStorage;
        this.renewSessionAfterRealtime = Long.MAX_VALUE;
        this.handler = new Handler(Looper.getMainLooper());
        this.onLastActivityStoppedRunnable = this::onLastActivityStopped;
    }

    @Override
    @MainThread
    public void onActivityStarted(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (this.startedActivityCount == 0) {
            this.handler.removeCallbacks(this.onLastActivityStoppedRunnable);
            this.onFirstActivityStarted();
        }
        ++this.startedActivityCount;
    }

    @MainThread
    private final void onFirstActivityStarted() {
        if (this.renewSessionAfterRealtime < SystemClock.elapsedRealtime()) {
            SessionStateStorage.renewSession$tracer_commons_release$default(this.stateStorage, true, null, null, false, 6, null);
        } else {
            this.stateStorage.setCurrentlyInBackground$tracer_commons_release(false);
        }
    }

    @Override
    @MainThread
    public void onActivityStopped(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        --this.startedActivityCount;
        if (this.startedActivityCount == 0) {
            this.handler.postDelayed(this.onLastActivityStoppedRunnable, 700L);
        }
    }

    @MainThread
    private final void onLastActivityStopped() {
        if (CoreTracerConfiguration.Companion.get().getRenewSessionInBackgroundEnabled$tracer_commons_release()) {
            this.renewSessionAfterRealtime = SystemClock.elapsedRealtime() - 700L + RENEW_SESSION_TIMEOUT_MILLIS;
        }
        this.stateStorage.setCurrentlyInBackground$tracer_commons_release(true);
    }

    @Override
    public void onActivityCreated(@NotNull Activity activity, @Nullable Bundle savedInstanceState) {
        DefaultActivityLifecycleCallbacks.DefaultImpls.onActivityCreated(this, activity, savedInstanceState);
    }

    @Override
    public void onActivityResumed(@NotNull Activity activity) {
        DefaultActivityLifecycleCallbacks.DefaultImpls.onActivityResumed(this, activity);
    }

    @Override
    public void onActivityPaused(@NotNull Activity activity) {
        DefaultActivityLifecycleCallbacks.DefaultImpls.onActivityPaused(this, activity);
    }

    @Override
    public void onActivitySaveInstanceState(@NotNull Activity activity, @NotNull Bundle outState) {
        DefaultActivityLifecycleCallbacks.DefaultImpls.onActivitySaveInstanceState(this, activity, outState);
    }

    @Override
    public void onActivityDestroyed(@NotNull Activity activity) {
        DefaultActivityLifecycleCallbacks.DefaultImpls.onActivityDestroyed(this, activity);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lru/ok/tracer/TracerActivityLifecycleCallbacks$Companion;", "", "()V", "ACTIVITY_STOPPED_DEBOUNCE_MILLIS", "", "RENEW_SESSION_TIMEOUT_MILLIS", "tracer-commons_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

