/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.content.Context;
import android.os.Build;
import java.io.Closeable;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.base.process.ProcessUtils;
import ru.ok.tracer.crash.report.CrashStorage;
import ru.ok.tracer.crash.report.LogStorage;
import ru.ok.tracer.crash.report.ReportType;
import ru.ok.tracer.session.SessionState;
import ru.ok.tracer.session.SessionStateStorage;
import ru.ok.tracer.session.TagsStorage;
import ru.ok.tracer.utils.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e\u00a8\u0006\u000f"}, d2={"Lru/ok/tracer/crash/report/AnrReporter;", "", "()V", "check", "", "context", "Landroid/content/Context;", "stateStorage", "Lru/ok/tracer/session/SessionStateStorage;", "tagsStorage", "Lru/ok/tracer/session/TagsStorage;", "logStorage", "Lru/ok/tracer/crash/report/LogStorage;", "crashStorage", "Lru/ok/tracer/crash/report/CrashStorage;", "tracer-crash-report_release"})
public final class AnrReporter {
    @NotNull
    public static final AnrReporter INSTANCE = new AnrReporter();

    private AnrReporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void check(@NotNull Context context, @NotNull SessionStateStorage stateStorage, @NotNull TagsStorage tagsStorage, @NotNull LogStorage logStorage, @NotNull CrashStorage crashStorage) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)stateStorage, (String)"stateStorage");
        Intrinsics.checkNotNullParameter((Object)tagsStorage, (String)"tagsStorage");
        Intrinsics.checkNotNullParameter((Object)logStorage, (String)"logStorage");
        Intrinsics.checkNotNullParameter((Object)crashStorage, (String)"crashStorage");
        if (Build.VERSION.SDK_INT < 30) {
            return;
        }
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager activityManager = (ActivityManager)object;
        try {
            list = activityManager.getHistoricalProcessExitReasons(null, 0, 0);
        }
        catch (Exception e) {
            Logger.e((Throwable)e);
            return;
        }
        List list2 = list;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"try {\n            activi\u2026         return\n        }");
        List exitReasons = list2;
        String processName = ProcessUtils.getProcessName((Context)context);
        for (ApplicationExitInfo exitReason : exitReasons) {
            Object[] objectArray;
            Object object2;
            Object object3;
            Object object4;
            if (exitReason.getReason() != 6) continue;
            if (!Intrinsics.areEqual((Object)exitReason.getProcessName(), (Object)processName)) {
                Object[] objectArray2 = new Object[]{exitReason.getProcessName(), processName};
                Logger.d((String)"Skip ANR from other process: their %s vs my %s", (Object[])objectArray2);
                continue;
            }
            long prevStartTs = stateStorage.getPrevStartTs();
            if (exitReason.getTimestamp() < prevStartTs) {
                Object[] objectArray3 = new Object[]{exitReason.getTimestamp(), prevStartTs};
                Logger.d((String)"Skip old ANR. AnrTs: %s, SessionTs: %s", (Object[])objectArray3);
                continue;
            }
            try {
                byte[] byArray;
                InputStream inputStream = exitReason.getTraceInputStream();
                if (inputStream != null) {
                    object4 = inputStream;
                    object3 = null;
                    try {
                        InputStream it = (InputStream)object4;
                        boolean bl = false;
                        object2 = ByteStreamsKt.readBytes((InputStream)it);
                        byArray = object2;
                    }
                    catch (Throwable throwable) {
                        object3 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object4, (Throwable)object3);
                    }
                } else {
                    byArray = null;
                }
                objectArray = byArray;
            }
            catch (Exception e) {
                Logger.e((Throwable)e);
                objectArray = null;
            }
            byte[] anrBytes = objectArray;
            if (anrBytes == null || anrBytes.length == 0) {
                Logger.w$default((String)("ANR with empty trace. " + exitReason.getDescription()), null, (int)2, null);
                continue;
            }
            objectArray = new Object[1];
            objectArray[0] = (byte)exitReason.getTimestamp();
            Logger.d((String)"Spotted ANR  ts: %s", (Object[])objectArray);
            SystemState prevSystemState = stateStorage.getPrevSystemState();
            if (prevSystemState == null) {
                Logger.w$default((String)"No prevSystemState", null, (int)2, null);
                continue;
            }
            object4 = ReportType.ANR;
            object3 = logStorage.getPrevLogs();
            object2 = tagsStorage.getPrevTags();
            CrashStorage.save$default(crashStorage, (ReportType)((Object)object4), anrBytes, prevSystemState, (List)object2, null, (List)object3, 16, null);
            stateStorage.setPrevSessionStatus(SessionState.Status.ANR);
        }
    }
}

