/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.os.Looper;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.LogLevel;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.drop.DropManager;
import ru.ok.tracer.crash.report.CrashDescription;
import ru.ok.tracer.crash.report.CrashStorage;
import ru.ok.tracer.crash.report.CrashUploader;
import ru.ok.tracer.crash.report.FEATURE_CRASH_REPORTKt;
import ru.ok.tracer.crash.report.LogStorage;
import ru.ok.tracer.crash.report.ReportType;
import ru.ok.tracer.crash.report.SessionStateUploader;
import ru.ok.tracer.crash.report.TracerCrashReport;
import ru.ok.tracer.session.SessionState;
import ru.ok.tracer.session.SessionStateStorage;
import ru.ok.tracer.session.TagsStorage;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerThreads;
import ru.ok.tracer.utils.config.ConfigStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018J\u000e\u0010\u0019\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020\u001bJ\"\u0010\u001c\u001a\u00020\u00162\b\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\u0006\u0010\u001a\u001a\u00020\u001b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0018J\u0016\u0010 \u001a\u00020!*\u00020!2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0018H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\u00020\u00108BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lru/ok/tracer/crash/report/CrashLoggerInternal;", "", "crashStorage", "Lru/ok/tracer/crash/report/CrashStorage;", "stateStorage", "Lru/ok/tracer/session/SessionStateStorage;", "tagsStorage", "Lru/ok/tracer/session/TagsStorage;", "logStorage", "Lru/ok/tracer/crash/report/LogStorage;", "stateUploader", "Lru/ok/tracer/crash/report/SessionStateUploader;", "crashUploader", "Lru/ok/tracer/crash/report/CrashUploader;", "(Lru/ok/tracer/crash/report/CrashStorage;Lru/ok/tracer/session/SessionStateStorage;Lru/ok/tracer/session/TagsStorage;Lru/ok/tracer/crash/report/LogStorage;Lru/ok/tracer/crash/report/SessionStateUploader;Lru/ok/tracer/crash/report/CrashUploader;)V", "dropManager", "Lru/ok/tracer/base/drop/DropManager;", "getDropManager", "()Lru/ok/tracer/base/drop/DropManager;", "nonFatalCounter", "", "log", "", "message", "", "reportCrash", "e", "", "reportNonFatal", "logLevel", "Lru/ok/tracer/LogLevel;", "issueKey", "withIssueKey", "Lru/ok/tracer/SystemState;", "tracer-crash-report_release"})
public final class CrashLoggerInternal {
    @NotNull
    private final CrashStorage crashStorage;
    @NotNull
    private final SessionStateStorage stateStorage;
    @NotNull
    private final TagsStorage tagsStorage;
    @NotNull
    private final LogStorage logStorage;
    @NotNull
    private final SessionStateUploader stateUploader;
    @NotNull
    private final CrashUploader crashUploader;
    private volatile int nonFatalCounter;

    public CrashLoggerInternal(@NotNull CrashStorage crashStorage, @NotNull SessionStateStorage stateStorage, @NotNull TagsStorage tagsStorage, @NotNull LogStorage logStorage, @NotNull SessionStateUploader stateUploader, @NotNull CrashUploader crashUploader) {
        Intrinsics.checkNotNullParameter((Object)crashStorage, (String)"crashStorage");
        Intrinsics.checkNotNullParameter((Object)stateStorage, (String)"stateStorage");
        Intrinsics.checkNotNullParameter((Object)tagsStorage, (String)"tagsStorage");
        Intrinsics.checkNotNullParameter((Object)logStorage, (String)"logStorage");
        Intrinsics.checkNotNullParameter((Object)stateUploader, (String)"stateUploader");
        Intrinsics.checkNotNullParameter((Object)crashUploader, (String)"crashUploader");
        this.crashStorage = crashStorage;
        this.stateStorage = stateStorage;
        this.tagsStorage = tagsStorage;
        this.logStorage = logStorage;
        this.stateUploader = stateUploader;
        this.crashUploader = crashUploader;
    }

    private final DropManager getDropManager() {
        return Tracer.INSTANCE.getDropManager();
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.logStorage.log(message);
    }

    public final void reportCrash(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (TracerCrashReport.INSTANCE.isDisabled$tracer_crash_report_release()) {
            Logger.v$default((String)"Crash report disabled", null, (int)2, null);
            return;
        }
        this.stateStorage.setCurrentSessionStatus(SessionState.Status.CRASH);
        if (ConfigStorage.isLimited$default((ConfigStorage)ConfigStorage.INSTANCE, (TracerFeature)FEATURE_CRASH_REPORTKt.getFEATURE_CRASH_REPORT(), null, (int)2, null)) {
            Logger.d$default((String)"Crash reporting limited", null, (int)2, null);
            return;
        }
        SystemState systemState = this.stateStorage.getCurrentSystemState();
        List list = this.tagsStorage.getTags();
        Map<Thread, StackTraceElement[]> map = Thread.getAllStackTraces();
        Intrinsics.checkNotNullExpressionValue(map, (String)"getAllStackTraces()");
        CrashDescription description = this.crashStorage.save(ReportType.CRASH, e, systemState, (List<String>)list, map, this.logStorage.getLogs());
        if (description != null) {
            CountDownLatch lock = new CountDownLatch(1);
            TracerThreads.INSTANCE.runOnIo(() -> CrashLoggerInternal.reportCrash$lambda$0(this, description, lock));
            long timeout = Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper()) ? 5000L : 100000000L;
            boolean sessionUploaded = this.stateUploader.waitSessionUpload(timeout);
            Object[] objectArray = new Object[]{sessionUploaded};
            Logger.d((String)"Is session uploaded before crash? %s", (Object[])objectArray);
            if (lock.await(timeout, TimeUnit.MILLISECONDS)) {
                Logger.d$default((String)"Crash uploaded asap", null, (int)2, null);
            } else {
                Logger.d$default((String)"Can't upload crash asap", null, (int)2, null);
            }
        }
    }

    public final void reportNonFatal(@Nullable LogLevel logLevel, @NotNull Throwable e, @Nullable String issueKey) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (TracerCrashReport.INSTANCE.isDisabled$tracer_crash_report_release()) {
            Logger.v$default((String)"Crash report disabled", null, (int)2, null);
            return;
        }
        this.stateStorage.ensureCurrentSessionMaxLogLevel(logLevel);
        if (ConfigStorage.isLimited$default((ConfigStorage)ConfigStorage.INSTANCE, (TracerFeature)FEATURE_CRASH_REPORTKt.getFEATURE_CRASH_REPORT(), null, (int)2, null)) {
            Logger.d$default((String)"Crash reporting limited", null, (int)2, null);
            return;
        }
        int n = this.nonFatalCounter;
        this.nonFatalCounter = n + 1;
        if (n > 8) {
            Logger.d$default((String)"Can't handle non fatal exception. Max non fatal count is reached for this session.", null, (int)2, null);
            TracerThreads.INSTANCE.runOnIo(() -> CrashLoggerInternal.reportNonFatal$lambda$1(this));
            return;
        }
        LogLevel logLevel2 = logLevel;
        CrashDescription description = CrashStorage.save$default(this.crashStorage, Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.FATAL) ? ReportType.FATAL : (Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.ERROR) ? ReportType.ERROR : (Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.WARNING) ? ReportType.WARNING : (Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.NOTICE) ? ReportType.NOTICE : (Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.INFO) ? ReportType.INFO : (Intrinsics.areEqual((Object)logLevel2, (Object)LogLevel.DEBUG) ? ReportType.DEBUG : ReportType.NON_FATAL))))), e, this.withIssueKey(this.stateStorage.getCurrentSystemState(), issueKey), this.tagsStorage.getTags(), null, this.logStorage.getLogs(), 16, null);
        if (description != null) {
            TracerThreads.INSTANCE.runOnIo(() -> CrashLoggerInternal.reportNonFatal$lambda$2(this, description));
        }
    }

    private final SystemState withIssueKey(SystemState $this$withIssueKey, String issueKey) {
        CharSequence charSequence = issueKey;
        if (charSequence == null || charSequence.length() == 0) {
            return $this$withIssueKey;
        }
        return SystemState.copy$default((SystemState)$this$withIssueKey, null, (long)0L, null, null, null, null, null, null, null, null, (boolean)false, (boolean)false, (Map)MapsKt.plus((Map)$this$withIssueKey.getProperties(), (Pair)TuplesKt.to((Object)"issueKey", (Object)issueKey)), null, (int)12287, null);
    }

    private static final void reportCrash$lambda$0(CrashLoggerInternal this$0, CrashDescription $description, CountDownLatch $lock) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$lock, (String)"$lock");
        this$0.crashUploader.upload(CollectionsKt.listOf((Object)$description));
        $lock.countDown();
    }

    private static final void reportNonFatal$lambda$1(CrashLoggerInternal this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        DropManager.drop$default((DropManager)this$0.getDropManager(), (String)"non_fatal", (String)"max_non_fatals_per_session_reached", (int)0, (int)4, null);
    }

    private static final void reportNonFatal$lambda$2(CrashLoggerInternal this$0, CrashDescription $description) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.crashUploader.upload(CollectionsKt.listOf((Object)$description));
    }
}

