/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.net.Uri;
import android.util.Log;
import java.io.Closeable;
import java.io.File;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.base.drop.DropManager;
import ru.ok.tracer.base.drop.DropRecord;
import ru.ok.tracer.base.drop.DropRecordSerializer;
import ru.ok.tracer.base.http.HttpMultipartBodyBuilder;
import ru.ok.tracer.base.http.HttpRequest;
import ru.ok.tracer.base.http.HttpRequestBody;
import ru.ok.tracer.base.http.HttpResponse;
import ru.ok.tracer.base.http.HttpResponseBody;
import ru.ok.tracer.base.io.GZIPUtils;
import ru.ok.tracer.crash.report.CrashDescription;
import ru.ok.tracer.crash.report.FEATURE_CRASH_REPORTKt;
import ru.ok.tracer.crash.report.ReportType;
import ru.ok.tracer.upload.NetworkResponseHandler;
import ru.ok.tracer.utils.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nJ\"\u0010\u0007\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0010\b\u0002\u0010\r\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\u000eH\u0002R\u0014\u0010\u0003\u001a\u00020\u00048BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0010"}, d2={"Lru/ok/tracer/crash/report/CrashUploader;", "", "()V", "dropManager", "Lru/ok/tracer/base/drop/DropManager;", "getDropManager", "()Lru/ok/tracer/base/drop/DropManager;", "upload", "", "crashDescriptions", "", "Lru/ok/tracer/crash/report/CrashDescription;", "descr", "drops", "", "Lru/ok/tracer/base/drop/DropRecord;", "tracer-crash-report_release"})
public final class CrashUploader {
    private final DropManager getDropManager() {
        return Tracer.INSTANCE.getDropManager();
    }

    public final void upload(@NotNull List<CrashDescription> crashDescriptions) {
        Intrinsics.checkNotNullParameter(crashDescriptions, (String)"crashDescriptions");
        Object[] objectArray = new Object[]{crashDescriptions.size()};
        Logger.d((String)"Has %s crashes for upload.", (Object[])objectArray);
        int n = crashDescriptions.size();
        for (int i = 0; i < n; ++i) {
            CrashDescription crashDescription = crashDescriptions.get(i);
            Collection drops = i == 0 ? this.getDropManager().take() : null;
            try {
                this.upload(crashDescription, drops);
                crashDescription.delete();
                continue;
            }
            catch (Throwable t) {
                Logger.e((Throwable)t);
                if (drops == null) continue;
                this.getDropManager().drop(drops);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void upload(CrashDescription descr, Collection<DropRecord> drops) {
        var3_3 = new Object[]{descr};
        Logger.d((String)"Uploading crash: %s", (Object[])var3_3);
        appToken = Tracer.INSTANCE.getAppToken();
        if (appToken == null) {
            Logger.w$default((String)"No app token", null, (int)2, null);
            return;
        }
        systemInfoFile = new File(descr.getSystemStatePath());
        if (!systemInfoFile.exists()) {
            Logger.e$default((String)"System info not exists", null, (int)2, null);
            return;
        }
        systemStateJson = FilesKt.readText$default((File)systemInfoFile, null, (int)1, null);
        p0 = var7_6 = new File(descr.getTagsPath());
        $i$a$-takeIf-CrashUploader$upload$tagsFile$1 = false;
        v0 = tagsFile = p0.exists() != false ? var7_6 : null;
        tagsJson = v0 != null ? FilesKt.readText$default((File)v0, null, (int)1, null) : null;
        $this$upload_u24lambda_u240 = var10_11 = new JSONObject(systemStateJson);
        $i$a$-apply-CrashUploader$upload$uploadBean$1 = false;
        if (tagsJson != null) {
            $this$upload_u24lambda_u240.put("tags", (Object)new JSONArray(tagsJson));
        }
        v1 = var10_11.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"JSONObject(systemStateJs\u2026}\n            .toString()");
        uploadBean = v1;
        stacktraceFile = new File(descr.getStacktracePath());
        stacktraceFileCompressed = GZIPUtils.readBytesToGzippedByteArray((File)stacktraceFile);
        allStacktraceFile = new File(descr.getAllStacktracesPath());
        allStacktraceFileCompressed = allStacktraceFile.exists() != false ? GZIPUtils.readBytesToGzippedByteArray((File)allStacktraceFile) : (byte[])null;
        logsFile = new File(descr.getLogsPath());
        logsFileCompressed = logsFile.exists() != false ? GZIPUtils.readBytesToGzippedByteArray((File)logsFile) : (byte[])null;
        v2 /* !! */  = drops;
        if (v2 /* !! */  == null) ** GOTO lbl-1000
        p0 = var17_17 = v2 /* !! */ ;
        $i$a$-takeIf-CrashUploader$upload$dropsString$1 = false;
        v2 /* !! */  = p0.isEmpty() == false != false ? var17_17 : null;
        if (v2 /* !! */  == null) ** GOTO lbl-1000
        p0 = v2 /* !! */ ;
        $i$a$-takeIf-CrashUploader$upload$dropsString$1 = DropRecordSerializer.INSTANCE;
        p0 = p0;
        $i$a$-let-CrashUploader$upload$dropsString$2 = false;
        v3 = $i$a$-takeIf-CrashUploader$upload$dropsString$1.toJsonArray(p0);
        v2 /* !! */  = v3;
        if (v3 != null) {
            v4 = v2 /* !! */ .toString();
        } else lbl-1000:
        // 3 sources

        {
            v4 = null;
        }
        dropsString = v4;
        type = descr.getType();
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                v5 = "file";
                break;
            }
            default: {
                v5 = "stackTrace";
            }
        }
        contentName = v5;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: 
            case 2: {
                v6 = "file.gzip";
                break;
            }
            default: {
                v6 = "stack.gzip";
            }
        }
        contentFileName = v6;
        switch (WhenMappings.$EnumSwitchMapping$0[type.ordinal()]) {
            case 1: {
                v7 = "api/crash/uploadNative";
                break;
            }
            case 2: {
                v7 = "api/crash/uploadAnr";
                break;
            }
            default: {
                v7 = "api/crash/upload";
            }
        }
        path = v7;
        p0 = CoreTracerConfiguration.Companion.get().getApiUrl();
        $i$a$-let-CrashUploader$upload$url$1 = false;
        v8 = Uri.parse((String)p0).buildUpon().appendEncodedPath(path).appendQueryParameter("crashToken", appToken).toString();
        Intrinsics.checkNotNullExpressionValue((Object)v8, (String)"CoreTracerConfiguration.\u2026)\n            .toString()");
        url = v8;
        this_$iv = HttpMultipartBodyBuilder.Companion;
        $i$f$build = false;
        var25_35 = $i$a$-let-CrashUploader$upload$url$1 = new HttpMultipartBodyBuilder();
        var31_37 = url;
        $i$a$-build-CrashUploader$upload$request$1 = false;
        $this$upload_u24lambda_u244.addString("type", type.getApiType());
        if (type.getApiLogLevel() != null) {
            $this$upload_u24lambda_u244.addString("logLevel", type.getApiLogLevel());
        }
        $this$upload_u24lambda_u244.add(contentName, contentFileName, HttpRequestBody.Companion.fromBytes("application/octet-stream", stacktraceFileCompressed));
        HttpMultipartBodyBuilder.add$default((HttpMultipartBodyBuilder)$this$upload_u24lambda_u244, (String)"uploadBean", null, (HttpRequestBody)HttpRequestBody.Companion.fromString$default((HttpRequestBody.Companion)HttpRequestBody.Companion, (String)"application/json; charset=utf-8", (String)uploadBean, null, (int)4, null), (int)2, null);
        if (allStacktraceFileCompressed != null) {
            $this$upload_u24lambda_u244.add("threadDump", "threads.gzip", HttpRequestBody.Companion.fromBytes("application/octet-stream", allStacktraceFileCompressed));
        }
        if (logsFileCompressed != null) {
            $this$upload_u24lambda_u244.add("logs", "logs.gzip", HttpRequestBody.Companion.fromBytes("application/octet-stream", logsFileCompressed));
        }
        if (dropsString != null) {
            $this$upload_u24lambda_u244.add("drops", "drops.json", HttpRequestBody.Companion.fromString$default((HttpRequestBody.Companion)HttpRequestBody.Companion, (String)"application/json", (String)dropsString, null, (int)4, null));
        }
        var32_39 = $i$a$-let-CrashUploader$upload$url$1.build();
        var33_40 = var31_37;
        request = new HttpRequest(var33_40, var32_39);
        var22_34 /* !! */  = new Object[]{request};
        Logger.d((String)"Request: %s", (Object[])var22_34 /* !! */ );
        var22_34 /* !! */  = (Closeable)Tracer.INSTANCE.getHttpClient().execute(request);
        var23_29 = null;
        try {
            response = (HttpResponse)var22_34 /* !! */ ;
            $i$a$-use-CrashUploader$upload$1 = false;
            responseCode = response.getStatusCode();
            responseMessage = response.getMessage();
            v9 = response.getBody();
            responseContentType = v9 != null ? v9.getContentType() : null;
            v10 /* !! */  = response.getBody();
            if (v10 /* !! */  == null) ** GOTO lbl-1000
            v11 = v10 /* !! */ .getBytes();
            v10 /* !! */  = (HttpResponseBody)v11;
            if (v11 != null) {
                v12 = StringsKt.decodeToString((byte[])v10 /* !! */ );
            } else lbl-1000:
            // 2 sources

            {
                v12 = null;
            }
            responseBody = v12;
            NetworkResponseHandler.universalHandleResponse$default((NetworkResponseHandler)NetworkResponseHandler.INSTANCE, (String)responseContentType, (String)responseBody, (String)FEATURE_CRASH_REPORTKt.getFEATURE_CRASH_REPORT().getName(), null, (int)8, null);
            if (responseCode != 200) {
                v13 = Log.e((String)"Tracer", (String)(responseMessage + " , " + responseBody));
            } else {
                var30_44 = new Object[]{"Result: " + responseBody};
                Logger.d((String)"Tracer", (Object[])var30_44);
                v13 = Unit.INSTANCE;
            }
            var24_31 = v13;
        }
        catch (Throwable var24_32) {
            var23_29 = var24_32;
            throw var24_32;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var22_34 /* !! */ , (Throwable)var23_29);
        }
    }

    static /* synthetic */ void upload$default(CrashUploader crashUploader, CrashDescription crashDescription, Collection collection, int n, Object object) {
        if ((n & 2) != 0) {
            collection = null;
        }
        crashUploader.upload(crashDescription, collection);
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ReportType.values().length];
            try {
                nArray[ReportType.MINIDUMP.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ReportType.ANR.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

