/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.content.Context;
import android.os.Build;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.base.process.ProcessUtils;
import ru.ok.tracer.crash.report.AnrSnapshotStorage;
import ru.ok.tracer.crash.report.CrashStorage;
import ru.ok.tracer.crash.report.LogStorage;
import ru.ok.tracer.crash.report.ReportType;
import ru.ok.tracer.session.SessionState;
import ru.ok.tracer.session.SessionStateStorage;
import ru.ok.tracer.session.TagsStorage;
import ru.ok.tracer.utils.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010\u00a8\u0006\u0011"}, d2={"Lru/ok/tracer/crash/report/AnrReporter;", "", "()V", "check", "", "context", "Landroid/content/Context;", "stateStorage", "Lru/ok/tracer/session/SessionStateStorage;", "tagsStorage", "Lru/ok/tracer/session/TagsStorage;", "logStorage", "Lru/ok/tracer/crash/report/LogStorage;", "crashStorage", "Lru/ok/tracer/crash/report/CrashStorage;", "snapshotStorage", "Lru/ok/tracer/crash/report/AnrSnapshotStorage;", "tracer-crash-report_release"})
public final class AnrReporter {
    @NotNull
    public static final AnrReporter INSTANCE = new AnrReporter();

    private AnrReporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void check(@NotNull Context context, @NotNull SessionStateStorage stateStorage, @NotNull TagsStorage tagsStorage, @NotNull LogStorage logStorage, @NotNull CrashStorage crashStorage, @NotNull AnrSnapshotStorage snapshotStorage) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)stateStorage, (String)"stateStorage");
        Intrinsics.checkNotNullParameter((Object)tagsStorage, (String)"tagsStorage");
        Intrinsics.checkNotNullParameter((Object)logStorage, (String)"logStorage");
        Intrinsics.checkNotNullParameter((Object)crashStorage, (String)"crashStorage");
        Intrinsics.checkNotNullParameter((Object)snapshotStorage, (String)"snapshotStorage");
        if (Build.VERSION.SDK_INT < 30) {
            return;
        }
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager activityManager = (ActivityManager)object;
        try {
            list = activityManager.getHistoricalProcessExitReasons(null, 0, 0);
        }
        catch (Exception e) {
            Logger.e((Throwable)e);
            return;
        }
        List list2 = list;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"try {\n            activi\u2026         return\n        }");
        List exitReasons = list2;
        String processName = ProcessUtils.getProcessName((Context)context);
        for (ApplicationExitInfo exitReason : exitReasons) {
            byte[] byArray;
            String string;
            CharSequence charSequence;
            Object object2;
            if (exitReason.getReason() != 6) continue;
            if (!Intrinsics.areEqual((Object)exitReason.getProcessName(), (Object)processName)) {
                Object[] objectArray = new Object[]{exitReason.getProcessName(), processName};
                Logger.d((String)"Skip ANR from other process: their %s vs my %s", (Object[])objectArray);
                continue;
            }
            long prevStartTs = stateStorage.getPrevStartTs();
            if (exitReason.getTimestamp() < prevStartTs) {
                Object[] objectArray = new Object[]{exitReason.getTimestamp(), prevStartTs};
                Logger.d((String)"Skip old ANR. AnrTs: %s, SessionTs: %s", (Object[])objectArray);
                continue;
            }
            try {
                Object object3;
                InputStream inputStream = exitReason.getTraceInputStream();
                if (inputStream != null) {
                    Closeable closeable = inputStream;
                    Object object4 = Charsets.UTF_8;
                    object2 = new InputStreamReader((InputStream)closeable, (Charset)object4);
                    int n = 8192;
                    closeable = object2 instanceof BufferedReader ? (BufferedReader)object2 : new BufferedReader((Reader)object2, n);
                    object4 = null;
                    try {
                        BufferedReader it = (BufferedReader)closeable;
                        boolean bl = false;
                        object2 = TextStreamsKt.readText((Reader)it);
                        object3 = object2;
                    }
                    catch (Throwable throwable) {
                        object4 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)closeable, (Throwable)object4);
                    }
                } else {
                    object3 = null;
                }
                charSequence = object3;
            }
            catch (Exception e) {
                Logger.e((Throwable)e);
                charSequence = null;
            }
            String anrTrace = charSequence;
            charSequence = anrTrace;
            if (charSequence == null || charSequence.length() == 0) {
                Logger.w$default((String)("ANR with empty trace. " + exitReason.getDescription()), null, (int)2, null);
                continue;
            }
            charSequence = new Object[]{exitReason.getTimestamp()};
            Logger.d((String)"Spotted ANR  ts: %s", (Object[])charSequence);
            SystemState prevSystemState = stateStorage.getPrevSystemState();
            if (prevSystemState == null) {
                Logger.w$default((String)"No prevSystemState", null, (int)2, null);
                continue;
            }
            List<AnrSnapshotStorage.ThreadSnapshot> allStackTraces = snapshotStorage.readAll();
            int indexOfEndFirstThread = StringsKt.indexOf$default((CharSequence)anrTrace, (String)"DumpLatencyMs", (int)0, (boolean)false, (int)6, null);
            if (allStackTraces.isEmpty()) {
                string = anrTrace;
            } else if (indexOfEndFirstThread < 0) {
                string = anrTrace;
            } else {
                Object $this$check_u24lambda_u241 = object2 = new StringBuilder();
                boolean bl = false;
                int indexOfSecondThread = StringsKt.indexOf$default((CharSequence)anrTrace, (String)"\n", (int)indexOfEndFirstThread, (boolean)false, (int)4, null);
                StringBuilder stringBuilder = ((StringBuilder)$this$check_u24lambda_u241).append(anrTrace, 0, indexOfSecondThread + 1);
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder, (String)"append(anrTrace, 0, indexOfSecondThread + 1)");
                Intrinsics.checkNotNullExpressionValue((Object)stringBuilder.append('\n'), (String)"append('\\n')");
                for (AnrSnapshotStorage.ThreadSnapshot stackTrace : allStackTraces) {
                    ((StringBuilder)$this$check_u24lambda_u241).append("\"SNAPSHOT main\" tid=1 (");
                    ((StringBuilder)$this$check_u24lambda_u241).append(exitReason.getTimestamp() - stackTrace.getTimestamp$tracer_crash_report_release()).append("ms before");
                    ((StringBuilder)$this$check_u24lambda_u241).append(")\n");
                    ((StringBuilder)$this$check_u24lambda_u241).append(stackTrace.getStack$tracer_crash_report_release());
                    Intrinsics.checkNotNullExpressionValue((Object)((StringBuilder)$this$check_u24lambda_u241).append('\n'), (String)"append('\\n')");
                }
                ((StringBuilder)$this$check_u24lambda_u241).append(anrTrace, indexOfSecondThread + 1, anrTrace.length());
                String string2 = ((StringBuilder)object2).toString();
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder().apply(builderAction).toString()");
            }
            String anrTraceFull = string;
            object2 = ReportType.ANR;
            Object object5 = anrTraceFull;
            Intrinsics.checkNotNullExpressionValue((Object)((String)object5).getBytes(Charsets.UTF_8), (String)"this as java.lang.String).getBytes(charset)");
            object5 = logStorage.getPrevLogs();
            List list3 = tagsStorage.getPrevTags();
            CrashStorage.save$default(crashStorage, (ReportType)((Object)object2), byArray, prevSystemState, list3, null, (List)object5, 16, null);
            stateStorage.setPrevSessionStatus(SessionState.Status.ANR);
        }
    }
}

