/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.app.ActivityManager;
import android.app.ApplicationExitInfo;
import android.content.Context;
import android.os.Build;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.base.process.ProcessUtils;
import ru.ok.tracer.crash.report.AnrReporterKt;
import ru.ok.tracer.crash.report.AnrSnapshotStorage;
import ru.ok.tracer.crash.report.CrashStorage;
import ru.ok.tracer.crash.report.LogEntry;
import ru.ok.tracer.crash.report.LogStorage;
import ru.ok.tracer.crash.report.ReportType;
import ru.ok.tracer.session.SessionState;
import ru.ok.tracer.session.SessionStateStorage;
import ru.ok.tracer.session.TagsStorage;
import ru.ok.tracer.utils.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J6\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J \u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a8\u0006\u0016"}, d2={"Lru/ok/tracer/crash/report/AnrReporter;", "", "()V", "check", "", "context", "Landroid/content/Context;", "stateStorage", "Lru/ok/tracer/session/SessionStateStorage;", "tagsStorage", "Lru/ok/tracer/session/TagsStorage;", "logStorage", "Lru/ok/tracer/crash/report/LogStorage;", "crashStorage", "Lru/ok/tracer/crash/report/CrashStorage;", "snapshotStorage", "Lru/ok/tracer/crash/report/AnrSnapshotStorage;", "insertSnapshotsIfAny", "", "anrTrace", "timestamp", "", "tracer-crash-report_release"})
public final class AnrReporter {
    @NotNull
    public static final AnrReporter INSTANCE = new AnrReporter();

    private AnrReporter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void check(@NotNull Context context, @NotNull SessionStateStorage stateStorage, @NotNull TagsStorage tagsStorage, @NotNull LogStorage logStorage, @NotNull CrashStorage crashStorage, @NotNull AnrSnapshotStorage snapshotStorage) {
        List list;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)stateStorage, (String)"stateStorage");
        Intrinsics.checkNotNullParameter((Object)tagsStorage, (String)"tagsStorage");
        Intrinsics.checkNotNullParameter((Object)logStorage, (String)"logStorage");
        Intrinsics.checkNotNullParameter((Object)crashStorage, (String)"crashStorage");
        Intrinsics.checkNotNullParameter((Object)snapshotStorage, (String)"snapshotStorage");
        if (Build.VERSION.SDK_INT < 30) {
            return;
        }
        Object object = context.getSystemService("activity");
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.app.ActivityManager");
        ActivityManager activityManager = (ActivityManager)object;
        try {
            list = activityManager.getHistoricalProcessExitReasons(null, 0, 0);
        }
        catch (Exception e) {
            Logger.e((Throwable)e);
            return;
        }
        List list2 = list;
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"try {\n            activi\u2026         return\n        }");
        List exitReasons = list2;
        String processName = ProcessUtils.getProcessName((Context)context);
        for (ApplicationExitInfo exitReason : exitReasons) {
            CharSequence charSequence;
            List<LogEntry> list3;
            Object object2;
            Object object3;
            if (exitReason.getReason() != 6) continue;
            if (!Intrinsics.areEqual((Object)exitReason.getProcessName(), (Object)processName)) {
                Object[] objectArray = new Object[]{exitReason.getProcessName(), processName};
                Logger.d((String)"Skip ANR from other process: their %s vs my %s", (Object[])objectArray);
                continue;
            }
            long prevStartTs = stateStorage.getPrevStartTs();
            if (exitReason.getTimestamp() < prevStartTs) {
                Object[] objectArray = new Object[]{exitReason.getTimestamp(), prevStartTs};
                Logger.d((String)"Skip old ANR. AnrTs: %s, SessionTs: %s", (Object[])objectArray);
                continue;
            }
            try {
                Object object4;
                InputStream inputStream = exitReason.getTraceInputStream();
                if (inputStream != null) {
                    object3 = inputStream;
                    object2 = Charsets.UTF_8;
                    list3 = new InputStreamReader((InputStream)object3, (Charset)object2);
                    int n = 8192;
                    object3 = list3 instanceof BufferedReader ? (BufferedReader)((Object)list3) : new BufferedReader((Reader)((Object)list3), n);
                    object2 = null;
                    try {
                        BufferedReader it = (BufferedReader)object3;
                        boolean bl = false;
                        list3 = TextStreamsKt.readText((Reader)it);
                        object4 = list3;
                    }
                    catch (Throwable throwable) {
                        object2 = throwable;
                        throw throwable;
                    }
                    finally {
                        CloseableKt.closeFinally((Closeable)object3, (Throwable)object2);
                    }
                } else {
                    object4 = null;
                }
                charSequence = object4;
            }
            catch (Exception e) {
                Logger.e((Throwable)e);
                charSequence = null;
            }
            String anrTrace = charSequence;
            charSequence = anrTrace;
            if (charSequence == null || charSequence.length() == 0) {
                Logger.w$default((String)("ANR with empty trace. " + exitReason.getDescription()), null, (int)2, null);
                continue;
            }
            charSequence = new Object[]{exitReason.getTimestamp()};
            Logger.d((String)"Spotted ANR  ts: %s", (Object[])charSequence);
            SystemState prevSystemState = stateStorage.getPrevSystemState();
            if (prevSystemState == null) {
                Logger.w$default((String)"No prevSystemState", null, (int)2, null);
                continue;
            }
            String anrTraceFull = this.insertSnapshotsIfAny(anrTrace, exitReason.getTimestamp(), snapshotStorage);
            object3 = ReportType.ANR;
            list3 = anrTraceFull;
            byte[] byArray = ((String)((Object)list3)).getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            object2 = byArray;
            list3 = logStorage.getPrevLogs();
            List list4 = tagsStorage.getPrevTags();
            CrashStorage.save$default(crashStorage, (ReportType)((Object)object3), (byte[])object2, prevSystemState, list4, null, list3, 16, null);
            stateStorage.setPrevSessionStatus(SessionState.Status.ANR);
        }
    }

    private final String insertSnapshotsIfAny(String anrTrace, long timestamp, AnrSnapshotStorage snapshotStorage) {
        StringBuilder stringBuilder;
        List<AnrSnapshotStorage.ThreadSnapshot> allStackTraces = snapshotStorage.readAll();
        if (allStackTraces.isEmpty()) {
            Logger.d$default((String)"No main snapshots to attach", null, (int)2, null);
            return anrTrace;
        }
        int indexToInsertSnapshots = AnrReporterKt.indexToInsertSnapshots(anrTrace);
        if (indexToInsertSnapshots < 0) {
            Logger.e$default((String)"Unable to find where to insert snapshots", null, (int)2, null);
            return anrTrace;
        }
        StringBuilder $this$insertSnapshotsIfAny_u24lambda_u241 = stringBuilder = new StringBuilder();
        boolean bl = false;
        $this$insertSnapshotsIfAny_u24lambda_u241.append(anrTrace, 0, indexToInsertSnapshots);
        for (AnrSnapshotStorage.ThreadSnapshot stackTrace : allStackTraces) {
            $this$insertSnapshotsIfAny_u24lambda_u241.append("\"SNAPSHOT main\" tid=1 (");
            $this$insertSnapshotsIfAny_u24lambda_u241.append(timestamp - stackTrace.getTimestamp$tracer_crash_report_release()).append("ms before");
            $this$insertSnapshotsIfAny_u24lambda_u241.append(")\n");
            StringBuilder stringBuilder2 = $this$insertSnapshotsIfAny_u24lambda_u241.append(stackTrace.getStack$tracer_crash_report_release());
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2, (String)"append(stackTrace.stack)");
            Intrinsics.checkNotNullExpressionValue((Object)stringBuilder2.append('\n'), (String)"append('\\n')");
        }
        Intrinsics.checkNotNullExpressionValue((Object)$this$insertSnapshotsIfAny_u24lambda_u241.append('\n'), (String)"append('\\n')");
        $this$insertSnapshotsIfAny_u24lambda_u241.append(anrTrace, indexToInsertSnapshots, anrTrace.length());
        String string = stringBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().apply(builderAction).toString()");
        return string;
    }
}

