/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.content.Context;
import java.io.Closeable;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.crash.report.LogEntry;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;
import ru.ok.tracer.utils.TracerThreads;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0002\b\u0004\b\u0000\u0018\u0000 &2\u00020\u0001:\u0003&'(B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020\u001fH\u0002J\u0010\u0010!\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001dH\u0002J\u000e\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020%R\u000e\u0010\u0007\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\f0\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\f0\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\u000eR\u0016\u0010\u001b\u001a\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lru/ok/tracer/crash/report/LogStorage;", "", "context", "Landroid/content/Context;", "maxLogsLength", "", "(Landroid/content/Context;I)V", "appContext", "lock", "Ljava/lang/Object;", "logs", "", "Lru/ok/tracer/crash/report/LogEntry;", "getLogs", "()Ljava/util/List;", "logsApiLinesLength", "logsData", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "logsFile", "Ljava/io/File;", "logsFileLinesLength", "logsStartTimeMillis", "", "logsState", "Lru/ok/tracer/crash/report/LogStorage$LogsState;", "prevLogs", "getPrevLogs", "prevLogsData", "prevLogsState", "Lru/ok/tracer/crash/report/LogStorage$PrevLogsState;", "clearPrevLogs", "", "ensureLogStateWrite", "ensurePrevLogsState", "toPrevLogsState", "log", "message", "", "Companion", "LogsState", "PrevLogsState", "tracer-crash-report_release"})
public final class LogStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int maxLogsLength;
    @NotNull
    private final Context appContext;
    @NotNull
    private final Object lock;
    @NotNull
    private volatile PrevLogsState prevLogsState;
    @Nullable
    private List<LogEntry> prevLogsData;
    @NotNull
    private LogsState logsState;
    private File logsFile;
    private int logsFileLinesLength;
    private int logsApiLinesLength;
    @NotNull
    private final ConcurrentLinkedQueue<LogEntry> logsData;
    private final long logsStartTimeMillis;
    @NotNull
    private static final String DIR_USER_LOGS = "logs";
    @NotNull
    private static final String LOGS_FILE_A = "a.log";
    @NotNull
    private static final String LOGS_FILE_B = "b.log";
    @NotNull
    private static final String LOGS_FILE_STASH_A = "stash-a.log";
    @NotNull
    private static final String LOGS_FILE_STASH_B = "stash-b.log";

    public LogStorage(@NotNull Context context, int maxLogsLength) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.maxLogsLength = maxLogsLength;
        Context context2 = context.getApplicationContext();
        if (context2 == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        this.appContext = context2;
        this.lock = new Object();
        this.prevLogsState = PrevLogsState.NONE;
        this.logsState = LogsState.NONE;
        this.logsData = new ConcurrentLinkedQueue();
        this.logsStartTimeMillis = System.currentTimeMillis();
    }

    public /* synthetic */ LogStorage(Context context, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = 65536;
        }
        this(context, n);
    }

    @NotNull
    public final List<LogEntry> getPrevLogs() {
        this.ensurePrevLogsState(PrevLogsState.LOADED);
        List<LogEntry> list = this.prevLogsData;
        if (list == null) {
            boolean bl = false;
            String string = "Cannot get prev logs after clear";
            throw new IllegalStateException(string.toString());
        }
        return list;
    }

    public final void clearPrevLogs() {
        this.ensurePrevLogsState(PrevLogsState.CLEAN);
    }

    @NotNull
    public final List<LogEntry> getLogs() {
        return CollectionsKt.toList((Iterable)this.logsData);
    }

    public final void log(@NotNull String message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        int maxMessageLength = this.maxLogsLength - 30;
        if (maxMessageLength <= 0) {
            Logger.e$default((String)"Log length too limited", null, (int)2, null);
            return;
        }
        LogEntry logEntry = LogEntry.Companion.invoke(System.currentTimeMillis() - this.logsStartTimeMillis, message, maxMessageLength);
        this.logsData.add(logEntry);
        this.logsApiLinesLength += logEntry.getApiLineLength();
        while (this.logsApiLinesLength > this.maxLogsLength) {
            LogEntry oldestLog = this.logsData.poll();
            if (oldestLog != null) {
                this.logsApiLinesLength -= oldestLog.getApiLineLength();
                continue;
            }
            this.logsApiLinesLength = 0;
        }
        TracerThreads.INSTANCE.runInBgSequential(() -> LogStorage.log$lambda$2(this, message, logEntry));
    }

    private final void ensureLogStateWrite() {
        File logsDir = FilesKt.resolve((File)TracerFiles.INSTANCE.getTracerDir(this.appContext), (String)DIR_USER_LOGS);
        try {
            FileUtils.mkdirsChecked((File)logsDir);
        }
        catch (IOException ex) {
            Logger.e$default((String)("Cannot create dir " + logsDir), null, (int)2, null);
        }
        switch (WhenMappings.$EnumSwitchMapping$0[this.logsState.ordinal()]) {
            case 1: {
                File logsFileA = FilesKt.resolve((File)logsDir, (String)LOGS_FILE_A);
                File logsFileB = FilesKt.resolve((File)logsDir, (String)LOGS_FILE_B);
                File[] fileArray = new File[]{logsFileA, logsFileB};
                LogStorage.Companion.deleteIfExist(fileArray);
                this.logsFile = logsFileA;
                this.logsState = LogsState.WRITE_A;
                break;
            }
            case 2: {
                File file = this.logsFile;
                if (file == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logsFile");
                    file = null;
                }
                if (file.length() <= (long)this.maxLogsLength) break;
                File logsFileB = FilesKt.resolve((File)logsDir, (String)LOGS_FILE_B);
                File[] fileArray = new File[]{logsFileB};
                LogStorage.Companion.deleteIfExist(fileArray);
                this.logsFile = logsFileB;
                this.logsFileLinesLength = 0;
                this.logsState = LogsState.WRITE_B;
                break;
            }
            case 3: {
                File file = this.logsFile;
                if (file == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"logsFile");
                    file = null;
                }
                if (file.length() <= (long)this.maxLogsLength) break;
                File logsFileA = FilesKt.resolve((File)logsDir, (String)LOGS_FILE_A);
                File[] fileArray = new File[]{logsFileA};
                LogStorage.Companion.deleteIfExist(fileArray);
                this.logsFile = logsFileA;
                this.logsFileLinesLength = 0;
                this.logsState = LogsState.WRITE_A;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final void ensurePrevLogsState(PrevLogsState toPrevLogsState) {
        PrevLogsState oldPrevLogsState = this.prevLogsState;
        if (oldPrevLogsState.compareTo((Enum)toPrevLogsState) >= 0) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            boolean bl = false;
            PrevLogsState syncPrevLogsState = this.prevLogsState;
            if (syncPrevLogsState.compareTo((Enum)toPrevLogsState) >= 0) {
                return;
            }
            File logsDir = FilesKt.resolve((File)TracerFiles.INSTANCE.getTracerDir(this.appContext), (String)DIR_USER_LOGS);
            File logsFileA = FilesKt.resolve((File)logsDir, (String)LOGS_FILE_A);
            File logsFileB = FilesKt.resolve((File)logsDir, (String)LOGS_FILE_B);
            File logsFileStashA = FilesKt.resolve((File)logsDir, (String)LOGS_FILE_STASH_A);
            File logsFileStashB = FilesKt.resolve((File)logsDir, (String)LOGS_FILE_STASH_B);
            block2 : switch (WhenMappings.$EnumSwitchMapping$1[syncPrevLogsState.ordinal()]) {
                case 4: {
                    switch (WhenMappings.$EnumSwitchMapping$1[toPrevLogsState.ordinal()]) {
                        case 1: {
                            File[] fileArray = new File[]{logsFileStashA, logsFileStashB};
                            LogStorage.Companion.deleteIfExist(fileArray);
                            fileArray = new Pair[]{TuplesKt.to((Object)logsFileA, (Object)logsFileStashA), TuplesKt.to((Object)logsFileB, (Object)logsFileStashB)};
                            LogStorage.Companion.renameIfExist((Pair[])fileArray);
                            break block2;
                        }
                        case 2: {
                            File[] fileArray = new File[]{logsFileA, logsFileB};
                            this.prevLogsData = LogStorage.Companion.readIfExist(fileArray, this.maxLogsLength);
                            fileArray = new File[]{logsFileA, logsFileB};
                            LogStorage.Companion.deleteIfExist(fileArray);
                            break block2;
                        }
                        case 3: {
                            File[] fileArray = new File[]{logsFileStashA, logsFileStashB};
                            LogStorage.Companion.deleteIfExist(fileArray);
                            fileArray = new File[]{logsFileA, logsFileB};
                            LogStorage.Companion.deleteIfExist(fileArray);
                            break block2;
                        }
                    }
                    throw new AssertionError((Object)"Unreachable code");
                }
                case 1: {
                    switch (WhenMappings.$EnumSwitchMapping$1[toPrevLogsState.ordinal()]) {
                        case 2: {
                            File[] fileArray = new File[]{logsFileStashA, logsFileStashB};
                            this.prevLogsData = LogStorage.Companion.readIfExist(fileArray, this.maxLogsLength);
                            fileArray = new File[]{logsFileStashA, logsFileStashB};
                            LogStorage.Companion.deleteIfExist(fileArray);
                            break block2;
                        }
                        case 3: {
                            File[] fileArray = new File[]{logsFileStashA, logsFileStashB};
                            LogStorage.Companion.deleteIfExist(fileArray);
                            break block2;
                        }
                    }
                    throw new AssertionError((Object)"Unreachable code");
                }
                case 2: {
                    if (WhenMappings.$EnumSwitchMapping$1[toPrevLogsState.ordinal()] == 3) {
                        this.prevLogsData = null;
                        break;
                    }
                    throw new AssertionError((Object)"Unreachable code");
                }
                default: {
                    throw new AssertionError((Object)"Unreachable code");
                }
            }
            this.prevLogsState = toPrevLogsState;
            Unit unit = Unit.INSTANCE;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void log$lambda$2(LogStorage this$0, String $message, LogEntry $logEntry) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$message, (String)"$message");
        Intrinsics.checkNotNullParameter((Object)$logEntry, (String)"$logEntry");
        this$0.ensurePrevLogsState(PrevLogsState.STASHED);
        this$0.ensureLogStateWrite();
        try {
            File file = this$0.logsFile;
            if (file == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"logsFile");
                file = null;
            }
            OutputStream p0 = new FileOutputStream(file, true);
            boolean bl = false;
            Closeable closeable = new DataOutputStream(p0);
            Throwable throwable = null;
            try {
                DataOutputStream it = (DataOutputStream)closeable;
                boolean bl2 = false;
                $logEntry.writeToStorage(it);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException ex) {
            Logger.e((String)("Unable to write " + $message), (Throwable)ex);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J!\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\rH\u0002\u00a2\u0006\u0002\u0010\u000eJ/\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0012\u0010\u000b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\r0\f\"\u00020\r2\u0006\u0010\u0012\u001a\u00020\u0013H\u0002\u00a2\u0006\u0002\u0010\u0014J\u0016\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\u0016\u001a\u00020\rH\u0002J9\u0010\u0017\u001a\u00020\n2*\u0010\u000b\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u00180\f\"\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\r0\u0018H\u0002\u00a2\u0006\u0002\u0010\u0019R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lru/ok/tracer/crash/report/LogStorage$Companion;", "", "()V", "DIR_USER_LOGS", "", "LOGS_FILE_A", "LOGS_FILE_B", "LOGS_FILE_STASH_A", "LOGS_FILE_STASH_B", "deleteIfExist", "", "files", "", "Ljava/io/File;", "([Ljava/io/File;)V", "readIfExist", "", "Lru/ok/tracer/crash/report/LogEntry;", "maxLength", "", "([Ljava/io/File;I)Ljava/util/List;", "readIfExists", "file", "renameIfExist", "Lkotlin/Pair;", "([Lkotlin/Pair;)V", "tracer-crash-report_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void deleteIfExist(File ... files) {
            for (File file : files) {
                if (!file.exists()) continue;
                try {
                    FileUtils.deleteChecked((File)file);
                }
                catch (IOException ex) {
                    Logger.e((String)("Cannot delete file " + file), (Throwable)ex);
                }
            }
        }

        private final void renameIfExist(Pair<? extends File, ? extends File> ... files) {
            for (Pair<? extends File, ? extends File> pair : files) {
                File srcFile = (File)pair.component1();
                File destFile = (File)pair.component2();
                if (!srcFile.exists()) continue;
                try {
                    srcFile.renameTo(destFile);
                }
                catch (IOException ex) {
                    Logger.e((String)("Cannot rename file " + srcFile + " to " + destFile), (Throwable)ex);
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        private final List<LogEntry> readIfExist(File[] files, int maxLength) {
            LogEntry logEntry;
            ArrayDeque arrayDeque;
            ArrayDeque $this$readIfExist_u24lambda_u240 = arrayDeque = new ArrayDeque();
            boolean bl = false;
            block0: for (File file : files) {
                List<LogEntry> logEntries = Companion.readIfExists(file);
                if (logEntries.isEmpty()) continue;
                if ($this$readIfExist_u24lambda_u240.isEmpty() || ((LogEntry)$this$readIfExist_u24lambda_u240.last()).getTs() < ((LogEntry)CollectionsKt.first(logEntries)).getTs()) {
                    $this$readIfExist_u24lambda_u240.addAll((Collection)logEntries);
                    continue;
                }
                int n = $this$readIfExist_u24lambda_u240.size();
                for (int i = 0; i < n; ++i) {
                    if (((LogEntry)$this$readIfExist_u24lambda_u240.get(i)).getTs() <= ((LogEntry)CollectionsKt.last(logEntries)).getTs()) continue;
                    $this$readIfExist_u24lambda_u240.addAll(i, (Collection)logEntries);
                    continue block0;
                }
            }
            Iterable iterable = (Iterable)$this$readIfExist_u24lambda_u240;
            int n = 0;
            for (Object t : iterable) {
                void p0;
                LogEntry logEntry2 = (LogEntry)t;
                int n2 = n;
                boolean bl2 = false;
                int n3 = p0.getApiLineLength();
                n = n2 + n3;
            }
            for (int totalApiLinesLength = n; totalApiLinesLength > maxLength; totalApiLinesLength -= logEntry.getApiLineLength()) {
                logEntry = (LogEntry)$this$readIfExist_u24lambda_u240.removeFirst();
            }
            return (List)arrayDeque;
        }

        private final List<LogEntry> readIfExists(File file) {
            Object object;
            if (!file.exists()) {
                return CollectionsKt.emptyList();
            }
            try {
                byte[] p0 = FilesKt.readBytes((File)file);
                boolean bl = false;
                object = ByteBuffer.wrap(p0);
            }
            catch (Exception ex) {
                Logger.e((String)("Cannot read file " + file), (Throwable)ex);
                return CollectionsKt.emptyList();
            }
            ByteBuffer input = object;
            Object $this$readIfExists_u24lambda_u243 = object = CollectionsKt.createListBuilder();
            boolean bl = false;
            while (input.hasRemaining()) {
                LogEntry logEntry;
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)input, (String)"input");
                    logEntry = LogEntry.Companion.parseFromStorage(input);
                }
                catch (BufferUnderflowException ex) {
                    break;
                }
                LogEntry logEntry2 = logEntry;
                $this$readIfExists_u24lambda_u243.add(logEntry2);
            }
            Object $this$sortBy$iv = $this$readIfExists_u24lambda_u243;
            boolean $i$f$sortBy = false;
            if ($this$sortBy$iv.size() > 1) {
                CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                    public final int compare(T a, T b) {
                        LogEntry p0 = (LogEntry)a;
                        boolean bl = false;
                        Comparable comparable = Long.valueOf(p0.getTs());
                        p0 = (LogEntry)b;
                        Comparable comparable2 = comparable;
                        bl = false;
                        return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(p0.getTs()));
                    }
                });
            }
            return CollectionsKt.build((List)object);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0006\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lru/ok/tracer/crash/report/LogStorage$PrevLogsState;", "", "(Ljava/lang/String;I)V", "NONE", "STASHED", "LOADED", "CLEAN", "tracer-crash-report_release"})
    private static final class PrevLogsState
    extends Enum<PrevLogsState> {
        public static final /* enum */ PrevLogsState NONE = new PrevLogsState();
        public static final /* enum */ PrevLogsState STASHED = new PrevLogsState();
        public static final /* enum */ PrevLogsState LOADED = new PrevLogsState();
        public static final /* enum */ PrevLogsState CLEAN = new PrevLogsState();
        private static final /* synthetic */ PrevLogsState[] $VALUES;

        public static PrevLogsState[] values() {
            return (PrevLogsState[])$VALUES.clone();
        }

        public static PrevLogsState valueOf(String value) {
            return Enum.valueOf(PrevLogsState.class, value);
        }

        static {
            $VALUES = prevLogsStateArray = new PrevLogsState[]{PrevLogsState.NONE, PrevLogsState.STASHED, PrevLogsState.LOADED, PrevLogsState.CLEAN};
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lru/ok/tracer/crash/report/LogStorage$LogsState;", "", "(Ljava/lang/String;I)V", "NONE", "WRITE_A", "WRITE_B", "tracer-crash-report_release"})
    private static final class LogsState
    extends Enum<LogsState> {
        public static final /* enum */ LogsState NONE = new LogsState();
        public static final /* enum */ LogsState WRITE_A = new LogsState();
        public static final /* enum */ LogsState WRITE_B = new LogsState();
        private static final /* synthetic */ LogsState[] $VALUES;

        public static LogsState[] values() {
            return (LogsState[])$VALUES.clone();
        }

        public static LogsState valueOf(String value) {
            return Enum.valueOf(LogsState.class, value);
        }

        static {
            $VALUES = logsStateArray = new LogsState[]{LogsState.NONE, LogsState.WRITE_A, LogsState.WRITE_B};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LogsState.values().length];
            try {
                nArray[LogsState.NONE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogsState.WRITE_A.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogsState.WRITE_B.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[PrevLogsState.values().length];
            try {
                nArray[PrevLogsState.STASHED.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrevLogsState.LOADED.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrevLogsState.CLEAN.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[PrevLogsState.NONE.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

