/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.content.Context;
import java.io.BufferedWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.Charsets;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.base.stacktrace.ThrowableUtils;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u000b\u001a\u00020\fJ\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eJ\u0019\u0010\u0010\u001a\u00020\f2\f\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lru/ok/tracer/crash/report/AnrSnapshotStorage;", "", "maxCount", "", "context", "Landroid/content/Context;", "(ILandroid/content/Context;)V", "snapshotDir", "Ljava/io/File;", "getSnapshotDir", "()Ljava/io/File;", "clean", "", "readAll", "", "Lru/ok/tracer/crash/report/AnrSnapshotStorage$ThreadSnapshot;", "save", "stackTrace", "", "Ljava/lang/StackTraceElement;", "([Ljava/lang/StackTraceElement;)V", "Companion", "ThreadSnapshot", "tracer-crash-report_release"})
public final class AnrSnapshotStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    private final int maxCount;
    private static final int ABSOLUTE_MAX_COUNT = 100;
    @NotNull
    private static final Regex FILENAME_REGEX = new Regex("main-([0-9]+)\\.txt");

    public AnrSnapshotStorage(int maxCount, @NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        this.context = context;
        this.maxCount = RangesKt.coerceIn((int)maxCount, (int)1, (int)100);
    }

    public /* synthetic */ AnrSnapshotStorage(int n, Context context, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 100;
        }
        this(n, context);
    }

    private final File getSnapshotDir() {
        return FilesKt.resolve((File)TracerFiles.INSTANCE.getTracerDir(this.context), (String)"main_snapshots");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void save(@NotNull StackTraceElement[] stackTrace) {
        Intrinsics.checkNotNullParameter((Object)stackTrace, (String)"stackTrace");
        File snapshotDir = this.getSnapshotDir();
        long snapshotTimestamp = System.currentTimeMillis();
        String snapshotFilename = "main-" + snapshotTimestamp + ".txt";
        File snapshotFile = FilesKt.resolve((File)snapshotDir, (String)snapshotFilename);
        try {
            FileUtils.mkdirsChecked((File)snapshotDir);
            File[] fileArray = snapshotDir.listFiles();
            if (fileArray == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            File[] snapshotFiles = fileArray;
            if (snapshotFiles.length >= this.maxCount) {
                ArraysKt.sort((Object[])snapshotFiles);
                int i = 0;
                int n = snapshotFiles.length - this.maxCount;
                if (i <= n) {
                    while (true) {
                        File file = snapshotFiles[i];
                        Intrinsics.checkNotNullExpressionValue((Object)file, (String)"snapshotFiles[i]");
                        FileUtils.deleteChecked((File)file);
                        if (i == n) break;
                        ++i;
                    }
                }
            }
            Object object = snapshotFile;
            Object object2 = Charsets.UTF_8;
            int n = 8192;
            Object object3 = object;
            object = (object3 = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object3), (Charset)object2)) instanceof BufferedWriter ? (BufferedWriter)object3 : new BufferedWriter((Writer)object3, n);
            object2 = null;
            try {
                BufferedWriter writer = (BufferedWriter)object;
                boolean bl = false;
                for (StackTraceElement element : stackTrace) {
                    ThrowableUtils.appendTo$default((StackTraceElement)element, (Appendable)writer, (int)0, null, (int)6, null);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable) {
                object2 = throwable;
                throw throwable;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)object2);
            }
        }
        catch (Throwable e) {
            Logger.e((String)"Cannot save thread snapshot", (Throwable)e);
        }
    }

    @NotNull
    public final List<ThreadSnapshot> readAll() {
        File snapshotDir = this.getSnapshotDir();
        if (!snapshotDir.exists() || !snapshotDir.isDirectory()) {
            return CollectionsKt.emptyList();
        }
        try {
            List list;
            Object[] objectArray = snapshotDir.listFiles();
            if (objectArray == null) {
                String string = "Required value was null.";
                throw new IllegalArgumentException(string.toString());
            }
            Object[] snapshotFiles = objectArray;
            ArraysKt.sort((Object[])((Comparable[])snapshotFiles));
            ArraysKt.reverse((Object[])snapshotFiles);
            List $this$readAll_u24lambda_u241 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            for (Object snapshotFile : snapshotFiles) {
                MatchResult snapshotMatch;
                String snapshotFilename = ((File)snapshotFile).getName();
                Intrinsics.checkNotNullExpressionValue((Object)snapshotFilename, (String)"snapshotFilename");
                if (FILENAME_REGEX.matchEntire((CharSequence)snapshotFilename) == null) continue;
                long snapshotTimestamp = Long.parseLong((String)snapshotMatch.getGroupValues().get(1));
                Collection collection = $this$readAll_u24lambda_u241;
                Intrinsics.checkNotNullExpressionValue((Object)snapshotFile, (String)"snapshotFile");
                collection.add(new ThreadSnapshot(snapshotTimestamp, FilesKt.readText$default((File)snapshotFile, null, (int)1, null)));
            }
            List result = CollectionsKt.build((List)list);
            return result;
        }
        catch (Throwable e) {
            Logger.e((String)"Cannot read snapshot files", (Throwable)e);
            if (!FilesKt.deleteRecursively((File)snapshotDir)) {
                Logger.e$default((String)"Cannot delete snapshots dir", null, (int)2, null);
            }
            return CollectionsKt.emptyList();
        }
    }

    public final void clean() {
        if (!this.getSnapshotDir().exists() || !this.getSnapshotDir().isDirectory()) {
            return;
        }
        if (!FilesKt.deleteRecursively((File)this.getSnapshotDir())) {
            Logger.e$default((String)"Cannot delete snapshots dir", null, (int)2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0006\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lru/ok/tracer/crash/report/AnrSnapshotStorage$ThreadSnapshot;", "", "timestamp", "", "stack", "", "(JLjava/lang/String;)V", "getStack$tracer_crash_report_release", "()Ljava/lang/String;", "getTimestamp$tracer_crash_report_release", "()J", "tracer-crash-report_release"})
    public static final class ThreadSnapshot {
        private final long timestamp;
        @NotNull
        private final String stack;

        public ThreadSnapshot(long timestamp, @NotNull String stack) {
            Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
            this.timestamp = timestamp;
            this.stack = stack;
        }

        public final long getTimestamp$tracer_crash_report_release() {
            return this.timestamp;
        }

        @NotNull
        public final String getStack$tracer_crash_report_release() {
            return this.stack;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lru/ok/tracer/crash/report/AnrSnapshotStorage$Companion;", "", "()V", "ABSOLUTE_MAX_COUNT", "", "FILENAME_REGEX", "Lkotlin/text/Regex;", "tracer-crash-report_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

