/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.os.Handler;
import android.os.Looper;
import androidx.annotation.MainThread;
import androidx.annotation.WorkerThread;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.crash.report.AnrSnapshotStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\u0014\u001a\u00020\u0015H\u0003J\b\u0010\u0016\u001a\u00020\u0015H\u0003J\b\u0010\u0017\u001a\u00020\u0015H\u0003J\b\u0010\u0018\u001a\u00020\u0015H\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0001X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lru/ok/tracer/crash/report/AnrWatchdogThread;", "Ljava/lang/Thread;", "snapshotStorage", "Lru/ok/tracer/crash/report/AnrSnapshotStorage;", "snapshotsDelayMs", "", "snapshotsIntervalMs", "(Lru/ok/tracer/crash/report/AnrSnapshotStorage;JJ)V", "bgHandler", "Landroid/os/Handler;", "bgSnapshotRunnable", "Ljava/lang/Runnable;", "bgWatchdogRunnable", "mainHandler", "mainRunnable", "mainStuck", "", "mainThread", "snapshotIntervalMs", "watchdogPeriodMs", "onBgSnapshot", "", "onBgWatchdog", "onMain", "run", "Companion", "tracer-crash-report_release"})
public final class AnrWatchdogThread
extends Thread {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final AnrSnapshotStorage snapshotStorage;
    private final long snapshotsDelayMs;
    private final long snapshotIntervalMs;
    private final long watchdogPeriodMs;
    private volatile Thread mainThread;
    private volatile Handler mainHandler;
    private volatile Handler bgHandler;
    private volatile boolean mainStuck;
    @NotNull
    private final Runnable mainRunnable;
    @NotNull
    private final Runnable bgWatchdogRunnable;
    @NotNull
    private final Runnable bgSnapshotRunnable;
    private static final long ABSOLUTE_MIN_SNAPSHOTS_DELAY_MS = 1000L;
    private static final long ABSOLUTE_MIN_SNAPSHOTS_INTERVAL_MS = 100L;
    public static final long DEFAULT_SNAPSHOTS_DELAY_MS = 3000L;
    public static final long DEFAULT_SNAPSHOTS_INTERVAL_MS = 500L;

    public AnrWatchdogThread(@NotNull AnrSnapshotStorage snapshotStorage, long snapshotsDelayMs, long snapshotsIntervalMs) {
        Intrinsics.checkNotNullParameter((Object)snapshotStorage, (String)"snapshotStorage");
        super("tracer-watchdog");
        this.snapshotStorage = snapshotStorage;
        this.snapshotsDelayMs = RangesKt.coerceAtLeast((long)snapshotsDelayMs, (long)1000L);
        this.snapshotIntervalMs = RangesKt.coerceAtLeast((long)snapshotsIntervalMs, (long)100L);
        this.watchdogPeriodMs = snapshotsDelayMs / (long)2;
        this.mainRunnable = this::onMain;
        this.bgWatchdogRunnable = this::onBgWatchdog;
        this.bgSnapshotRunnable = this::onBgSnapshot;
    }

    public /* synthetic */ AnrWatchdogThread(AnrSnapshotStorage anrSnapshotStorage, long l, long l2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            l = 3000L;
        }
        if ((n & 4) != 0) {
            l2 = 500L;
        }
        this(anrSnapshotStorage, l, l2);
    }

    @Override
    public void run() {
        Looper.prepare();
        Looper looper = Looper.myLooper();
        if (looper == null) {
            String string = "Required value was null.";
            throw new IllegalArgumentException(string.toString());
        }
        Intrinsics.checkNotNullExpressionValue((Object)looper, (String)"requireNotNull(Looper.myLooper())");
        Looper bgLooper = looper;
        this.bgHandler = new Handler(bgLooper);
        Looper mainLooper = Looper.getMainLooper();
        this.mainHandler = new Handler(mainLooper);
        Handler handler = this.mainHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainHandler");
            handler = null;
        }
        handler.post(this.mainRunnable);
        Looper.loop();
    }

    @MainThread
    private final void onMain() {
        Thread thread = Thread.currentThread();
        Intrinsics.checkNotNullExpressionValue((Object)thread, (String)"currentThread()");
        this.mainThread = thread;
        this.mainStuck = false;
        Handler handler = this.bgHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bgHandler");
            handler = null;
        }
        handler.removeCallbacks(this.bgWatchdogRunnable);
        Handler handler2 = this.bgHandler;
        if (handler2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bgHandler");
            handler2 = null;
        }
        handler2.postDelayed(this.bgWatchdogRunnable, this.snapshotsDelayMs);
        Handler handler3 = this.mainHandler;
        if (handler3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainHandler");
            handler3 = null;
        }
        handler3.postDelayed(this.mainRunnable, this.watchdogPeriodMs);
    }

    @WorkerThread
    private final void onBgWatchdog() {
        this.mainStuck = true;
        this.snapshotStorage.clean();
        this.onBgSnapshot();
    }

    @WorkerThread
    private final void onBgSnapshot() {
        if (!this.mainStuck) {
            return;
        }
        Thread thread = this.mainThread;
        if (thread == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mainThread");
            thread = null;
        }
        StackTraceElement[] stackTraceElementArray = thread.getStackTrace();
        Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"mainThread.stackTrace");
        this.snapshotStorage.save(stackTraceElementArray);
        Handler handler = this.bgHandler;
        if (handler == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"bgHandler");
            handler = null;
        }
        handler.postDelayed(this.bgSnapshotRunnable, this.snapshotIntervalMs);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0080T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\b"}, d2={"Lru/ok/tracer/crash/report/AnrWatchdogThread$Companion;", "", "()V", "ABSOLUTE_MIN_SNAPSHOTS_DELAY_MS", "", "ABSOLUTE_MIN_SNAPSHOTS_INTERVAL_MS", "DEFAULT_SNAPSHOTS_DELAY_MS", "DEFAULT_SNAPSHOTS_INTERVAL_MS", "tracer-crash-report_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

