/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.content.Context;
import java.io.BufferedOutputStream;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.SystemStateSerializer;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.base.stacktrace.ThrowableUtils;
import ru.ok.tracer.crash.report.CrashDescription;
import ru.ok.tracer.crash.report.LogEntry;
import ru.ok.tracer.crash.report.ReportType;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0005\u001a\u00020\u0006J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\\\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00172\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\fJ\\\u0010\r\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u0012\u001a\u00020\u00132\u000e\b\u0002\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00150\f2\u001a\b\u0002\u0010\u0016\u001a\u0014\u0012\u0004\u0012\u00020\u0018\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001a0\u00190\u00172\u000e\b\u0002\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001c0\fR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"Lru/ok/tracer/crash/report/CrashStorage;", "", "appContext", "Landroid/content/Context;", "(Landroid/content/Context;)V", "deleteAll", "", "read", "Lru/ok/tracer/crash/report/CrashDescription;", "crashDir", "Ljava/io/File;", "readAll", "", "save", "type", "Lru/ok/tracer/crash/report/ReportType;", "content", "", "systemState", "Lru/ok/tracer/SystemState;", "tags", "", "allStackTraces", "", "Ljava/lang/Thread;", "", "Ljava/lang/StackTraceElement;", "logs", "Lru/ok/tracer/crash/report/LogEntry;", "throwable", "", "Companion", "tracer-crash-report_release"})
public final class CrashStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context appContext;
    @NotNull
    private static final Comparator<Thread> THREAD_MAIN_FIRST_COMPARATOR = new Comparator<Thread>(){

        public int compare(@Nullable Thread t1, @Nullable Thread t2) {
            Thread thread = t1;
            if (Intrinsics.areEqual((Object)(thread != null ? thread.getName() : null), (Object)"main")) {
                return -1;
            }
            Thread thread2 = t2;
            if (Intrinsics.areEqual((Object)(thread2 != null ? thread2.getName() : null), (Object)"main")) {
                return 1;
            }
            return CrashStorage.access$getTHREAD_COMPARATOR$cp().compare(t1, t2);
        }
    };
    @NotNull
    private static final Comparator<Thread> THREAD_COMPARATOR;
    @NotNull
    private static final String MAIN_THREAD_NAME = "main";
    @NotNull
    private static final String DIR_CRASHES = "crashes";
    @NotNull
    private static final String FILE_STACKTRACE = "stacktrace";
    @NotNull
    private static final String FILE_ALL_STACKTRACES = "all_stacktraces";
    @NotNull
    private static final String FILE_LOGS = "all_logs";
    @NotNull
    private static final String FILE_SYSTEM_INFO = "system_info";
    @NotNull
    private static final String FILE_TAGS = "tags";

    public CrashStorage(@NotNull Context appContext) {
        Intrinsics.checkNotNullParameter((Object)appContext, (String)"appContext");
        this.appContext = appContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final CrashDescription save(@NotNull ReportType type, @NotNull Throwable throwable, @NotNull SystemState systemState, @NotNull List<String> tags, @NotNull Map<Thread, StackTraceElement[]> allStackTraces, @NotNull List<LogEntry> logs) {
        ByteArrayOutputStream byteArrayOutputStream;
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        Intrinsics.checkNotNullParameter((Object)systemState, (String)"systemState");
        Intrinsics.checkNotNullParameter(tags, (String)FILE_TAGS);
        Intrinsics.checkNotNullParameter(allStackTraces, (String)"allStackTraces");
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        ByteArrayOutputStream $this$save_u24lambda_u240 = byteArrayOutputStream = new ByteArrayOutputStream();
        boolean bl = false;
        Closeable closeable = $this$save_u24lambda_u240;
        Object object = Charsets.UTF_8;
        Writer writer = new OutputStreamWriter((OutputStream)closeable, (Charset)object);
        int n = 8192;
        closeable = writer instanceof BufferedWriter ? (BufferedWriter)writer : new BufferedWriter(writer, n);
        object = null;
        try {
            Appendable p0 = (Appendable)((Object)closeable);
            boolean bl2 = false;
            ThrowableUtils.appendStackTraceTo((Throwable)throwable, (Appendable)p0);
            writer = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            object = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)object);
        }
        ByteArrayOutputStream content = byteArrayOutputStream;
        byte[] byArray = content.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"content.toByteArray()");
        return this.save(type, byArray, systemState, tags, allStackTraces, logs);
    }

    public static /* synthetic */ CrashDescription save$default(CrashStorage crashStorage, ReportType reportType, Throwable throwable, SystemState systemState, List list, Map map, List list2, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return crashStorage.save(reportType, throwable, systemState, (List<String>)list, (Map<Thread, StackTraceElement[]>)map, (List<LogEntry>)list2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final CrashDescription save(@NotNull ReportType type, @NotNull byte[] content, @NotNull SystemState systemState, @NotNull List<String> tags, @NotNull Map<Thread, StackTraceElement[]> allStackTraces, @NotNull List<LogEntry> logs) {
        Intrinsics.checkNotNullParameter((Object)((Object)type), (String)"type");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)systemState, (String)"systemState");
        Intrinsics.checkNotNullParameter(tags, (String)FILE_TAGS);
        Intrinsics.checkNotNullParameter(allStackTraces, (String)"allStackTraces");
        Intrinsics.checkNotNullParameter(logs, (String)"logs");
        long timestamp = System.currentTimeMillis();
        File crashDir = FilesKt.resolve((File)FilesKt.resolve((File)TracerFiles.INSTANCE.getTracerDir(this.appContext), (String)DIR_CRASHES), (String)(type.name() + '_' + timestamp));
        if (crashDir.exists()) {
            Logger.d$default((String)("Crash exists with current timestamp. " + crashDir.getName()), null, (int)2, null);
            return null;
        }
        try {
            Object object;
            Unit unit;
            Object object2;
            FileUtils.mkdirsChecked((File)crashDir);
            File stacktraceFile = FilesKt.resolve((File)crashDir, (String)FILE_STACKTRACE);
            FilesKt.writeBytes((File)stacktraceFile, (byte[])content);
            File systemStateFile = FilesKt.resolve((File)crashDir, (String)FILE_SYSTEM_INFO);
            String systemStateJson = SystemStateSerializer.INSTANCE.toJson(systemState);
            FilesKt.writeText$default((File)systemStateFile, (String)systemStateJson, null, (int)2, null);
            File tagsFile = FilesKt.resolve((File)crashDir, (String)FILE_TAGS);
            if (!((Collection)tags).isEmpty()) {
                JSONArray jSONArray;
                JSONArray json = jSONArray = new JSONArray();
                boolean bl = false;
                for (String tag : tags) {
                    json.put((Object)tag);
                }
                JSONArray tagsJson = jSONArray;
                String string = tagsJson.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tagsJson.toString()");
                FilesKt.writeText$default((File)tagsFile, (String)string, null, (int)2, null);
            }
            File allStackTracesFile = FilesKt.resolve((File)crashDir, (String)FILE_ALL_STACKTRACES);
            if (!allStackTraces.isEmpty()) {
                SortedMap allStackTracesSorted = MapsKt.toSortedMap(allStackTraces, THREAD_MAIN_FIRST_COMPARATOR);
                object2 = allStackTracesFile;
                Object object3 = Charsets.UTF_8;
                unit = object2;
                int tag = 8192;
                object = unit;
                object2 = new PrintWriter((object = (Writer)new OutputStreamWriter((OutputStream)new FileOutputStream((File)object), (Charset)object3)) instanceof BufferedWriter ? (BufferedWriter)object : new BufferedWriter((Writer)object, tag));
                object3 = null;
                try {
                    PrintWriter writer = (PrintWriter)object2;
                    boolean bl = false;
                    for (Map.Entry entry : allStackTracesSorted.entrySet()) {
                        Thread thread = (Thread)entry.getKey();
                        StackTraceElement[] trace = (StackTraceElement[])entry.getValue();
                        writer.append("Thread: ").append(thread.getName()).append(" (").append(thread.getState().toString()).append(")");
                        Intrinsics.checkNotNullExpressionValue((Object)((Appendable)writer).append('\n'), (String)"append('\\n')");
                        Intrinsics.checkNotNullExpressionValue((Object)trace, (String)"trace");
                        for (StackTraceElement element : trace) {
                            ThrowableUtils.appendTo$default((StackTraceElement)element, (Appendable)writer, (int)0, null, (int)6, null);
                        }
                    }
                    writer = Unit.INSTANCE;
                }
                catch (Throwable writer) {
                    object3 = writer;
                    throw writer;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)object3);
                }
            }
            File logsFile = FilesKt.resolve((File)crashDir, (String)FILE_LOGS);
            if (!((Collection)logs).isEmpty()) {
                object2 = new FileOutputStream(logsFile);
                int n = 8192;
                object2 = object2 instanceof BufferedOutputStream ? (BufferedOutputStream)object2 : new BufferedOutputStream((OutputStream)object2, n);
                Throwable throwable = null;
                try {
                    BufferedOutputStream it = (BufferedOutputStream)object2;
                    boolean bl = false;
                    object = logs.iterator();
                    boolean n2 = false;
                    while (object.hasNext()) {
                        void var21_31;
                        void seq = var21_31++;
                        LogEntry log = (LogEntry)object.next();
                        log.writeToApi(it, (int)seq);
                    }
                    unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)object2, (Throwable)throwable);
                }
            }
            Logger.d$default((String)"Crash is written", null, (int)2, null);
            String string = crashDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"crashDir.path");
            String string2 = systemStateFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"systemStateFile.path");
            String string3 = tagsFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"tagsFile.path");
            String string4 = stacktraceFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"stacktraceFile.path");
            String string5 = allStackTracesFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"allStackTracesFile.path");
            String string6 = logsFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"logsFile.path");
            return new CrashDescription(timestamp, type, string, string2, string3, string4, string5, string6);
        }
        catch (IOException ex) {
            Logger.e((String)"Crash is not written", (Throwable)ex);
            FilesKt.deleteRecursively((File)crashDir);
            return null;
        }
    }

    public static /* synthetic */ CrashDescription save$default(CrashStorage crashStorage, ReportType reportType, byte[] byArray, SystemState systemState, List list, Map map, List list2, int n, Object object) {
        if ((n & 8) != 0) {
            list = CollectionsKt.emptyList();
        }
        if ((n & 0x10) != 0) {
            map = MapsKt.emptyMap();
        }
        if ((n & 0x20) != 0) {
            list2 = CollectionsKt.emptyList();
        }
        return crashStorage.save(reportType, byArray, systemState, (List<String>)list, (Map<Thread, StackTraceElement[]>)map, (List<LogEntry>)list2);
    }

    public final void deleteAll() {
        File crashesDir = FilesKt.resolve((File)TracerFiles.INSTANCE.getTracerDir(this.appContext), (String)DIR_CRASHES);
        if (!crashesDir.exists()) {
            return;
        }
        if (!FilesKt.deleteRecursively((File)crashesDir)) {
            Logger.d$default((String)"Can't delete crashes", null, (int)2, null);
        }
    }

    @NotNull
    public final List<CrashDescription> readAll() {
        CrashDescription crashDescription;
        List list;
        File crashesDir = FilesKt.resolve((File)TracerFiles.INSTANCE.getTracerDir(this.appContext), (String)DIR_CRASHES);
        if (!crashesDir.exists()) {
            Logger.d$default((String)"No crashes detected", null, (int)2, null);
            return CollectionsKt.emptyList();
        }
        File[] crashDirs = crashesDir.listFiles();
        File[] fileArray = crashDirs;
        if (fileArray == null || fileArray.length == 0) {
            Logger.d$default((String)"No crashes detected", null, (int)2, null);
            return CollectionsKt.emptyList();
        }
        List $this$readAll_u24lambda_u244 = list = (List)new ArrayList();
        boolean bl = false;
        Intrinsics.checkNotNullExpressionValue((Object)crashDirs, (String)"crashDirs");
        for (File crashDir : crashDirs) {
            try {
                Collection collection = $this$readAll_u24lambda_u244;
                Intrinsics.checkNotNullExpressionValue((Object)crashDir, (String)"crashDir");
                collection.add(this.read(crashDir));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        List crashDescriptions = list;
        if (crashDescriptions.isEmpty()) {
            return CollectionsKt.emptyList();
        }
        int maxSize = 10;
        long minTimestamp = System.currentTimeMillis() - 14400000L;
        List $this$sortBy$iv = crashDescriptions;
        boolean $i$f$sortBy = false;
        if ($this$sortBy$iv.size() > 1) {
            CollectionsKt.sortWith((List)$this$sortBy$iv, (Comparator)new Comparator(){

                public final int compare(T a, T b) {
                    CrashDescription it = (CrashDescription)a;
                    boolean bl = false;
                    Comparable comparable = Long.valueOf(it.getTimestamp());
                    it = (CrashDescription)b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getTimestamp()));
                }
            });
        }
        while (crashDescriptions.size() > maxSize) {
            crashDescription = (CrashDescription)CollectionsKt.removeFirst((List)crashDescriptions);
            Logger.d$default((String)"Removing obsolete crash", null, (int)2, null);
            crashDescription.delete();
        }
        while (((CrashDescription)CollectionsKt.first((List)crashDescriptions)).getTimestamp() < minTimestamp) {
            crashDescription = (CrashDescription)CollectionsKt.removeFirst((List)crashDescriptions);
            Logger.d$default((String)"Removing obsolete crash", null, (int)2, null);
            crashDescription.delete();
            if (!crashDescriptions.isEmpty()) continue;
            break;
        }
        return crashDescriptions;
    }

    private final CrashDescription read(File crashDir) {
        try {
            String crashDirName = crashDir.getName();
            Intrinsics.checkNotNullExpressionValue((Object)crashDirName, (String)"crashDirName");
            int i = StringsKt.lastIndexOf$default((CharSequence)crashDirName, (char)'_', (int)0, (boolean)false, (int)6, null);
            if (!(i >= 0)) {
                boolean $i$a$-check-CrashStorage$read$42 = false;
                String $i$a$-check-CrashStorage$read$42 = "Malformed directory name " + crashDirName;
                throw new IllegalStateException($i$a$-check-CrashStorage$read$42.toString());
            }
            String string = crashDirName.substring(0, i);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String typeString = string;
            ReportType type = ReportType.valueOf(typeString);
            String string2 = crashDirName.substring(i + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String timestampString = string2;
            long timestamp = Long.parseLong(timestampString);
            File systemInfoFile = FilesKt.resolve((File)crashDir, (String)FILE_SYSTEM_INFO);
            if (!systemInfoFile.exists()) {
                boolean $i$a$-check-CrashStorage$read$52 = false;
                String $i$a$-check-CrashStorage$read$52 = "No system info file";
                throw new IllegalStateException($i$a$-check-CrashStorage$read$52.toString());
            }
            File stacktraceFile = FilesKt.resolve((File)crashDir, (String)FILE_STACKTRACE);
            if (!stacktraceFile.exists()) {
                boolean $i$a$-check-CrashStorage$read$62 = false;
                String $i$a$-check-CrashStorage$read$62 = "No stacktrace file";
                throw new IllegalStateException($i$a$-check-CrashStorage$read$62.toString());
            }
            File tagsFile = FilesKt.resolve((File)crashDir, (String)FILE_TAGS);
            File allStacktracesFile = FilesKt.resolve((File)crashDir, (String)FILE_ALL_STACKTRACES);
            File logsFile = FilesKt.resolve((File)crashDir, (String)FILE_LOGS);
            Object[] objectArray = new Object[]{type, timestamp};
            Logger.d((String)"Detected crash with type %s, ts: %s", (Object[])objectArray);
            String string3 = crashDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"crashDir.path");
            String string4 = systemInfoFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"systemInfoFile.path");
            String string5 = tagsFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"tagsFile.path");
            String string6 = stacktraceFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"stacktraceFile.path");
            String string7 = allStacktracesFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"allStacktracesFile.path");
            String string8 = logsFile.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"logsFile.path");
            return new CrashDescription(timestamp, type, string3, string4, string5, string6, string7, string8);
        }
        catch (Exception ex) {
            Logger.e((String)"Malformed crash. Deleting", (Throwable)ex);
            FilesKt.deleteRecursively((File)crashDir);
            throw ex;
        }
    }

    public static final /* synthetic */ Comparator access$getTHREAD_COMPARATOR$cp() {
        return THREAD_COMPARATOR;
    }

    static {
        Comparator comparator = ComparisonsKt.nullsLast((Comparator)new Comparator(){

            public final int compare(T a, T b) {
                Thread t = (Thread)a;
                boolean bl = false;
                Comparable comparable = (Comparable)((Object)t.getName());
                t = (Thread)b;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)((Comparable)((Object)t.getName())));
            }
        });
        comparator = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    Thread t = (Thread)a;
                    boolean bl = false;
                    Thread thread = t;
                    t = (Thread)b;
                    Comparable comparable = thread != null ? (Comparable)Long.valueOf(thread.getId()) : (Comparable)Integer.valueOf(0);
                    bl = false;
                    Thread thread2 = t;
                    n = ComparisonsKt.compareValues((Comparable)comparable, (Comparable)(thread2 != null ? (Comparable)Long.valueOf(thread2.getId()) : (Comparable)Integer.valueOf(0)));
                }
                return n;
            }
        };
        THREAD_COMPARATOR = new Comparator(comparator){
            final /* synthetic */ Comparator $this_thenBy;
            {
                this.$this_thenBy = $receiver;
            }

            public final int compare(T a, T b) {
                int n;
                int previousCompare = this.$this_thenBy.compare(a, b);
                if (previousCompare != 0) {
                    n = previousCompare;
                } else {
                    T p0 = a;
                    boolean bl = false;
                    Comparable comparable = Integer.valueOf(System.identityHashCode(p0));
                    p0 = b;
                    Comparable comparable2 = comparable;
                    bl = false;
                    n = ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Integer.valueOf(System.identityHashCode(p0)));
                }
                return n;
            }
        };
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\"\u0010\u000b\u001a\u0016\u0012\u0006\u0012\u0004\u0018\u00010\r0\fj\n\u0012\u0006\u0012\u0004\u0018\u00010\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000f\u001a\u0012\u0012\u0004\u0012\u00020\r0\fj\b\u0012\u0004\u0012\u00020\r`\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/ok/tracer/crash/report/CrashStorage$Companion;", "", "()V", "DIR_CRASHES", "", "FILE_ALL_STACKTRACES", "FILE_LOGS", "FILE_STACKTRACE", "FILE_SYSTEM_INFO", "FILE_TAGS", "MAIN_THREAD_NAME", "THREAD_COMPARATOR", "Ljava/util/Comparator;", "Ljava/lang/Thread;", "Lkotlin/Comparator;", "THREAD_MAIN_FIRST_COMPARATOR", "tracer-crash-report_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

