/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.OutputStream;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.crash.report.LogEntryKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001b2\u00020\u0001:\u0001\u001bB\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\r\u001a\u00020\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0010\u001a\u00020\bH\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\b\u0002\u0010\u0017\u001a\u00020\bJ\u000e\u0010\u0018\u001a\u00020\u00142\u0006\u0010\u0019\u001a\u00020\u001aR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001c"}, d2={"Lru/ok/tracer/crash/report/LogEntry;", "", "ts", "", "messageBytes", "", "(J[B)V", "apiLineLength", "", "getApiLineLength", "()I", "getTs", "()J", "equals", "", "other", "hashCode", "toString", "", "writeToApi", "", "stream", "Ljava/io/OutputStream;", "seq", "writeToStorage", "output", "Ljava/io/DataOutput;", "Companion", "tracer-crash-report_release"})
public final class LogEntry {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final long ts;
    @NotNull
    private final byte[] messageBytes;
    private final int apiLineLength;

    private LogEntry(long ts, byte[] messageBytes) {
        this.ts = ts;
        this.messageBytes = messageBytes;
        this.apiLineLength = 30 + this.messageBytes.length;
    }

    public final long getTs() {
        return this.ts;
    }

    public final int getApiLineLength() {
        return this.apiLineLength;
    }

    public final void writeToApi(@NotNull OutputStream stream, int seq) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        OutputStream $this$writeToApi_u24lambda_u240 = stream;
        boolean bl = false;
        LogEntryKt.access$writeAscii($this$writeToApi_u24lambda_u240, '#');
        LogEntryKt.access$writeAscii($this$writeToApi_u24lambda_u240, String.valueOf(seq));
        LogEntryKt.access$writeAscii($this$writeToApi_u24lambda_u240, ' ');
        LogEntryKt.access$writeAscii($this$writeToApi_u24lambda_u240, String.valueOf(this.ts));
        LogEntryKt.access$writeAscii($this$writeToApi_u24lambda_u240, " | ");
        $this$writeToApi_u24lambda_u240.write(this.messageBytes);
        LogEntryKt.access$writeAscii($this$writeToApi_u24lambda_u240, '\n');
    }

    public static /* synthetic */ void writeToApi$default(LogEntry logEntry, OutputStream outputStream, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 0;
        }
        logEntry.writeToApi(outputStream, n);
    }

    public int hashCode() {
        return Long.hashCode(this.ts) | Arrays.hashCode(this.messageBytes);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof LogEntry && this.ts == ((LogEntry)other).ts && Arrays.equals(this.messageBytes, ((LogEntry)other).messageBytes);
    }

    @NotNull
    public String toString() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        OutputStream p0 = byteArrayOutputStream;
        boolean bl = false;
        LogEntry.writeToApi$default(this, p0, 0, 2, null);
        String string = byteArrayOutputStream.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"ByteArrayOutputStream().\u2026(::writeToApi).toString()");
        return string;
    }

    public final void writeToStorage(@NotNull DataOutput output) {
        Intrinsics.checkNotNullParameter((Object)output, (String)"output");
        output.writeLong(this.ts);
        output.writeInt(this.messageBytes.length);
        output.write(this.messageBytes);
    }

    public /* synthetic */ LogEntry(long ts, byte[] messageBytes, DefaultConstructorMarker $constructor_marker) {
        this(ts, messageBytes);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\nH\u0086\u0002J\u000e\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\r\u00a8\u0006\u000e"}, d2={"Lru/ok/tracer/crash/report/LogEntry$Companion;", "", "()V", "invoke", "Lru/ok/tracer/crash/report/LogEntry;", "ts", "", "message", "", "maxMessageLength", "", "parseFromStorage", "input", "Ljava/nio/ByteBuffer;", "tracer-crash-report_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LogEntry invoke(long ts, @NotNull String message, int maxMessageLength) {
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            String string = message;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return new LogEntry(ts, LogEntryKt.coerceUtf8SizeAtMost(byArray, maxMessageLength), null);
        }

        public static /* synthetic */ LogEntry invoke$default(Companion companion, long l, String string, int n, int n2, Object object) {
            if ((n2 & 4) != 0) {
                n = Integer.MAX_VALUE;
            }
            return companion.invoke(l, string, n);
        }

        @NotNull
        public final LogEntry parseFromStorage(@NotNull ByteBuffer input) throws BufferUnderflowException {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (!input.hasArray()) {
                boolean bl = false;
                String string = "Only buffers with backing array supported";
                throw new IllegalArgumentException(string.toString());
            }
            long ts = input.getLong();
            int messageLength = input.getInt();
            if (input.remaining() < messageLength) {
                throw new BufferUnderflowException();
            }
            int messageOffset = input.arrayOffset() + input.position();
            byte[] byArray = input.array();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"input.array()");
            byte[] byArray2 = byArray;
            int n = messageOffset + messageLength;
            LogEntry logEntry = new LogEntry(ts, ArraysKt.copyOfRange((byte[])byArray2, (int)messageOffset, (int)n), null);
            int p0 = input.position() + messageLength;
            boolean bl = false;
            input.position(p0);
            return logEntry;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

