/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.net.Uri;
import android.os.ConditionVariable;
import android.util.Log;
import java.io.Closeable;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.drop.DropManager;
import ru.ok.tracer.base.drop.DropRecordSerializer;
import ru.ok.tracer.base.http.HttpRequest;
import ru.ok.tracer.base.http.HttpRequestBody;
import ru.ok.tracer.base.http.HttpResponse;
import ru.ok.tracer.base.http.HttpResponseBody;
import ru.ok.tracer.crash.report.FEATURE_CRASH_FREEKt;
import ru.ok.tracer.session.SessionState;
import ru.ok.tracer.session.SessionStateStorage;
import ru.ok.tracer.session.SessionStatesSerializer;
import ru.ok.tracer.upload.NetworkResponseHandler;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerThreads;
import ru.ok.tracer.utils.config.ConfigStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0000\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u001e\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\u000e\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lru/ok/tracer/crash/report/SessionStateUploader;", "", "storage", "Lru/ok/tracer/session/SessionStateStorage;", "(Lru/ok/tracer/session/SessionStateStorage;)V", "dropManager", "Lru/ok/tracer/base/drop/DropManager;", "getDropManager", "()Lru/ok/tracer/base/drop/DropManager;", "sessionUploadCondition", "Landroid/os/ConditionVariable;", "collectAndUpload", "", "collectSessionStatesToUpload", "", "Lru/ok/tracer/session/SessionState;", "upload", "systemState", "Lru/ok/tracer/SystemState;", "prevSessionStates", "waitSessionUpload", "", "ms", "", "Companion", "tracer-crash-report_release"})
public final class SessionStateUploader {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final SessionStateStorage storage;
    @Nullable
    private volatile ConditionVariable sessionUploadCondition;
    @Deprecated
    private static final int MAX_SESSIONS_TO_UPLOAD = 4;
    @Deprecated
    private static final long MAX_SESSION_TIME_SPAN_TO_UPLOAD = TimeUnit.MINUTES.toMillis(30L);

    public SessionStateUploader(@NotNull SessionStateStorage storage) {
        Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
        this.storage = storage;
    }

    private final DropManager getDropManager() {
        return Tracer.INSTANCE.getDropManager();
    }

    public final boolean waitSessionUpload(long ms) {
        try {
            ConditionVariable conditionVariable = this.sessionUploadCondition;
            if (conditionVariable != null) {
                conditionVariable.block(ms);
            }
            return true;
        }
        catch (Exception e) {
            Logger.e((Throwable)e);
            return false;
        }
    }

    public final void collectAndUpload() {
        SystemState prevLaunchSystemState = this.storage.getPrevLaunchSystemState();
        if (prevLaunchSystemState == null) {
            return;
        }
        List<SessionState> prevSessionStates = this.collectSessionStatesToUpload();
        if (prevSessionStates.isEmpty()) {
            return;
        }
        try {
            this.upload(prevLaunchSystemState, prevSessionStates);
        }
        catch (Exception ex) {
            Logger.e((Throwable)ex);
        }
    }

    private final List<SessionState> collectSessionStatesToUpload() {
        long currentTs;
        if (ConfigStorage.isLimited$default((ConfigStorage)ConfigStorage.INSTANCE, (TracerFeature)FEATURE_CRASH_FREEKt.getFEATURE_CRASH_FREE(), null, (int)2, null)) {
            return CollectionsKt.emptyList();
        }
        List sessionStates = this.storage.getSessionStates();
        if (sessionStates.isEmpty()) {
            return sessionStates;
        }
        if (sessionStates.size() >= 4) {
            return sessionStates;
        }
        long lastTs = this.storage.getSessionStateUploadTs();
        if (lastTs + MAX_SESSION_TIME_SPAN_TO_UPLOAD <= (currentTs = System.currentTimeMillis())) {
            return sessionStates;
        }
        return CollectionsKt.emptyList();
    }

    private final void upload(SystemState systemState, List<SessionState> prevSessionStates) {
        ConditionVariable conditionVariable;
        Object[] p0;
        Logger.d$default((String)"Upload session", null, (int)2, null);
        String appToken = Tracer.INSTANCE.getAppToken();
        if (appToken == null) {
            Logger.w$default((String)"No app token", null, (int)2, null);
            return;
        }
        Collection drops = this.getDropManager().take();
        JSONObject bodyJsonObject = new JSONObject();
        bodyJsonObject.put("buildUuid", (Object)systemState.getBuildUuid());
        bodyJsonObject.put("deviceId", (Object)systemState.getDeviceId());
        Collection<Object> collection = prevSessionStates;
        SessionStatesSerializer sessionStatesSerializer = SessionStatesSerializer.INSTANCE;
        Iterable iterable = collection;
        String string = "sessions";
        JSONObject jSONObject = bodyJsonObject;
        boolean bl = false;
        JSONArray jSONArray = sessionStatesSerializer.toJsonArray((Iterable)p0);
        jSONObject.put(string, (Object)jSONArray);
        if (!drops.isEmpty()) {
            collection = drops;
            sessionStatesSerializer = DropRecordSerializer.INSTANCE;
            p0 = collection;
            string = "drops";
            jSONObject = bodyJsonObject;
            boolean bl2 = false;
            jSONArray = sessionStatesSerializer.toJsonArray(p0);
            jSONObject.put(string, (Object)jSONArray);
        }
        String p02 = CoreTracerConfiguration.Companion.get().getApiUrl();
        boolean bl3 = false;
        String string2 = Uri.parse((String)p02).buildUpon().appendEncodedPath("api/crash/trackSession").appendQueryParameter("crashToken", appToken).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CoreTracerConfiguration.\u2026)\n            .toString()");
        String url = string2;
        String string3 = bodyJsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"bodyJsonObject.toString()");
        HttpRequest request = new HttpRequest(url, HttpRequestBody.Companion.fromString$default((HttpRequestBody.Companion)HttpRequestBody.Companion, (String)"application/json; charset=utf-8", (String)string3, null, (int)4, null));
        p0 = new Object[]{request};
        Logger.d((String)"Request: %s", (Object[])p0);
        ConditionVariable it = conditionVariable = new ConditionVariable();
        boolean bl4 = false;
        this.sessionUploadCondition = it;
        ConditionVariable sessionUploadCondition = conditionVariable;
        TracerThreads.INSTANCE.runOnIo(() -> SessionStateUploader.upload$lambda$4(request, this, drops, sessionUploadCondition));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private static final void upload$lambda$4(HttpRequest $request, SessionStateUploader this$0, Collection $drops, ConditionVariable $sessionUploadCondition) {
        Intrinsics.checkNotNullParameter((Object)$request, (String)"$request");
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$drops, (String)"$drops");
        Intrinsics.checkNotNullParameter((Object)$sessionUploadCondition, (String)"$sessionUploadCondition");
        try {
            var4_4 = (Closeable)Tracer.INSTANCE.getHttpClient().execute($request);
            var5_7 = null;
            try {
                response = (HttpResponse)var4_4;
                $i$a$-use-SessionStateUploader$upload$3$1 = false;
                responseCode = response.getStatusCode();
                v0 = response.getBody();
                responseContentType = v0 != null ? v0.getContentType() : null;
                v1 /* !! */  = response.getBody();
                if (v1 /* !! */  == null) ** GOTO lbl-1000
                v2 = v1 /* !! */ .getBytes();
                v1 /* !! */  = (HttpResponseBody)v2;
                if (v2 != null) {
                    v3 = StringsKt.decodeToString((byte[])v1 /* !! */ );
                } else lbl-1000:
                // 2 sources

                {
                    v3 = null;
                }
                responseContent = v3;
                NetworkResponseHandler.universalHandleResponse$default((NetworkResponseHandler)NetworkResponseHandler.INSTANCE, (String)responseContentType, (String)responseContent, (String)FEATURE_CRASH_FREEKt.getFEATURE_CRASH_FREE().getName(), null, (int)8, null);
                if (responseCode != 200) {
                    v4 = Log.e((String)"Tracer", (String)("HTTP " + responseCode + ", " + responseContent));
                } else {
                    var11_15 = new Object[]{"Result: " + responseContent};
                    Logger.d((String)"Tracer", (Object[])var11_15);
                    this$0.storage.consumePrevSessionStates();
                    v4 = Unit.INSTANCE;
                }
                var6_8 = v4;
            }
            catch (Throwable var6_9) {
                var5_7 = var6_9;
                throw var6_9;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var4_4, (Throwable)var5_7);
            }
        }
        catch (Exception ex) {
            Logger.e((Throwable)ex);
            this$0.getDropManager().drop($drops);
        }
        finally {
            $sessionUploadCondition.open();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lru/ok/tracer/crash/report/SessionStateUploader$Companion;", "", "()V", "MAX_SESSIONS_TO_UPLOAD", "", "MAX_SESSION_TIME_SPAN_TO_UPLOAD", "", "tracer-crash-report_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

