/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.content.Context;
import java.util.Collection;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.LogLevel;
import ru.ok.tracer.Severity;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.crash.report.AnrReporter;
import ru.ok.tracer.crash.report.AnrSnapshotStorage;
import ru.ok.tracer.crash.report.AnrWatchdogThread;
import ru.ok.tracer.crash.report.CrashDescription;
import ru.ok.tracer.crash.report.CrashFreeConfiguration;
import ru.ok.tracer.crash.report.CrashLoggerInternal;
import ru.ok.tracer.crash.report.CrashReportConfiguration;
import ru.ok.tracer.crash.report.CrashStorage;
import ru.ok.tracer.crash.report.CrashUploader;
import ru.ok.tracer.crash.report.LogStorage;
import ru.ok.tracer.crash.report.SessionStateUploader;
import ru.ok.tracer.crash.report.TracerNativeCrashReport;
import ru.ok.tracer.crash.report.TracerUncaughtExceptionHandler;
import ru.ok.tracer.session.SessionStateStorage;
import ru.ok.tracer.session.TagsStorage;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerThreads;
import ru.ok.tracer.utils.UncaughtExceptionHandlers;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u000eJ\u0010\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u001c\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0007J$\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0007J$\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0013\u001a\u00020\u00142\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0007J$\u0010\u001a\u001a\u00020\u000b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0011H\u0003J\u0015\u0010\u001b\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\u0014H\u0001\u00a2\u0006\u0002\b\u001cR\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u001d"}, d2={"Lru/ok/tracer/crash/report/TracerCrashReport;", "", "()V", "crashLoggerInternal", "Lru/ok/tracer/crash/report/CrashLoggerInternal;", "isConfigDisabled", "", "isDisabled", "isDisabled$tracer_crash_report_release", "()Z", "init", "", "context", "Landroid/content/Context;", "init$tracer_crash_report_release", "log", "msg", "", "report", "e", "", "issueKey", "logLevel", "Lru/ok/tracer/LogLevel;", "severity", "Lru/ok/tracer/Severity;", "reportCaughtException", "reportUncaughtException", "reportUncaughtException$tracer_crash_report_release", "tracer-crash-report_release"})
public final class TracerCrashReport {
    @NotNull
    public static final TracerCrashReport INSTANCE = new TracerCrashReport();
    @Nullable
    private static CrashLoggerInternal crashLoggerInternal;
    private static boolean isConfigDisabled;

    private TracerCrashReport() {
    }

    public final boolean isDisabled$tracer_crash_report_release() {
        return isConfigDisabled || Tracer.isDisabled();
    }

    public final void init$tracer_crash_report_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        CrashReportConfiguration config = CrashReportConfiguration.Companion.get$tracer_crash_report_release();
        if (!config.getEnabled$tracer_crash_report_release()) {
            isConfigDisabled = true;
            return;
        }
        if (config.getNativeEnabled$tracer_crash_report_release()) {
            TracerNativeCrashReport.INSTANCE.installExceptionHandler$tracer_crash_report_release(context);
        }
        CrashFreeConfiguration crashFreeConfig = CrashFreeConfiguration.Companion.get$tracer_crash_report_release();
        SessionStateStorage stateStorage = Tracer.INSTANCE.getStateStorage();
        TagsStorage tagStorage = Tracer.INSTANCE.getTagsStorage();
        CrashStorage crashStorage = new CrashStorage(context);
        LogStorage logStorage = new LogStorage(context, config.getMaxLogsLength$tracer_crash_report_release());
        CrashUploader crashUploader = new CrashUploader();
        SessionStateUploader stateUploader = new SessionStateUploader(stateStorage);
        AnrSnapshotStorage snapshotStorage = new AnrSnapshotStorage(config.getAnrSnapshotsMaxCount$tracer_crash_report_release(), context);
        crashLoggerInternal = new CrashLoggerInternal(crashStorage, stateStorage, tagStorage, logStorage, stateUploader, crashUploader);
        TracerThreads.INSTANCE.runOnIo(() -> TracerCrashReport.init$lambda$0(config, context, stateStorage, tagStorage, logStorage, crashStorage, snapshotStorage, crashFreeConfig, stateUploader, crashUploader));
        if (crashFreeConfig.getEnabled$tracer_crash_report_release()) {
            stateStorage.addOnRenewSessionListener(() -> TracerCrashReport.init$lambda$2(stateUploader));
        }
        UncaughtExceptionHandlers.prependDefault((Thread.UncaughtExceptionHandler)new TracerUncaughtExceptionHandler());
    }

    @JvmStatic
    @JvmOverloads
    public static final void report(@NotNull Throwable e, @Nullable String issueKey) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TracerCrashReport.reportCaughtException(null, e, issueKey);
    }

    public static /* synthetic */ void report$default(Throwable throwable, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = null;
        }
        TracerCrashReport.report(throwable, string);
    }

    @JvmStatic
    @JvmOverloads
    public static final void report(@NotNull Severity severity, @NotNull Throwable e, @Nullable String issueKey) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TracerCrashReport.reportCaughtException(severity, e, issueKey);
    }

    public static /* synthetic */ void report$default(Severity severity, Throwable throwable, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        TracerCrashReport.report(severity, throwable, string);
    }

    @Deprecated(message="Use Severity instead")
    @JvmStatic
    @JvmOverloads
    public static final void report(@NotNull LogLevel logLevel, @NotNull Throwable e, @Nullable String issueKey) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TracerCrashReport.reportCaughtException(logLevel.toSeverity(), e, issueKey);
    }

    public static /* synthetic */ void report$default(LogLevel logLevel, Throwable throwable, String string, int n, Object object) {
        if ((n & 4) != 0) {
            string = null;
        }
        TracerCrashReport.report(logLevel, throwable, string);
    }

    /*
     * Unable to fully structure code
     */
    @JvmStatic
    private static final void reportCaughtException(Severity severity, Throwable e, String issueKey) {
        if (TracerCrashReport.INSTANCE.isDisabled$tracer_crash_report_release()) {
            Logger.d$default((String)"Tracer is disabled", null, (int)2, null);
            return;
        }
        try {
            v0 = TracerCrashReport.crashLoggerInternal;
            if (v0 == null) {
                var5_3 = "Required value was null.";
                throw new IllegalStateException(var5_3.toString());
            }
            var4_5 = v0;
        }
        catch (IllegalStateException ex) {
            Logger.e((String)(TracerCrashReport.INSTANCE.getClass().getName() + " was not initialized properly"), (Throwable)ex);
            return;
        }
        v1 = crashLoggerInternal = var4_5;
        v2 = severity;
        v3 = e;
        v4 = issueKey;
        if (v4 == null || (v4 = StringsKt.trim((CharSequence)v4).toString()) == null) ** GOTO lbl-1000
        var7_8 = var6_7 = v4;
        var11_9 = v3;
        var10_10 = v2;
        var9_11 = v1;
        $i$a$-takeIf-TracerCrashReport$reportCaughtException$1 = false;
        var12_13 = ((CharSequence)p0).length() > 0;
        v1 = var9_11;
        v2 = var10_10;
        v3 = var11_9;
        v4 = var12_13 != false ? var6_7 : null;
        if (v4 != null) {
            v5 = StringsKt.take((String)v4, (int)32);
        } else lbl-1000:
        // 2 sources

        {
            v5 = null;
        }
        v1.reportNonFatal(v2, v3, v5);
    }

    @JvmStatic
    public static final void reportUncaughtException$tracer_crash_report_release(@NotNull Throwable e) {
        CrashLoggerInternal crashLoggerInternal;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (INSTANCE.isDisabled$tracer_crash_report_release()) {
            Logger.d$default((String)"Tracer is disabled", null, (int)2, null);
            return;
        }
        try {
            CrashLoggerInternal crashLoggerInternal2 = TracerCrashReport.crashLoggerInternal;
            if (crashLoggerInternal2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            crashLoggerInternal = crashLoggerInternal2;
        }
        catch (IllegalStateException ex) {
            Logger.e((String)(INSTANCE.getClass().getName() + " was not initialized properly"), (Throwable)ex);
            return;
        }
        CrashLoggerInternal crashLoggerInternal3 = crashLoggerInternal;
        crashLoggerInternal3.reportCrash(e);
    }

    @JvmStatic
    public static final void log(@NotNull String msg) {
        CrashLoggerInternal crashLoggerInternal;
        Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
        if (INSTANCE.isDisabled$tracer_crash_report_release()) {
            return;
        }
        try {
            CrashLoggerInternal crashLoggerInternal2 = TracerCrashReport.crashLoggerInternal;
            if (crashLoggerInternal2 == null) {
                String string = "Required value was null.";
                throw new IllegalStateException(string.toString());
            }
            crashLoggerInternal = crashLoggerInternal2;
        }
        catch (IllegalStateException ex) {
            Logger.e((String)(INSTANCE.getClass().getName() + " was not initialized properly"), (Throwable)ex);
            return;
        }
        CrashLoggerInternal crashLoggerInternal3 = crashLoggerInternal;
        crashLoggerInternal3.log(msg);
    }

    @JvmStatic
    @JvmOverloads
    public static final void report(@NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TracerCrashReport.report$default(e, null, 2, null);
    }

    @JvmStatic
    @JvmOverloads
    public static final void report(@NotNull Severity severity, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)severity, (String)"severity");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TracerCrashReport.report$default(severity, e, null, 4, null);
    }

    @Deprecated(message="Use Severity instead")
    @JvmStatic
    @JvmOverloads
    public static final void report(@NotNull LogLevel logLevel, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)logLevel, (String)"logLevel");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        TracerCrashReport.report$default(logLevel, e, null, 4, null);
    }

    private static final void init$lambda$0(CrashReportConfiguration $config, Context $context, SessionStateStorage $stateStorage, TagsStorage $tagStorage, LogStorage $logStorage, CrashStorage $crashStorage, AnrSnapshotStorage $snapshotStorage, CrashFreeConfiguration $crashFreeConfig, SessionStateUploader $stateUploader, CrashUploader $crashUploader) {
        Intrinsics.checkNotNullParameter((Object)$config, (String)"$config");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        Intrinsics.checkNotNullParameter((Object)$stateStorage, (String)"$stateStorage");
        Intrinsics.checkNotNullParameter((Object)$tagStorage, (String)"$tagStorage");
        Intrinsics.checkNotNullParameter((Object)$logStorage, (String)"$logStorage");
        Intrinsics.checkNotNullParameter((Object)$crashStorage, (String)"$crashStorage");
        Intrinsics.checkNotNullParameter((Object)$snapshotStorage, (String)"$snapshotStorage");
        Intrinsics.checkNotNullParameter((Object)$crashFreeConfig, (String)"$crashFreeConfig");
        Intrinsics.checkNotNullParameter((Object)$stateUploader, (String)"$stateUploader");
        Intrinsics.checkNotNullParameter((Object)$crashUploader, (String)"$crashUploader");
        if ($config.getSendAnr$tracer_crash_report_release()) {
            AnrReporter.INSTANCE.check($context, $stateStorage, $tagStorage, $logStorage, $crashStorage, $snapshotStorage);
        }
        if ($config.getNativeEnabled$tracer_crash_report_release()) {
            TracerNativeCrashReport.INSTANCE.check$tracer_crash_report_release($context, $stateStorage, $tagStorage, $logStorage, $crashStorage);
        }
        if ($crashFreeConfig.getEnabled$tracer_crash_report_release()) {
            $stateUploader.collectAndUpload();
        }
        if ($config.getAnrSnapshotsEnabled$tracer_crash_report_release()) {
            $snapshotStorage.clean();
            AnrWatchdogThread thread = new AnrWatchdogThread($snapshotStorage, $config.getAnrSnapshotsDelayMs$tracer_crash_report_release(), $config.getAnrSnapshotsIntervalMs$tracer_crash_report_release());
            thread.start();
        }
        if (INSTANCE.isDisabled$tracer_crash_report_release()) {
            $crashStorage.deleteAll();
            return;
        }
        List<CrashDescription> crashDescriptions = $crashStorage.readAll();
        if (!((Collection)crashDescriptions).isEmpty()) {
            $crashUploader.upload(crashDescriptions);
        }
        $logStorage.clearPrevLogs();
        $tagStorage.clearPrevTags();
    }

    private static final void init$lambda$2$lambda$1(SessionStateUploader $stateUploader) {
        Intrinsics.checkNotNullParameter((Object)$stateUploader, (String)"$stateUploader");
        $stateUploader.collectAndUpload();
    }

    private static final void init$lambda$2(SessionStateUploader $stateUploader) {
        Intrinsics.checkNotNullParameter((Object)$stateUploader, (String)"$stateUploader");
        TracerThreads.INSTANCE.runOnIo(() -> TracerCrashReport.init$lambda$2$lambda$1($stateUploader));
    }
}

