/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.crash.report;

import android.content.Context;
import java.io.File;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.crash.report.CrashStorage;
import ru.ok.tracer.crash.report.LogStorage;
import ru.ok.tracer.crash.report.ReportType;
import ru.ok.tracer.minidump.Minidump;
import ru.ok.tracer.session.SessionState;
import ru.ok.tracer.session.SessionStateStorage;
import ru.ok.tracer.session.TagsStorage;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0004\b\b\u0010\tJ5\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0000\u00a2\u0006\u0002\b\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\rH\u0002J\u0015\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0000\u00a2\u0006\u0002\b\u001aR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lru/ok/tracer/crash/report/TracerNativeCrashReport;", "", "()V", "DIR_MINIDUMP", "", "calculateEnabled", "", "explicitEnabled", "calculateEnabled$tracer_crash_report_release", "(Ljava/lang/Boolean;)Z", "check", "", "context", "Landroid/content/Context;", "stateStorage", "Lru/ok/tracer/session/SessionStateStorage;", "tagsStorage", "Lru/ok/tracer/session/TagsStorage;", "logStorage", "Lru/ok/tracer/crash/report/LogStorage;", "crashStorage", "Lru/ok/tracer/crash/report/CrashStorage;", "check$tracer_crash_report_release", "getMinidumpDir", "Ljava/io/File;", "installExceptionHandler", "installExceptionHandler$tracer_crash_report_release", "tracer-crash-report_release"})
public final class TracerNativeCrashReport {
    @NotNull
    public static final TracerNativeCrashReport INSTANCE = new TracerNativeCrashReport();
    @NotNull
    private static final String DIR_MINIDUMP = "minidump";

    private TracerNativeCrashReport() {
    }

    public final boolean calculateEnabled$tracer_crash_report_release(@Nullable Boolean explicitEnabled) {
        boolean bl;
        if (Intrinsics.areEqual((Object)explicitEnabled, (Object)false)) {
            bl = false;
        } else {
            boolean bl2;
            try {
                Minidump.getInstance();
                bl2 = true;
            }
            catch (Throwable ex) {
                if (Intrinsics.areEqual((Object)explicitEnabled, (Object)true)) {
                    Logger.e((String)"Native crash reporting enabled but failed. Do you depend on ru.ok.tracer:tracer-crash-report-native", (Throwable)ex);
                }
                bl2 = false;
            }
            bl = bl2;
        }
        return bl;
    }

    public final void check$tracer_crash_report_release(@NotNull Context context, @NotNull SessionStateStorage stateStorage, @NotNull TagsStorage tagsStorage, @NotNull LogStorage logStorage, @NotNull CrashStorage crashStorage) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)stateStorage, (String)"stateStorage");
        Intrinsics.checkNotNullParameter((Object)tagsStorage, (String)"tagsStorage");
        Intrinsics.checkNotNullParameter((Object)logStorage, (String)"logStorage");
        Intrinsics.checkNotNullParameter((Object)crashStorage, (String)"crashStorage");
        File minidumpDir = this.getMinidumpDir(context);
        if (!minidumpDir.exists()) {
            return;
        }
        File[] minidumpFiles = minidumpDir.listFiles();
        File[] fileArray = minidumpFiles;
        if (fileArray == null || fileArray.length == 0) {
            return;
        }
        SystemState prevLaunchSystemState = stateStorage.getPrevLaunchSystemState();
        if (prevLaunchSystemState == null) {
            Logger.w$default((String)"No prev system state but have minidumps", null, (int)2, null);
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)minidumpFiles, (String)"minidumpFiles");
        for (File minidumpFile : minidumpFiles) {
            byte[] byArray;
            try {
                Intrinsics.checkNotNullExpressionValue((Object)minidumpFile, (String)"minidumpFile");
                byArray = FilesKt.readBytes((File)minidumpFile);
            }
            catch (Exception ex) {
                Logger.e((Throwable)ex);
                continue;
            }
            byte[] minidumpBytes = byArray;
            try {
                FileUtils.deleteChecked((File)minidumpFile);
            }
            catch (Exception ex) {
                Logger.e((Throwable)ex);
                continue;
            }
            if (minidumpBytes.length == 0) {
                Logger.w$default((String)("Empty minidump. " + minidumpFile), null, (int)2, null);
                continue;
            }
            CrashStorage.save$default(crashStorage, ReportType.MINIDUMP, minidumpBytes, prevLaunchSystemState, tagsStorage.getPrevTags(), null, logStorage.getPrevLogs(), 16, null);
            stateStorage.setPrevLaunchSessionStatus(SessionState.Status.NATIVE);
        }
    }

    public final void installExceptionHandler$tracer_crash_report_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        try {
            File dir = this.getMinidumpDir(context);
            FileUtils.mkdirsChecked((File)dir);
            Minidump.getInstance().installMinidumpWriter(dir.getPath());
        }
        catch (Throwable ex) {
            Logger.e((Throwable)ex);
        }
    }

    private final File getMinidumpDir(Context context) {
        return FilesKt.resolve((File)TracerFiles.INSTANCE.getTracerDir(context), (String)DIR_MINIDUMP);
    }
}

