/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.disk.usage;

import android.content.Context;
import android.content.pm.ApplicationInfo;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.disk.usage.DiskUsageConfiguration;
import ru.ok.tracer.disk.usage.DiskUsageWorker;
import ru.ok.tracer.disk.usage.FEATURE_DISK_USAGEKt;
import ru.ok.tracer.disk.usage.GlobalDirs;
import ru.ok.tracer.upload.SampleUploader;
import ru.ok.tracer.utils.KtxExtensionsKt;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;
import ru.ok.tracer.utils.config.ConfigStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\u0018\u0000 '2\u00020\u0001:\u0002'(B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J\u0012\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0002J$\u0010\u0013\u001a\u00020\u00142\u0012\u0010\u0015\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u00162\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0010\u0010\u0013\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0018H\u0002J.\u0010\u001d\u001a\u00020\u001e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u00142\u0006\u0010 \u001a\u00020\u00172\u0012\u0010!\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00180\u0016H\u0002J&\u0010\"\u001a\u00020\u00182\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010#\u001a\u00020$2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020\u00120&H\u0002R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\n\u00a8\u0006)"}, d2={"Lru/ok/tracer/disk/usage/DiskUsageWorker;", "Landroidx/work/Worker;", "context", "Landroid/content/Context;", "workerParameters", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "config", "Lru/ok/tracer/disk/usage/DiskUsageConfiguration;", "getConfig", "()Lru/ok/tracer/disk/usage/DiskUsageConfiguration;", "config$delegate", "Lkotlin/Lazy;", "doWork", "Landroidx/work/ListenableWorker$Result;", "isSymlink", "", "file", "Ljava/io/File;", "toJson", "", "consumersDirs", "", "Lru/ok/tracer/disk/usage/GlobalDirs;", "Lru/ok/tracer/disk/usage/DiskUsageWorker$SpaceConsumer;", "total", "", "Lorg/json/JSONObject;", "consumer", "topConsumers", "", "dir", "globalDir", "out", "walkTree", "depth", "", "excludedPath", "", "Companion", "SpaceConsumer", "tracer-disk-usage_release"})
public final class DiskUsageWorker
extends Worker {
    @NotNull
    private static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy config$delegate;
    @Deprecated
    private static final int MAX_DEPTH = 6;
    @Deprecated
    private static final int MAX_ENTRIES = 20;

    public DiskUsageWorker(@NotNull Context context, @NotNull WorkerParameters workerParameters) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workerParameters, (String)"workerParameters");
        super(context, workerParameters);
        this.config$delegate = LazyKt.lazy((Function0)config.2.INSTANCE);
    }

    private final DiskUsageConfiguration getConfig() {
        Lazy lazy = this.config$delegate;
        return (DiskUsageConfiguration)lazy.getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public ListenableWorker.Result doWork() {
        if (ConfigStorage.isLimited$default((ConfigStorage)ConfigStorage.INSTANCE, (TracerFeature)FEATURE_DISK_USAGEKt.getFEATURE_DISK_USAGE(), null, (int)2, null)) {
            Logger.d$default((String)"Skip. Limited", null, (int)2, null);
            ListenableWorker.Result result = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
            return result;
        }
        if (!KtxExtensionsKt.testProbability((Long)this.getConfig().getProbability())) {
            Logger.d$default((String)"Skip. Probability", null, (int)2, null);
            ListenableWorker.Result result = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
            return result;
        }
        Logger.d$default((String)"Collecting disk usage stats", null, (int)2, null);
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        Context appCtx = context;
        ApplicationInfo info = appCtx.getApplicationInfo();
        Map dirsConsumers = new LinkedHashMap();
        try {
            this.topConsumers(info.dataDir, GlobalDirs.INTERNAL_DATA, dirsConsumers);
            File file = appCtx.getExternalFilesDir(null);
            this.topConsumers(file != null && (file = file.getParentFile()) != null ? file.getPath() : null, GlobalDirs.EXTERNAL_DATA, dirsConsumers);
            File file2 = new File(info.sourceDir).getParentFile();
            this.topConsumers(file2 != null ? file2.getPath() : null, GlobalDirs.SRC, dirsConsumers);
            Object[] objectArray = (Object[])dirsConsumers.values();
            long l = 0L;
            for (Object t : objectArray) {
                void it;
                SpaceConsumer spaceConsumer = (SpaceConsumer)t;
                long l2 = l;
                boolean bl = false;
                long l3 = it.getSize();
                l = l2 + l3;
            }
            long total = l;
            objectArray = new Object[]{total};
            Logger.d((String)"Total: %s", (Object[])objectArray);
            long interestingSizeBytes = this.getConfig().getInterestingSizeBytes();
            if (total > interestingSizeBytes) {
                Context context2 = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"applicationContext");
                File reportFile = TracerFiles.getNewSampleFile$default((TracerFiles)TracerFiles.INSTANCE, (Context)context2, (TracerFeature)FEATURE_DISK_USAGEKt.getFEATURE_DISK_USAGE(), null, (int)4, null);
                String report = this.toJson(dirsConsumers, total);
                Logger.d$default((String)report, null, (int)2, null);
                FilesKt.writeText$default((File)reportFile, (String)report, null, (int)2, null);
                Context context3 = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context3, (String)"applicationContext");
                SampleUploader.upload$default((SampleUploader)SampleUploader.INSTANCE, (Context)context3, (TracerFeature)FEATURE_DISK_USAGEKt.getFEATURE_DISK_USAGE(), (File)reportFile, (boolean)false, null, (Long)total, (Map)MapsKt.mapOf((Pair)TuplesKt.to((Object)"limit", (Object)String.valueOf(interestingSizeBytes))), (int)24, null);
            } else {
                Object[] objectArray2 = new Object[]{interestingSizeBytes};
                Logger.d((String)"Discard. Limit: %s", (Object[])objectArray2);
            }
        }
        catch (Exception e) {
            Logger.e((Throwable)e);
            ListenableWorker.Result result = ListenableWorker.Result.failure();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"failure()");
            return result;
        }
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
        return result;
    }

    private final String toJson(Map<GlobalDirs, SpaceConsumer> consumersDirs, long total) {
        JSONObject jsonObject = new JSONObject();
        JSONObject consumersJson = new JSONObject();
        Iterable $this$forEach$iv = consumersDirs.entrySet();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Map.Entry consDir = (Map.Entry)element$iv;
            boolean bl = false;
            consumersJson.put(((GlobalDirs)((Object)consDir.getKey())).getTag(), (Object)this.toJson((SpaceConsumer)consDir.getValue()));
        }
        jsonObject.put("consumers", (Object)consumersJson);
        jsonObject.put("total_size", total);
        String string = jsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final JSONObject toJson(SpaceConsumer consumer) {
        JSONObject obj = new JSONObject();
        obj.put("size", consumer.getSize());
        obj.put("name", (Object)consumer.getName());
        if (consumer.isDirectory()) {
            obj.put("is_dir", true);
        }
        if (consumer.getOverflow()) {
            obj.put("is_overflow", true);
        }
        if (consumer.getExcluded()) {
            obj.put("is_excluded", true);
        }
        if (!((Collection)consumer.getChildren()).isEmpty()) {
            void $this$mapTo$iv$iv;
            JSONArray childrenJson = new JSONArray();
            Iterable $this$map$iv = consumer.getChildren();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                SpaceConsumer spaceConsumer = (SpaceConsumer)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                collection.add(childrenJson.put((Object)this.toJson((SpaceConsumer)it)));
            }
            List cfr_ignored_0 = (List)destination$iv$iv;
            obj.put("children", (Object)childrenJson);
        }
        return obj;
    }

    /*
     * WARNING - void declaration
     */
    private final void topConsumers(String dir, GlobalDirs globalDir, Map<GlobalDirs, SpaceConsumer> out) throws IOException {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        String it;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        if (dir == null) {
            return;
        }
        String tag = globalDir.getTag();
        File rootFile = new File(dir);
        Iterable iterable = this.getConfig().getExcludedPaths();
        boolean $i$f$filter = false;
        void var9_8 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (String)element$iv$iv;
            boolean bl = false;
            if (!StringsKt.startsWith$default((String)it, (String)(tag + ':'), (boolean)false, (int)2, null)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = it.substring(tag.length() + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            collection.add(FilesKt.resolve((File)rootFile, (String)string));
        }
        List excludedPath = (List)destination$iv$iv;
        out.put(globalDir, this.walkTree(rootFile, 0, excludedPath));
    }

    /*
     * WARNING - void declaration
     */
    private final SpaceConsumer walkTree(File file, int depth, List<? extends File> excludedPath) {
        long l;
        List list;
        if (excludedPath.contains(file)) {
            Logger.d$default((String)("File excluded " + file), null, (int)2, null);
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return new SpaceConsumer(0L, string, false, null, false, true, 28, null);
        }
        if (!file.isDirectory()) {
            long l2 = file.length();
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return new SpaceConsumer(l2, string, false, null, false, false, 60, null);
        }
        if (this.isSymlink(file)) {
            String string = file.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
            return new SpaceConsumer(0L, string, true, null, false, false, 56, null);
        }
        File[] fileArray = file.listFiles();
        if (fileArray != null) {
            void $this$mapTo$iv$iv;
            File[] $this$map$iv = fileArray;
            boolean $i$f$map = false;
            File[] fileArray2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.length);
            boolean $i$f$mapTo = false;
            int n = ((void)$this$mapTo$iv$iv).length;
            for (int i = 0; i < n; ++i) {
                void it;
                void item$iv$iv;
                void var15_21 = item$iv$iv = $this$mapTo$iv$iv[i];
                Collection collection = destination$iv$iv;
                boolean bl = false;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                collection.add(this.walkTree((File)it, depth + 1, excludedPath));
            }
            list = (List)destination$iv$iv;
        } else {
            list = CollectionsKt.emptyList();
        }
        List children = list;
        int dirSelfSize = 4096;
        Iterable $i$f$map = children;
        long l3 = dirSelfSize;
        long $this$mapTo$iv$iv = 0L;
        for (Object t : $i$f$map) {
            void it;
            SpaceConsumer spaceConsumer = (SpaceConsumer)t;
            l = $this$mapTo$iv$iv;
            boolean bl = false;
            long l4 = it.getSize();
            $this$mapTo$iv$iv = l + l4;
        }
        l = $this$mapTo$iv$iv;
        long dirSize = l3 + l;
        boolean overflow = false;
        if (depth > 6) {
            Logger.d$default((String)("Max depth reached for " + file), null, (int)2, null);
            children = CollectionsKt.emptyList();
            overflow = true;
        }
        Iterable $this$sortedByDescending$iv = children;
        boolean $i$f$sortedByDescending = false;
        children = CollectionsKt.sortedWith((Iterable)$this$sortedByDescending$iv, (Comparator)new Comparator(){

            public final int compare(T a, T b) {
                SpaceConsumer it = (SpaceConsumer)b;
                boolean bl = false;
                Comparable comparable = Long.valueOf(it.getSize());
                it = (SpaceConsumer)a;
                Comparable comparable2 = comparable;
                bl = false;
                return ComparisonsKt.compareValues((Comparable)comparable2, (Comparable)Long.valueOf(it.getSize()));
            }
        });
        if (children.size() > 20) {
            Logger.d$default((String)("Max children reached for " + file), null, (int)2, null);
            children = children.subList(0, 20);
            overflow = true;
        }
        String string = file.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
        return new SpaceConsumer(dirSize, string, true, children, overflow, false, 32, null);
    }

    private final boolean isSymlink(File file) {
        boolean bl;
        try {
            File file2;
            if (file == null) {
                throw new NullPointerException("File must not be null");
            }
            File parentFile = file.getParentFile();
            if (parentFile == null) {
                file2 = file;
            } else {
                File canonDir = parentFile.getCanonicalFile();
                file2 = new File(canonDir, file.getName());
            }
            File canon = file2;
            bl = !Intrinsics.areEqual((Object)canon.getCanonicalFile(), (Object)canon.getAbsoluteFile());
        }
        catch (IOException e) {
            bl = false;
        }
        return bl;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010 \n\u0002\b\u0016\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001BC\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\fJ\t\u0010\u0016\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0017\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0018\u001a\u00020\u0007H\u00c6\u0003J\u000f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00000\tH\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003JK\u0010\u001c\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t2\b\b\u0002\u0010\n\u001a\u00020\u00072\b\b\u0002\u0010\u000b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001d\u001a\u00020\u00072\b\u0010\u001e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u0005H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00000\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\n\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0010R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015\u00a8\u0006\""}, d2={"Lru/ok/tracer/disk/usage/DiskUsageWorker$SpaceConsumer;", "", "size", "", "name", "", "isDirectory", "", "children", "", "overflow", "excluded", "(JLjava/lang/String;ZLjava/util/List;ZZ)V", "getChildren", "()Ljava/util/List;", "getExcluded", "()Z", "getName", "()Ljava/lang/String;", "getOverflow", "getSize", "()J", "component1", "component2", "component3", "component4", "component5", "component6", "copy", "equals", "other", "hashCode", "", "toString", "tracer-disk-usage_release"})
    public static final class SpaceConsumer {
        private final long size;
        @NotNull
        private final String name;
        private final boolean isDirectory;
        @NotNull
        private final List<SpaceConsumer> children;
        private final boolean overflow;
        private final boolean excluded;

        public SpaceConsumer(long size, @NotNull String name, boolean isDirectory, @NotNull List<SpaceConsumer> children, boolean overflow, boolean excluded) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            this.size = size;
            this.name = name;
            this.isDirectory = isDirectory;
            this.children = children;
            this.overflow = overflow;
            this.excluded = excluded;
        }

        public /* synthetic */ SpaceConsumer(long l, String string, boolean bl, List list, boolean bl2, boolean bl3, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 4) != 0) {
                bl = false;
            }
            if ((n & 8) != 0) {
                list = CollectionsKt.emptyList();
            }
            if ((n & 0x10) != 0) {
                bl2 = false;
            }
            if ((n & 0x20) != 0) {
                bl3 = false;
            }
            this(l, string, bl, list, bl2, bl3);
        }

        public final long getSize() {
            return this.size;
        }

        @NotNull
        public final String getName() {
            return this.name;
        }

        public final boolean isDirectory() {
            return this.isDirectory;
        }

        @NotNull
        public final List<SpaceConsumer> getChildren() {
            return this.children;
        }

        public final boolean getOverflow() {
            return this.overflow;
        }

        public final boolean getExcluded() {
            return this.excluded;
        }

        public final long component1() {
            return this.size;
        }

        @NotNull
        public final String component2() {
            return this.name;
        }

        public final boolean component3() {
            return this.isDirectory;
        }

        @NotNull
        public final List<SpaceConsumer> component4() {
            return this.children;
        }

        public final boolean component5() {
            return this.overflow;
        }

        public final boolean component6() {
            return this.excluded;
        }

        @NotNull
        public final SpaceConsumer copy(long size, @NotNull String name, boolean isDirectory, @NotNull List<SpaceConsumer> children, boolean overflow, boolean excluded) {
            Intrinsics.checkNotNullParameter((Object)name, (String)"name");
            Intrinsics.checkNotNullParameter(children, (String)"children");
            return new SpaceConsumer(size, name, isDirectory, children, overflow, excluded);
        }

        public static /* synthetic */ SpaceConsumer copy$default(SpaceConsumer spaceConsumer, long l, String string, boolean bl, List list, boolean bl2, boolean bl3, int n, Object object) {
            if ((n & 1) != 0) {
                l = spaceConsumer.size;
            }
            if ((n & 2) != 0) {
                string = spaceConsumer.name;
            }
            if ((n & 4) != 0) {
                bl = spaceConsumer.isDirectory;
            }
            if ((n & 8) != 0) {
                list = spaceConsumer.children;
            }
            if ((n & 0x10) != 0) {
                bl2 = spaceConsumer.overflow;
            }
            if ((n & 0x20) != 0) {
                bl3 = spaceConsumer.excluded;
            }
            return spaceConsumer.copy(l, string, bl, list, bl2, bl3);
        }

        @NotNull
        public String toString() {
            return "SpaceConsumer(size=" + this.size + ", name=" + this.name + ", isDirectory=" + this.isDirectory + ", children=" + this.children + ", overflow=" + this.overflow + ", excluded=" + this.excluded + ')';
        }

        public int hashCode() {
            int result = Long.hashCode(this.size);
            result = result * 31 + this.name.hashCode();
            int n = this.isDirectory ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            result = result * 31 + n;
            result = result * 31 + ((Object)this.children).hashCode();
            int n2 = this.overflow ? 1 : 0;
            if (n2 != 0) {
                n2 = 1;
            }
            result = result * 31 + n2;
            int n3 = this.excluded ? 1 : 0;
            if (n3 != 0) {
                n3 = 1;
            }
            result = result * 31 + n3;
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof SpaceConsumer)) {
                return false;
            }
            SpaceConsumer spaceConsumer = (SpaceConsumer)other;
            if (this.size != spaceConsumer.size) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.name, (Object)spaceConsumer.name)) {
                return false;
            }
            if (this.isDirectory != spaceConsumer.isDirectory) {
                return false;
            }
            if (!Intrinsics.areEqual(this.children, spaceConsumer.children)) {
                return false;
            }
            if (this.overflow != spaceConsumer.overflow) {
                return false;
            }
            return this.excluded == spaceConsumer.excluded;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lru/ok/tracer/disk/usage/DiskUsageWorker$Companion;", "", "()V", "MAX_DEPTH", "", "MAX_ENTRIES", "tracer-disk-usage_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

