/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.disk.usage;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Build;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.ExistingPeriodicWorkPolicy;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.PeriodicWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import java.util.concurrent.TimeUnit;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.disk.usage.DiskUsageConfiguration;
import ru.ok.tracer.disk.usage.DiskUsageWorker;
import ru.ok.tracer.utils.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u00c7\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\u0006H\u0000\u00a2\u0006\u0002\b\nJ\u0006\u0010\u000b\u001a\u00020\bJ\u0010\u0010\u000b\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lru/ok/tracer/disk/usage/DiskUsage;", "", "()V", "WORKER_NAME", "", "context", "Landroid/content/Context;", "initialize", "", "applicationContext", "initialize$tracer_disk_usage_release", "runNow", "tracer-disk-usage_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class DiskUsage {
    @NotNull
    public static final DiskUsage INSTANCE = new DiskUsage();
    private static Context context;
    @NotNull
    private static final String WORKER_NAME = "tracer.disk.usage.worker";

    private DiskUsage() {
    }

    public final void initialize$tracer_disk_usage_release(@NotNull Context applicationContext) {
        Constraints.Builder builder;
        Intrinsics.checkNotNullParameter((Object)applicationContext, (String)"applicationContext");
        context = applicationContext;
        DiskUsageConfiguration config2 = DiskUsageConfiguration.Companion.get$tracer_disk_usage_release();
        if (!config2.getEnabled()) {
            Context context = DiskUsage.context;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                context = null;
            }
            WorkManager.getInstance((Context)context).cancelUniqueWork(WORKER_NAME);
            return;
        }
        Constraints.Builder $this$initialize_u24lambda_u240 = builder = new Constraints.Builder();
        boolean bl = false;
        if (!CoreTracerConfiguration.Companion.get().getDebugUpload()) {
            if (Build.VERSION.SDK_INT >= 23) {
                $this$initialize_u24lambda_u240.setRequiresDeviceIdle(true);
            }
            $this$initialize_u24lambda_u240.setRequiredNetworkType(NetworkType.UNMETERED);
            $this$initialize_u24lambda_u240.setRequiresBatteryNotLow(true);
        }
        Constraints constraints = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Builder()\n            .a\u2026   }\n            .build()");
        Constraints constraints2 = constraints;
        Data data = new Data.Builder().putLong("probability", config2.getProbability()).build();
        Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder()\n            .p\u2026ity)\n            .build()");
        Data workData = data;
        WorkRequest workRequest = ((PeriodicWorkRequest.Builder)((PeriodicWorkRequest.Builder)new PeriodicWorkRequest.Builder(DiskUsageWorker.class, 1L, TimeUnit.DAYS).setInputData(workData)).setConstraints(constraints2)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(DiskUsageWorker:\u2026nts)\n            .build()");
        PeriodicWorkRequest workRequest2 = (PeriodicWorkRequest)workRequest;
        Context context = DiskUsage.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        WorkManager.getInstance((Context)context).enqueueUniquePeriodicWork(WORKER_NAME, ExistingPeriodicWorkPolicy.KEEP, workRequest2);
    }

    public final void runNow() {
        if (Tracer.isDisabled()) {
            Logger.w$default((String)"Tracer is disabled", null, (int)2, null);
            return;
        }
        Context context = DiskUsage.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        WorkManager.getInstance((Context)context).enqueue((WorkRequest)OneTimeWorkRequest.from(DiskUsageWorker.class));
    }

    @Deprecated(message="Replace with runNow()", replaceWith=@ReplaceWith(expression="DiskUsage.runNow()", imports={}))
    public final void runNow(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        if (!Intrinsics.areEqual((Object)context.getApplicationContext(), (Object)context)) {
            boolean bl = false;
            String string = "Different context provided";
            throw new IllegalArgumentException(string.toString());
        }
        this.runNow();
    }
}

