/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.heap.dumps;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Debug;
import androidx.annotation.WorkerThread;
import androidx.work.Data;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import java.io.File;
import java.util.concurrent.atomic.AtomicBoolean;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.heap.dumps.FEATURE_HEAP_DUMPKt;
import ru.ok.tracer.heap.dumps.HeapDumpConfiguration;
import ru.ok.tracer.heap.dumps.OutOfMemoryErrors;
import ru.ok.tracer.heap.dumps.exceptions.ShrinkDumpWorker;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;
import ru.ok.tracer.utils.TracerThreads;
import ru.ok.tracer.utils.UncaughtExceptionHandlers;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0001\u0016B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0015\u0010\u0010\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bH\u0001\u00a2\u0006\u0002\b\u0011J\u0012\u0010\u0012\u001a\u00020\r2\b\u0010\u0013\u001a\u0004\u0018\u00010\u0004H\u0002J\u000e\u0010\u0014\u001a\u00020\r2\u0006\u0010\u0013\u001a\u00020\u0004J\b\u0010\u0015\u001a\u00020\rH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lru/ok/tracer/heap/dumps/HeapDumps;", "", "()V", "DUMP_FILE_NAME", "", "DUMP_TMP_FILE_NAME", "META_FILE_NAME", "META_TMP_FILE_NAME", "canDump", "Ljava/util/concurrent/atomic/AtomicBoolean;", "context", "Landroid/content/Context;", "cleanupFile", "", "file", "Ljava/io/File;", "install", "install$tracer_heap_dumps_release", "runInternal", "tag", "runNow", "shrinkAndUpload", "DumpMeta", "tracer-heap-dumps_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class HeapDumps {
    @NotNull
    public static final HeapDumps INSTANCE = new HeapDumps();
    @NotNull
    private static final String DUMP_TMP_FILE_NAME = "dump-tmp.hprof";
    @NotNull
    private static final String META_TMP_FILE_NAME = "dump-tmp-meta.json";
    @NotNull
    private static final String DUMP_FILE_NAME = "dump.hprof";
    @NotNull
    private static final String META_FILE_NAME = "dump-meta.json";
    @NotNull
    private static final AtomicBoolean canDump = new AtomicBoolean(true);
    @Nullable
    private static Context context;

    private HeapDumps() {
    }

    @WorkerThread
    public final void install$tracer_heap_dumps_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        HeapDumps.context = context;
        File tracerDir = TracerFiles.INSTANCE.getTracerDir(context);
        HeapDumpConfiguration config = HeapDumpConfiguration.Companion.get$tracer_heap_dumps_release();
        this.cleanupFile(FilesKt.resolve((File)tracerDir, (String)DUMP_TMP_FILE_NAME));
        this.cleanupFile(FilesKt.resolve((File)tracerDir, (String)META_TMP_FILE_NAME));
        if (!config.getEnabled$tracer_heap_dumps_release()) {
            Logger.v$default((String)"HeapDumps disabled", null, (int)2, null);
            this.cleanupFile(FilesKt.resolve((File)tracerDir, (String)DUMP_FILE_NAME));
            this.cleanupFile(FilesKt.resolve((File)tracerDir, (String)META_FILE_NAME));
            canDump.set(false);
            return;
        }
        UncaughtExceptionHandlers.prependDefault(HeapDumps::install$lambda$0);
        this.shrinkAndUpload();
    }

    public final void runNow(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!(!StringsKt.isBlank((CharSequence)tag))) {
            boolean bl = false;
            String string = "Blank tag";
            throw new IllegalArgumentException(string.toString());
        }
        this.runInternal(tag);
    }

    private final void runInternal(String tag) {
        if (Tracer.isDisabled()) {
            Logger.w$default((String)"Tracer is disabled", null, (int)2, null);
            return;
        }
        Context context = HeapDumps.context;
        if (context == null) {
            Logger.e$default((String)"HeapDumps not initialized", null, (int)2, null);
            return;
        }
        boolean canDump = HeapDumps.canDump.getAndSet(false);
        if (!canDump) {
            Logger.d$default((String)"Cannot run hprof", null, (int)2, null);
            return;
        }
        String myBuildUuid = Tracer.INSTANCE.getApplicationInfo().getBuildUuid();
        File tracerDir = TracerFiles.INSTANCE.getTracerDir(context);
        File dumpFileTmp = FilesKt.resolve((File)tracerDir, (String)DUMP_TMP_FILE_NAME);
        File metaFileTmp = FilesKt.resolve((File)tracerDir, (String)META_TMP_FILE_NAME);
        try {
            FileUtils.mkdirsChecked((File)tracerDir);
            Debug.dumpHprofData((String)dumpFileTmp.getAbsolutePath());
            String metaText = new DumpMeta(myBuildUuid, tag).serialize();
            FilesKt.writeText$default((File)metaFileTmp, (String)metaText, null, (int)2, null);
        }
        catch (Exception ex) {
            Logger.e((String)"Failed to take tmp dump", (Throwable)ex);
            this.cleanupFile(dumpFileTmp);
            this.cleanupFile(metaFileTmp);
        }
        File dumpFile = FilesKt.resolve((File)tracerDir, (String)DUMP_FILE_NAME);
        File metaFile = FilesKt.resolve((File)tracerDir, (String)META_FILE_NAME);
        try {
            if (dumpFile.exists()) {
                FileUtils.deleteChecked((File)dumpFile);
            }
            if (metaFile.exists()) {
                FileUtils.deleteChecked((File)metaFile);
            }
            FileUtils.renameToChecked((File)dumpFileTmp, (File)dumpFile);
            FileUtils.renameToChecked((File)metaFileTmp, (File)metaFile);
        }
        catch (Exception ex) {
            Logger.e((String)"Failed to take dump", (Throwable)ex);
            this.cleanupFile(dumpFile);
            this.cleanupFile(metaFile);
        }
    }

    private final void shrinkAndUpload() {
        Context context = HeapDumps.context;
        if (context == null) {
            Logger.e$default((String)"HeapDumps not initialized", null, (int)2, null);
            return;
        }
        File tracerDir = TracerFiles.INSTANCE.getTracerDir(context);
        File dumpFile = FilesKt.resolve((File)tracerDir, (String)DUMP_FILE_NAME);
        File metaFile = FilesKt.resolve((File)tracerDir, (String)META_FILE_NAME);
        if (!dumpFile.exists() && !metaFile.exists()) {
            return;
        }
        try {
            String it = FilesKt.readText$default((File)metaFile, null, (int)1, null);
            boolean bl = false;
            DumpMeta meta = DumpMeta.Companion.parse(it);
            FileUtils.deleteChecked((File)metaFile);
            String dumpBuildUuid = meta.getBuildUuid();
            String myBuildUuid = Tracer.INSTANCE.getApplicationInfo().getBuildUuid();
            if (!Intrinsics.areEqual((Object)dumpBuildUuid, (Object)myBuildUuid)) {
                boolean $i$a$-check-HeapDumps$shrinkAndUpload$22 = false;
                String $i$a$-check-HeapDumps$shrinkAndUpload$22 = "Dump from different buildUuid. Current " + myBuildUuid + " != " + dumpBuildUuid;
                throw new IllegalStateException($i$a$-check-HeapDumps$shrinkAndUpload$22.toString());
            }
            String tag = meta.getTag();
            File dumpFileToUpload = TracerFiles.getNewSampleFile$default((TracerFiles)TracerFiles.INSTANCE, (Context)context, (TracerFeature)FEATURE_HEAP_DUMPKt.getFEATURE_HEAP_DUMP(), null, (int)4, null);
            FileUtils.renameToChecked((File)dumpFile, (File)dumpFileToUpload);
            Logger.d$default((String)"Schedule hprof upload", null, (int)2, null);
            Data inputData = ShrinkDumpWorker.Companion.createInputData$tracer_heap_dumps_release(dumpFileToUpload, tag);
            WorkRequest workRequest = ((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(ShrinkDumpWorker.class).setInputData(inputData)).build();
            Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(ShrinkDumpWorker\u2026\n                .build()");
            OneTimeWorkRequest workRequest2 = (OneTimeWorkRequest)workRequest;
            TracerThreads.INSTANCE.runInBgAfterStartup(() -> HeapDumps.shrinkAndUpload$lambda$4(context, workRequest2));
        }
        catch (Exception ex) {
            Logger.e((String)"Failed to schedule upload", (Throwable)ex);
            this.cleanupFile(dumpFile);
            this.cleanupFile(metaFile);
        }
    }

    private final void cleanupFile(File file) {
        if (file.exists()) {
            Logger.d$default((String)("Removing file " + file), null, (int)2, null);
            file.delete();
        }
    }

    private static final void install$lambda$0(Thread thread, Throwable throwable) {
        Intrinsics.checkNotNullExpressionValue((Object)throwable, (String)"throwable");
        if (OutOfMemoryErrors.isOom(throwable)) {
            INSTANCE.runInternal(null);
        }
    }

    private static final void shrinkAndUpload$lambda$4(Context $context, OneTimeWorkRequest $workRequest) {
        Intrinsics.checkNotNullParameter((Object)$workRequest, (String)"$workRequest");
        WorkManager.getInstance((Context)$context).enqueue((WorkRequest)$workRequest);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0082\b\u0018\u0000 \u00132\u00020\u0001:\u0001\u0013B\u0019\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0005J\u000b\u0010\t\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\n\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J!\u0010\u000b\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u000f\u001a\u00020\u0010H\u00d6\u0001J\u0006\u0010\u0011\u001a\u00020\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0014"}, d2={"Lru/ok/tracer/heap/dumps/HeapDumps$DumpMeta;", "", "buildUuid", "", "tag", "(Ljava/lang/String;Ljava/lang/String;)V", "getBuildUuid", "()Ljava/lang/String;", "getTag", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "serialize", "toString", "Companion", "tracer-heap-dumps_release"})
    private static final class DumpMeta {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @Nullable
        private final String buildUuid;
        @Nullable
        private final String tag;

        public DumpMeta(@Nullable String buildUuid, @Nullable String tag) {
            this.buildUuid = buildUuid;
            this.tag = tag;
        }

        @Nullable
        public final String getBuildUuid() {
            return this.buildUuid;
        }

        @Nullable
        public final String getTag() {
            return this.tag;
        }

        @NotNull
        public final String serialize() {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("buildUuid", (Object)this.buildUuid);
            jsonObject.put("tag", (Object)this.tag);
            String string = jsonObject.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jsonObject.toString()");
            return string;
        }

        @Nullable
        public final String component1() {
            return this.buildUuid;
        }

        @Nullable
        public final String component2() {
            return this.tag;
        }

        @NotNull
        public final DumpMeta copy(@Nullable String buildUuid, @Nullable String tag) {
            return new DumpMeta(buildUuid, tag);
        }

        public static /* synthetic */ DumpMeta copy$default(DumpMeta dumpMeta, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = dumpMeta.buildUuid;
            }
            if ((n & 2) != 0) {
                string2 = dumpMeta.tag;
            }
            return dumpMeta.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "DumpMeta(buildUuid=" + this.buildUuid + ", tag=" + this.tag + ')';
        }

        public int hashCode() {
            int result = this.buildUuid == null ? 0 : this.buildUuid.hashCode();
            result = result * 31 + (this.tag == null ? 0 : this.tag.hashCode());
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof DumpMeta)) {
                return false;
            }
            DumpMeta dumpMeta = (DumpMeta)other;
            if (!Intrinsics.areEqual((Object)this.buildUuid, (Object)dumpMeta.buildUuid)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.tag, (Object)dumpMeta.tag);
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lru/ok/tracer/heap/dumps/HeapDumps$DumpMeta$Companion;", "", "()V", "parse", "Lru/ok/tracer/heap/dumps/HeapDumps$DumpMeta;", "string", "", "tracer-heap-dumps_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final DumpMeta parse(@NotNull String string) {
                Intrinsics.checkNotNullParameter((Object)string, (String)"string");
                try {
                    String string2;
                    JSONObject jsonObject = new JSONObject(string);
                    String it = string2 = jsonObject.optString("buildUuid");
                    boolean bl = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    String string3 = !StringsKt.isBlank((CharSequence)it) ? string2 : null;
                    it = string2 = jsonObject.optString("tag");
                    String string4 = string3;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    boolean bl3 = !StringsKt.isBlank((CharSequence)it);
                    String string5 = bl3 ? string2 : null;
                    String string6 = string4;
                    return new DumpMeta(string6, string5);
                }
                catch (Exception ex) {
                    throw new IllegalArgumentException(ex);
                }
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

