/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.heap.dumps.exceptions;

import android.os.Debug;
import java.io.File;
import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.heap.dumps.OutOfMemoryErrors;
import ru.ok.tracer.utils.Logger;

@Deprecated(message="Will be removed")
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0003\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lru/ok/tracer/heap/dumps/exceptions/HeapDumpExceptionHandler;", "Ljava/lang/Thread$UncaughtExceptionHandler;", "file", "Ljava/io/File;", "tmpFile", "(Ljava/io/File;Ljava/io/File;)V", "uncaughtException", "", "t", "Ljava/lang/Thread;", "e", "", "tracer-heap-dumps_release"})
public final class HeapDumpExceptionHandler
implements Thread.UncaughtExceptionHandler {
    @NotNull
    private final File file;
    @NotNull
    private final File tmpFile;

    public HeapDumpExceptionHandler(@NotNull File file, @NotNull File tmpFile) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)tmpFile, (String)"tmpFile");
        this.file = file;
        this.tmpFile = tmpFile;
    }

    @Override
    public void uncaughtException(@NotNull Thread t, @NotNull Throwable e) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        if (OutOfMemoryErrors.isOom(e)) {
            try {
                File file = this.tmpFile.getParentFile();
                if (file != null) {
                    FileUtils.mkdirsChecked((File)file);
                }
                Debug.dumpHprofData((String)this.tmpFile.getAbsolutePath());
                File file2 = this.file.getParentFile();
                if (file2 != null) {
                    FileUtils.mkdirsChecked((File)file2);
                }
                this.tmpFile.renameTo(this.file);
            }
            catch (IOException ex) {
                Logger.e((Throwable)ex);
            }
        }
    }
}

