/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.heap.dumps.exceptions;

import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import ru.ok.tracer.utils.Logger;

@Deprecated
public class HprofFastInputStream
extends InputStream {
    private static final int T_BOOLEAN = 4;
    private static final int T_CHAR = 5;
    private static final int T_FLOAT = 6;
    private static final int T_DOUBLE = 7;
    private static final int T_BYTE = 8;
    private static final int T_SHORT = 9;
    private static final int T_INT = 10;
    private static final int T_LONG = 11;
    private static final int HPROF_HEAP_DUMP = 12;
    private static final int HPROF_HEAP_DUMP_SEGMENT = 28;
    private static final int HPROF_GC_ROOT_UNKNOWN = 255;
    private static final int HPROF_GC_ROOT_JNI_GLOBAL = 1;
    private static final int HPROF_GC_ROOT_JNI_LOCAL = 2;
    private static final int HPROF_GC_ROOT_JAVA_FRAME = 3;
    private static final int HPROF_GC_ROOT_NATIVE_STACK = 4;
    private static final int HPROF_GC_ROOT_STICKY_CLASS = 5;
    private static final int HPROF_GC_ROOT_THREAD_BLOCK = 6;
    private static final int HPROF_GC_ROOT_MONITOR_USED = 7;
    private static final int HPROF_GC_ROOT_THREAD_OBJ = 8;
    private static final int HPROF_GC_CLASS_DUMP = 32;
    private static final int HPROF_GC_INSTANCE_DUMP = 33;
    private static final int HPROF_GC_OBJ_ARRAY_DUMP = 34;
    private static final int HPROF_GC_PRIMITIVE_ARRAY_DUMP = 35;
    private static final int HPROF_HEAP_DUMP_INFO = 254;
    private static final int HPROF_ROOT_INTERNED_STRING = 137;
    private static final int HPROF_ROOT_FINALIZING = 138;
    private static final int HPROF_ROOT_DEBUGGER = 139;
    private static final int HPROF_ROOT_REFERENCE_CLEANUP = 140;
    private static final int HPROF_ROOT_VM_INTERNAL = 141;
    private static final int HPROF_ROOT_JNI_MONITOR = 142;
    private static final int HPROF_UNREACHABLE = 144;
    private static final int HPROF_PRIMITIVE_ARRAY_NODATA_DUMP = 195;
    private static final int BUFFER_SIZE = 65536;
    private static final byte FIXED_BYTE = -2;
    private int primitiveArraysSize = 0;
    private int objectArraysSize = 0;
    private int instancesSize = 0;
    private int classesSize = 0;
    private int nonHeapData = 0;
    private final DataInputStream in;
    private final Mode mode;
    private boolean fileCompressed;
    private int pos = 0;
    private int nextTokenPosition = 4;
    private int heapParsingLength = 0;
    private int fixedByteLength = 0;
    private byte[] buffer = new byte[65536];
    private int bufferReadPointer = 0;
    private int bufferWritePointer = 0;
    private int identifierSize;

    public HprofFastInputStream(DataInputStream in, Mode mode) {
        this.in = in;
        this.mode = mode;
    }

    public static HprofFastInputStream deflate(InputStream in) {
        DataInputStream wrapped = new DataInputStream(new BufferedInputStream(in));
        return new HprofFastInputStream(wrapped, Mode.DEFLATE);
    }

    @Override
    public int read() throws IOException {
        if (this.pos == 0) {
            this.readHeader();
            return this.readOneByteFromBuffer();
        }
        if (this.bufferWritePointer > this.bufferReadPointer) {
            return this.readOneByteFromBuffer();
        }
        if (this.fixedByteLength > 0) {
            --this.fixedByteLength;
            return -2;
        }
        if (this.nextTokenPosition > this.pos) {
            return this.readDirectly();
        }
        if (this.prepareNextTokenBuffer()) {
            return this.readOneByteFromBuffer();
        }
        return -1;
    }

    @Override
    public int read(byte[] bytes, int offset, int limit) throws IOException {
        if (this.pos == 0) {
            this.readHeader();
            return this.readFromBuffer(bytes, offset, limit);
        }
        if (this.bufferWritePointer > this.bufferReadPointer) {
            return this.readFromBuffer(bytes, offset, limit);
        }
        if (this.fixedByteLength > 0) {
            limit = Math.min(limit, this.fixedByteLength);
            Arrays.fill(bytes, offset, offset + limit, (byte)-2);
            this.fixedByteLength -= limit;
            return limit;
        }
        if (this.nextTokenPosition > this.pos) {
            limit = Math.min(limit, this.nextTokenPosition - this.pos);
            return this.readDirectly(bytes, offset, limit);
        }
        if (this.prepareNextTokenBuffer()) {
            return this.readFromBuffer(bytes, offset, limit);
        }
        return -1;
    }

    private boolean prepareNextTokenBuffer() throws IOException {
        this.bufferReadPointer = 0;
        this.bufferWritePointer = 0;
        if (this.heapParsingLength != 0) {
            this.parseHeap();
            return true;
        }
        return this.parseNextToken();
    }

    private int readOneByteFromBuffer() {
        return this.buffer[this.bufferReadPointer++];
    }

    private int readDirectly() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            ++this.pos;
        }
        return b;
    }

    private boolean parseNextToken() throws IOException {
        int type = this.in.read();
        if (type == -1) {
            return false;
        }
        this.maybeExpandBuffer(1);
        this.buffer[this.bufferWritePointer++] = (byte)type;
        ++this.pos;
        this.readIntAndBuffer();
        int length = this.readIntAndBuffer();
        if (type == 12 || type == 28) {
            this.nextTokenPosition = this.pos;
            this.heapParsingLength = length;
        } else {
            this.nextTokenPosition = this.pos + length;
            this.nonHeapData += length;
        }
        return true;
    }

    private void parseHeap() throws IOException {
        if (this.heapParsingLength < 0) {
            throw new IllegalArgumentException("Heap parsing reached " + this.heapParsingLength + " heap length");
        }
        int type = this.heapReadByte();
        int extraSpaceForNextToken = 0;
        switch (type) {
            case 5: 
            case 7: 
            case 137: 
            case 138: 
            case 139: 
            case 140: 
            case 141: 
            case 144: 
            case 255: {
                this.skipHeap(this.identifierSize);
                break;
            }
            case 4: 
            case 6: 
            case 254: {
                this.skipHeap(this.identifierSize + 4);
                break;
            }
            case 2: 
            case 3: 
            case 8: 
            case 142: {
                this.skipHeap(this.identifierSize + 8);
                break;
            }
            case 1: {
                this.skipHeap(this.identifierSize * 2);
                break;
            }
            case 32: {
                this.classesSize -= this.bufferWritePointer;
                this.skipHeap(this.identifierSize * 7 + 8);
                int numConstPoolEntries = this.heapReadShort();
                for (int i = 0; i < numConstPoolEntries; ++i) {
                    this.skipHeap(2);
                    this.skipValue();
                }
                int numStatics = this.heapReadShort();
                for (int i = 0; i < numStatics; ++i) {
                    this.skipHeap(this.identifierSize);
                    this.skipValue();
                }
                int numFields = this.heapReadShort();
                this.skipHeap(numFields * (this.identifierSize + 1));
                this.classesSize += this.bufferWritePointer;
                break;
            }
            case 33: {
                this.instancesSize -= this.bufferWritePointer;
                this.skipHeap(this.identifierSize * 2 + 4);
                int size = this.heapReadInt();
                this.skipHeap(size);
                this.instancesSize += this.bufferWritePointer;
                break;
            }
            case 195: {
                this.skipHeap(this.identifierSize + 9);
                break;
            }
            case 34: 
            case 35: {
                boolean isObject;
                this.heapReadId();
                this.heapReadInt();
                int elementCount = this.heapReadInt();
                long classId = type == 35 ? (long)this.heapReadByte() : this.heapReadId();
                int elementSize = 0;
                switch ((int)classId) {
                    case 4: 
                    case 8: {
                        elementSize = 1;
                        break;
                    }
                    case 5: 
                    case 9: {
                        elementSize = 2;
                        break;
                    }
                    case 6: 
                    case 10: {
                        elementSize = 4;
                        break;
                    }
                    case 7: 
                    case 11: {
                        elementSize = 8;
                    }
                }
                boolean bl = isObject = elementSize == 0;
                if (isObject) {
                    elementSize = this.identifierSize;
                }
                int arraySize = elementSize * elementCount;
                if (isObject) {
                    extraSpaceForNextToken = arraySize;
                    this.objectArraysSize += arraySize;
                } else {
                    if (this.mode == Mode.DEFLATE) {
                        if (!this.fileCompressed) {
                            this.discardFromInput(arraySize);
                        }
                    } else if (this.fileCompressed) {
                        this.fixedByteLength = arraySize;
                    } else {
                        extraSpaceForNextToken = arraySize;
                    }
                    this.primitiveArraysSize += arraySize;
                }
                this.heapParsingLength -= arraySize;
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + type + " is not supported! " + this.pos);
            }
        }
        this.nextTokenPosition = this.pos + extraSpaceForNextToken;
    }

    private long heapReadId() throws IOException {
        long id = this.heapReadInt();
        if (this.identifierSize == 8) {
            id = id << 32 | (long)this.heapReadInt();
        }
        return id;
    }

    private int readDirectly(byte[] bytes, int offset, int limit) throws IOException {
        int r = this.in.read(bytes, offset, limit);
        if (r != -1) {
            this.pos += r;
        }
        return r;
    }

    private void readHeader() throws IOException {
        byte b;
        byte firstByte = this.in.readByte();
        this.fileCompressed = firstByte == 67;
        this.buffer[this.bufferWritePointer++] = this.mode == Mode.DEFLATE ? 67 : 74;
        do {
            b = this.in.readByte();
            this.buffer[this.bufferWritePointer++] = b;
        } while (b != 0);
        this.identifierSize = this.readIntAndBuffer();
        this.in.readFully(this.buffer, this.bufferWritePointer, 8);
        this.bufferWritePointer += 8;
        this.nextTokenPosition = this.pos = this.bufferWritePointer;
    }

    private void skipHeap(int size) throws IOException {
        this.maybeExpandBuffer(size);
        this.in.readFully(this.buffer, this.bufferWritePointer, size);
        this.bufferWritePointer += size;
        this.pos += size;
        this.heapParsingLength -= size;
    }

    private void maybeExpandBuffer(int size) {
        if (this.bufferWritePointer + size > this.buffer.length) {
            int newBufferLength = (int)((double)this.buffer.length * 1.5);
            Logger.d((String)"Expanded buffer to: %s", (Object[])new Object[]{newBufferLength});
            byte[] newBuffer = new byte[newBufferLength];
            System.arraycopy(this.buffer, 0, newBuffer, 0, this.buffer.length);
            this.buffer = newBuffer;
        }
    }

    private int heapReadByte() throws IOException {
        int b = this.in.read();
        this.maybeExpandBuffer(1);
        this.buffer[this.bufferWritePointer++] = (byte)b;
        --this.heapParsingLength;
        ++this.pos;
        return b;
    }

    private int heapReadShort() throws IOException {
        int ch1 = this.in.read();
        int ch2 = this.in.read();
        this.maybeExpandBuffer(2);
        this.buffer[this.bufferWritePointer++] = (byte)ch1;
        this.buffer[this.bufferWritePointer++] = (byte)ch2;
        this.heapParsingLength -= 2;
        this.pos += 2;
        return ch1 << 8 | ch2;
    }

    private int heapReadInt() throws IOException {
        this.heapParsingLength -= 4;
        return this.readIntAndBuffer();
    }

    private int readFromBuffer(byte[] bytes, int offset, int limit) {
        limit = Math.min(limit, this.bufferWritePointer - this.bufferReadPointer);
        System.arraycopy(this.buffer, this.bufferReadPointer, bytes, offset, limit);
        this.bufferReadPointer += limit;
        return limit;
    }

    private void skipValue() throws IOException {
        int type = this.heapReadByte();
        this.skipHeap(this.sizeForTypeSignature(type));
    }

    private int sizeForTypeSignature(int type) {
        switch (type) {
            case 2: 
            case 76: 
            case 91: {
                return this.identifierSize;
            }
            case 4: 
            case 8: 
            case 66: 
            case 90: {
                return 1;
            }
            case 5: 
            case 9: 
            case 67: 
            case 83: {
                return 2;
            }
            case 6: 
            case 10: 
            case 70: 
            case 73: {
                return 4;
            }
            case 7: 
            case 11: 
            case 68: 
            case 74: {
                return 8;
            }
        }
        throw new IllegalArgumentException("Signature type " + type + " is not supported");
    }

    private int readIntAndBuffer() throws IOException {
        this.maybeExpandBuffer(4);
        this.in.readFully(this.buffer, this.bufferWritePointer, 4);
        int ch1 = this.buffer[this.bufferWritePointer++] & 0xFF;
        int ch2 = this.buffer[this.bufferWritePointer++] & 0xFF;
        int ch3 = this.buffer[this.bufferWritePointer++] & 0xFF;
        int ch4 = this.buffer[this.bufferWritePointer++] & 0xFF;
        this.pos += 4;
        return ch1 << 24 | ch2 << 16 | ch3 << 8 | ch4;
    }

    private void discardFromInput(int bytes) throws IOException {
        while (bytes > 0) {
            int r = this.in.skipBytes(bytes);
            if (r == -1) {
                throw new EOFException();
            }
            this.pos += r;
            bytes -= r;
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public static enum Mode {
        INFLATE,
        DEFLATE;

    }
}

