/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.heap.dumps.exceptions;

import android.content.Context;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.heap.dumps.FEATURE_HEAP_DUMPKt;
import ru.ok.tracer.heap.dumps.exceptions.HprofFastInputStream;
import ru.ok.tracer.upload.SampleUploader;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;
import ru.ok.tracer.utils.config.ConfigStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\n"}, d2={"Lru/ok/tracer/heap/dumps/exceptions/ShrinkDumpWorker;", "Landroidx/work/Worker;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "doWork", "Landroidx/work/ListenableWorker$Result;", "Companion", "tracer-heap-dumps_release"})
public final class ShrinkDumpWorker
extends Worker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private static final int MINIMUM_DUMP_SIZE = 0x100000;
    @NotNull
    public static final String PARAM_DUMP_PATH = "param_dump_path";
    @NotNull
    private static final String PARAM_TAG = "param_tag";

    public ShrinkDumpWorker(@NotNull Context context, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(context, workerParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public ListenableWorker.Result doWork() {
        Object object;
        String dumpPath = this.getInputData().getString(PARAM_DUMP_PATH);
        CharSequence charSequence = dumpPath;
        if (charSequence == null || charSequence.length() == 0) {
            ListenableWorker.Result result = ListenableWorker.Result.failure();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"failure()");
            return result;
        }
        String tag = this.getInputData().getString(PARAM_TAG);
        File dumpFile = new File(dumpPath);
        long dumpSize = dumpFile.length();
        if (dumpSize < 0x100000L) {
            Logger.d$default((String)("Dump has not interesting size " + dumpSize + " < 1048576"), null, (int)2, null);
            dumpFile.delete();
            ListenableWorker.Result result = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
            return result;
        }
        if (ConfigStorage.isLimited$default((ConfigStorage)ConfigStorage.INSTANCE, (TracerFeature)FEATURE_HEAP_DUMPKt.getFEATURE_HEAP_DUMP(), null, (int)2, null)) {
            Logger.d$default((String)"Not able to run dump shrinking", null, (int)2, null);
            dumpFile.delete();
            ListenableWorker.Result result = ListenableWorker.Result.success();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
            return result;
        }
        try {
            Context context = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
            object = TracerFiles.getNewSampleFile$default((TracerFiles)TracerFiles.INSTANCE, (Context)context, (TracerFeature)FEATURE_HEAP_DUMPKt.getFEATURE_HEAP_DUMP(), null, (int)4, null);
        }
        catch (IOException e) {
            Logger.e((String)"Failed to get sample file.", (Throwable)e);
            ListenableWorker.Result result = ListenableWorker.Result.failure();
            Intrinsics.checkNotNullExpressionValue((Object)result, (String)"failure()");
            return result;
        }
        File shrinkedDumpFile = object;
        try {
            object = HprofFastInputStream.deflate(new BufferedInputStream(new FileInputStream(dumpFile)));
            Throwable throwable = null;
            try {
                long l;
                HprofFastInputStream inS = (HprofFastInputStream)object;
                boolean bl = false;
                Closeable closeable = new BufferedOutputStream(new FileOutputStream(shrinkedDumpFile));
                Throwable throwable2 = null;
                try {
                    BufferedOutputStream outS = (BufferedOutputStream)closeable;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)inS, (String)"inS");
                    l = ByteStreamsKt.copyTo$default((InputStream)inS, (OutputStream)outS, (int)0, (int)2, null);
                }
                catch (Throwable throwable3) {
                    throwable2 = throwable3;
                    throw throwable3;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable2);
                }
                long l2 = l;
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
            finally {
                CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
            }
        }
        finally {
            dumpFile.delete();
        }
        Context context = this.getApplicationContext();
        Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
        SampleUploader.upload$default((SampleUploader)SampleUploader.INSTANCE, (Context)context, (TracerFeature)FEATURE_HEAP_DUMPKt.getFEATURE_HEAP_DUMP(), (File)shrinkedDumpFile, (boolean)false, (String)tag, (Long)dumpSize, null, null, (int)200, null);
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
        return result;
    }

    @Deprecated(message="Will be internal")
    @JvmStatic
    @NotNull
    public static final Data createInputData(@NotNull File dumpFile) {
        return Companion.createInputData(dumpFile);
    }

    @Deprecated(message="Will be internal")
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0087\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001f\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u0006H\u0000\u00a2\u0006\u0002\b\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0005\u001a\u00020\u00068\u0006X\u0087T\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0007\u0010\u0002R\u000e\u0010\b\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lru/ok/tracer/heap/dumps/exceptions/ShrinkDumpWorker$Companion;", "", "()V", "MINIMUM_DUMP_SIZE", "", "PARAM_DUMP_PATH", "", "getPARAM_DUMP_PATH$annotations", "PARAM_TAG", "createInputData", "Landroidx/work/Data;", "dumpFile", "Ljava/io/File;", "tag", "createInputData$tracer_heap_dumps_release", "tracer-heap-dumps_release"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Will be internal")
        public static /* synthetic */ void getPARAM_DUMP_PATH$annotations() {
        }

        @Deprecated(message="Will be internal")
        @JvmStatic
        @NotNull
        public final Data createInputData(@NotNull File dumpFile) {
            Intrinsics.checkNotNullParameter((Object)dumpFile, (String)"dumpFile");
            return this.createInputData$tracer_heap_dumps_release(dumpFile, null);
        }

        @NotNull
        public final Data createInputData$tracer_heap_dumps_release(@NotNull File dumpFile, @Nullable String tag) {
            Intrinsics.checkNotNullParameter((Object)dumpFile, (String)"dumpFile");
            Data data = new Data.Builder().putString(ShrinkDumpWorker.PARAM_DUMP_PATH, dumpFile.getPath()).putString(ShrinkDumpWorker.PARAM_TAG, tag).build();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"Builder()\n              \u2026\n                .build()");
            return data;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

