/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.lite.upload;

import android.app.ActivityManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import android.provider.Settings;
import android.text.TextUtils;
import java.io.File;
import java.util.Date;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmName;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.ok.tracer.base.builduuid.BuildUuidUtils;
import ru.ok.tracer.base.compat.PackageInfoCompat;
import ru.ok.tracer.base.compat.PackageManagerCompat;
import ru.ok.tracer.base.datetime.DateTimeUtils;
import ru.ok.tracer.base.deviceid.DeviceIdUtils;
import ru.ok.tracer.base.sessionuuuid.SessionUuidUtils;
import ru.ok.tracer.lite.TracerLibraryInfo;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u00006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a@\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t2\u0010\b\u0002\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000b\u001a\u0014\u0010\f\u001a\u0004\u0018\u00010\u00012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005H\u0002\u001a\u001c\u0010\r\u001a\u00020\u00012\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\u0010\b\u001a\u0004\u0018\u00010\tH\u0002\u001a\u001a\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u000e\u0010\n\u001a\n\u0012\u0004\u0012\u00020\t\u0018\u00010\u000bH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\b\u0010\u0012\u001a\u00020\u0011H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u00a8\u0006\u0014"}, d2={"composeLibUploadBean", "Lorg/json/JSONObject;", "context", "Landroid/content/Context;", "libraryInfo", "Lru/ok/tracer/lite/TracerLibraryInfo;", "date", "Ljava/util/Date;", "issueKey", "", "tags", "", "composeLibraryInfoJsonObject", "composeProperties", "composeTags", "Lorg/json/JSONArray;", "isEmulator", "", "isInForeground", "isRooted", "tracer-lite-commons_release"})
@JvmName(name="UploadBeanUtilsLite")
public final class UploadBeanUtilsLite {
    @NotNull
    public static final JSONObject composeLibUploadBean(@NotNull Context context, @NotNull TracerLibraryInfo libraryInfo2, @Nullable Date date, @Nullable String issueKey, @Nullable List<String> tags) {
        JSONObject jSONObject;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)libraryInfo2, (String)"libraryInfo");
        PackageManager packageManager = context.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"context.packageManager");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        PackageInfo packageInfo = PackageManagerCompat.getPackageInfoCompat((PackageManager)packageManager, (String)string, (int)0);
        String buildUuid = BuildUuidUtils.getHostBuildUuid((Context)context);
        JSONObject $this$composeLibUploadBean_u24lambda_u240 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$composeLibUploadBean_u24lambda_u240.put("packageName", (Object)packageInfo.packageName);
        $this$composeLibUploadBean_u24lambda_u240.put("versionName", (Object)packageInfo.versionName);
        $this$composeLibUploadBean_u24lambda_u240.put("versionCode", PackageInfoCompat.getLongVersionCodeCompat((PackageInfo)packageInfo));
        $this$composeLibUploadBean_u24lambda_u240.put("buildUuid", (Object)buildUuid);
        $this$composeLibUploadBean_u24lambda_u240.put("sessionUuid", (Object)SessionUuidUtils.getCurrentSessionUuid());
        $this$composeLibUploadBean_u24lambda_u240.put("device", (Object)Build.MODEL);
        $this$composeLibUploadBean_u24lambda_u240.put("deviceId", (Object)DeviceIdUtils.getDeviceId((Context)context));
        $this$composeLibUploadBean_u24lambda_u240.put("vendor", (Object)Build.MANUFACTURER);
        $this$composeLibUploadBean_u24lambda_u240.put("osVersion", (Object)String.valueOf(Build.VERSION.SDK_INT));
        $this$composeLibUploadBean_u24lambda_u240.put("inBackground", !UploadBeanUtilsLite.isInForeground());
        $this$composeLibUploadBean_u24lambda_u240.put("isRooted", UploadBeanUtilsLite.isRooted(context));
        $this$composeLibUploadBean_u24lambda_u240.put("properties", (Object)UploadBeanUtilsLite.composeProperties(date, issueKey));
        $this$composeLibUploadBean_u24lambda_u240.put("tags", (Object)UploadBeanUtilsLite.composeTags(tags));
        $this$composeLibUploadBean_u24lambda_u240.put("libraryInfo", (Object)UploadBeanUtilsLite.composeLibraryInfoJsonObject(libraryInfo2));
        return jSONObject;
    }

    public static /* synthetic */ JSONObject composeLibUploadBean$default(Context context, TracerLibraryInfo tracerLibraryInfo, Date date, String string, List list, int n, Object object) {
        if ((n & 4) != 0) {
            date = null;
        }
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            list = null;
        }
        return UploadBeanUtilsLite.composeLibUploadBean(context, tracerLibraryInfo, date, string, list);
    }

    private static final JSONObject composeLibraryInfoJsonObject(TracerLibraryInfo libraryInfo2) {
        JSONObject jSONObject;
        if (libraryInfo2 == null) {
            jSONObject = null;
        } else {
            JSONObject jSONObject2;
            JSONObject $this$composeLibraryInfoJsonObject_u24lambda_u241 = jSONObject2 = new JSONObject();
            boolean bl = false;
            $this$composeLibraryInfoJsonObject_u24lambda_u241.put("packageName", (Object)libraryInfo2.getPackageName());
            $this$composeLibraryInfoJsonObject_u24lambda_u241.put("versionName", (Object)libraryInfo2.getVersionName());
            $this$composeLibraryInfoJsonObject_u24lambda_u241.put("buildUuid", (Object)libraryInfo2.getBuildUuid());
            $this$composeLibraryInfoJsonObject_u24lambda_u241.put("environment", (Object)libraryInfo2.getEnvironment());
            jSONObject = jSONObject2;
        }
        return jSONObject;
    }

    private static final JSONObject composeProperties(Date date, String issueKey) {
        JSONObject jSONObject;
        JSONObject $this$composeProperties_u24lambda_u242 = jSONObject = new JSONObject();
        boolean bl = false;
        if (date != null) {
            $this$composeProperties_u24lambda_u242.put("date", (Object)DateTimeUtils.formatISO8601((Date)date));
        }
        $this$composeProperties_u24lambda_u242.put("board", (Object)Build.BOARD);
        $this$composeProperties_u24lambda_u242.put("brand", (Object)Build.BRAND);
        $this$composeProperties_u24lambda_u242.put("cpuABI", (Object)TextUtils.join((CharSequence)", ", (Object[])Build.SUPPORTED_ABIS));
        $this$composeProperties_u24lambda_u242.put("device", (Object)Build.DEVICE);
        $this$composeProperties_u24lambda_u242.put("manufacturer", (Object)Build.MANUFACTURER);
        $this$composeProperties_u24lambda_u242.put("model", (Object)Build.MODEL);
        $this$composeProperties_u24lambda_u242.put("cpuCount", (Object)String.valueOf(Runtime.getRuntime().availableProcessors()));
        $this$composeProperties_u24lambda_u242.put("osVersionSdkInt", (Object)String.valueOf(Build.VERSION.SDK_INT));
        $this$composeProperties_u24lambda_u242.put("osVersionRelease", (Object)Build.VERSION.RELEASE);
        if (issueKey != null) {
            $this$composeProperties_u24lambda_u242.put("issueKey", (Object)issueKey);
        }
        return jSONObject;
    }

    private static final JSONArray composeTags(List<String> tags) {
        JSONArray jSONArray;
        if (tags != null) {
            JSONArray jSONArray2;
            JSONArray $this$composeTags_u24lambda_u243 = jSONArray2 = new JSONArray();
            boolean bl = false;
            for (String tag : tags) {
                $this$composeTags_u24lambda_u243.put((Object)tag);
            }
            jSONArray = jSONArray2;
        } else {
            jSONArray = null;
        }
        return jSONArray;
    }

    private static final boolean isInForeground() {
        ActivityManager.RunningAppProcessInfo appProcessInfo = new ActivityManager.RunningAppProcessInfo();
        ActivityManager.getMyMemoryState((ActivityManager.RunningAppProcessInfo)appProcessInfo);
        return appProcessInfo.importance == 100 || appProcessInfo.importance == 200;
    }

    private static final boolean isRooted(Context context) {
        boolean bl;
        boolean isEmulator = UploadBeanUtilsLite.isEmulator(context);
        String buildTags = Build.TAGS;
        if (!isEmulator && buildTags != null && StringsKt.contains$default((CharSequence)buildTags, (CharSequence)"test-keys", (boolean)false, (int)2, null)) {
            bl = true;
        } else {
            File file = new File("/system/app/Superuser.apk");
            if (file.exists()) {
                bl = true;
            } else {
                file = new File("/system/xbin/su");
                bl = !isEmulator && file.exists();
            }
        }
        return bl;
    }

    private static final boolean isEmulator(Context context) {
        String androidId = Settings.Secure.getString((ContentResolver)context.getContentResolver(), (String)"android_id");
        return Intrinsics.areEqual((Object)"sdk", (Object)Build.PRODUCT) || Intrinsics.areEqual((Object)"google_sdk", (Object)Build.PRODUCT) || androidId == null;
    }
}

