/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.lite.limits;

import android.content.Context;
import android.content.SharedPreferences;
import android.os.Looper;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.base.limits.TracerFeatureLimits;
import ru.ok.tracer.lite.TracerLite;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0005\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u001c\u0010\r\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u0016J?\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u000e\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010\u00132\b\u0010\u000f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0015\u001a\u0004\u0018\u00010\u0013H\u0016\u00a2\u0006\u0002\u0010\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lru/ok/tracer/lite/limits/TracerLiteLimits;", "Lru/ok/tracer/base/limits/TracerFeatureLimits;", "context", "Landroid/content/Context;", "libraryPackageName", "", "(Landroid/content/Context;Ljava/lang/String;)V", "prefs", "Landroid/content/SharedPreferences;", "getPrefs", "()Landroid/content/SharedPreferences;", "prefsRead", "", "isLimited", "featureName", "tag", "setShutdownMs", "", "globalShutdownMs", "", "featureShutdownMs", "tagShutdownMs", "(Ljava/lang/Long;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/String;Ljava/lang/Long;)V", "Companion", "tracer-lite-commons_release"})
public final class TracerLiteLimits
implements TracerFeatureLimits {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Context context;
    @NotNull
    private final String libraryPackageName;
    private boolean prefsRead;

    public TracerLiteLimits(@NotNull Context context, @NotNull String libraryPackageName) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)libraryPackageName, (String)"libraryPackageName");
        this.context = context;
        this.libraryPackageName = libraryPackageName;
    }

    private final SharedPreferences getPrefs() {
        this.prefsRead = true;
        SharedPreferences sharedPreferences = this.context.getSharedPreferences("tracer-" + this.libraryPackageName, 0);
        Intrinsics.checkNotNullExpressionValue((Object)sharedPreferences, (String)"context.getSharedPrefere\u2026e\", Context.MODE_PRIVATE)");
        return sharedPreferences;
    }

    public void setShutdownMs(@Nullable Long globalShutdownMs, @Nullable String featureName, @Nullable Long featureShutdownMs, @Nullable String tag, @Nullable Long tagShutdownMs) {
        boolean edited = false;
        SharedPreferences.Editor prefsEditor = this.getPrefs().edit();
        if (globalShutdownMs != null && globalShutdownMs > 0L) {
            long globalShutdownUntilMillis = System.currentTimeMillis() + globalShutdownMs;
            prefsEditor.putLong("system.shutdown.until.ts", globalShutdownUntilMillis);
            edited = true;
        }
        if (featureName != null && featureShutdownMs != null && featureShutdownMs > 0L) {
            long featureShutdownUntilMillis = System.currentTimeMillis() + featureShutdownMs;
            prefsEditor.putLong("system." + featureName + ".shutdown.until.ts", featureShutdownUntilMillis);
            edited = true;
        }
        if (edited) {
            prefsEditor.apply();
        }
    }

    public boolean isLimited(@Nullable String featureName, @Nullable String tag) {
        long featureShutdownUntilMillis;
        long globalShutdownUntilMillis;
        if (!this.prefsRead && Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            return false;
        }
        long currentTimeMillis = System.currentTimeMillis();
        if (currentTimeMillis < (globalShutdownUntilMillis = this.getPrefs().getLong("system.shutdown.until.ts", Long.MIN_VALUE))) {
            return true;
        }
        return featureName != null && currentTimeMillis < (featureShutdownUntilMillis = this.getPrefs().getLong("system." + featureName + ".shutdown.until.ts", Long.MIN_VALUE));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lru/ok/tracer/lite/limits/TracerLiteLimits$Companion;", "", "()V", "get", "Lru/ok/tracer/lite/limits/TracerLiteLimits;", "tracer", "Lru/ok/tracer/lite/TracerLite;", "tracer-lite-commons_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TracerLiteLimits get(@NotNull TracerLite tracer) {
            Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
            return tracer.getLimits$tracer_lite_commons_release();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

