/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.lite.performance.metrics;

import android.util.Log;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.base.time.PrecisionClock;
import ru.ok.tracer.base.ucum.UcumUtils;
import ru.ok.tracer.lite.TracerLite;
import ru.ok.tracer.lite.limits.TracerLiteLimits;
import ru.ok.tracer.lite.performance.metrics.PerfSampleLite;
import ru.ok.tracer.lite.performance.metrics.upload.PerfSampleUploaderLite;
import ru.ok.tracer.lite.performance.metrics.util.DelayedWork;
import ru.ok.tracer.lite.utils.TracerExecutorsHolder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0014\u001a\u00020\u0015H\u0002JO\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2*\u0010\u001d\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u001f0\u001e\"\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u001f\u00a2\u0006\u0002\u0010 JO\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182*\u0010\u001d\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u001f0\u001e\"\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\u001f\u00a2\u0006\u0002\u0010!J4\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u00182\u0012\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\u00010\"H\u0002R\u0014\u0010\u0005\u001a\u00020\u00068BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lru/ok/tracer/lite/performance/metrics/TracerPerformanceMetricsLite;", "", "tracer", "Lru/ok/tracer/lite/TracerLite;", "(Lru/ok/tracer/lite/TracerLite;)V", "ioExecutor", "Ljava/util/concurrent/Executor;", "getIoExecutor", "()Ljava/util/concurrent/Executor;", "limits", "Lru/ok/tracer/lite/limits/TracerLiteLimits;", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lru/ok/tracer/lite/performance/metrics/PerfSampleLite;", "tracerIsDisabled", "", "uploader", "Lru/ok/tracer/lite/performance/metrics/upload/PerfSampleUploaderLite;", "work", "Lru/ok/tracer/lite/performance/metrics/util/DelayedWork;", "prepareUpload", "", "sample", "name", "", "value", "", "unit", "Ljava/util/concurrent/TimeUnit;", "attributes", "", "Lkotlin/Pair;", "(Ljava/lang/String;JLjava/util/concurrent/TimeUnit;[Lkotlin/Pair;)V", "(Ljava/lang/String;JLjava/lang/String;[Lkotlin/Pair;)V", "", "tracer-lite-performance-metrics_release"})
public final class TracerPerformanceMetricsLite {
    @NotNull
    private final TracerLite tracer;
    @NotNull
    private final TracerLiteLimits limits;
    @NotNull
    private final PerfSampleUploaderLite uploader;
    @NotNull
    private final ConcurrentLinkedQueue<PerfSampleLite> queue;
    @NotNull
    private final DelayedWork work;
    private volatile boolean tracerIsDisabled;

    @Inject
    public TracerPerformanceMetricsLite(@NotNull TracerLite tracer) {
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
        this.tracer = tracer;
        this.limits = TracerLiteLimits.Companion.get(this.tracer);
        this.uploader = new PerfSampleUploaderLite(this.tracer);
        this.queue = new ConcurrentLinkedQueue();
        this.work = new DelayedWork(null, 1000L, 0L, 0L, 0L, (Function0)new Function0<Unit>((Object)this){

            public final void invoke() {
                TracerPerformanceMetricsLite.access$prepareUpload((TracerPerformanceMetricsLite)this.receiver);
            }
        }, 29, null);
    }

    private final Executor getIoExecutor() {
        return TracerExecutorsHolder.Companion.get(this.tracer).getIoExecutor();
    }

    public final void sample(@NotNull String name, long value, @NotNull TimeUnit unit, Pair<String, ? extends Object> ... attributes) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.sample(name, value, UcumUtils.getToUcumString((TimeUnit)unit), MapsKt.mapOf(Arrays.copyOf(attributes, attributes.length)));
    }

    public final void sample(@NotNull String name, long value, @NotNull String unit, Pair<String, ? extends Object> ... attributes) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.sample(name, value, unit, MapsKt.mapOf(Arrays.copyOf(attributes, attributes.length)));
    }

    private final void sample(String name, long value, String unit, Map<String, ? extends Object> attributes) {
        if (this.tracerIsDisabled) {
            Log.d((String)"Tracer", (String)"Tracer is disabled");
            return;
        }
        if (this.limits.isLimited("PERFORMANCE_METRICS", null)) {
            Log.e((String)"Tracer", (String)"Feature PERFORMANCE_METRICS limited");
            return;
        }
        ((Collection)this.queue).add(new PerfSampleLite(PrecisionClock.currentTimeNanos(), name, value, unit, attributes));
        DelayedWork.schedule$default(this.work, 0, 1, null);
    }

    private final void prepareUpload() {
        this.getIoExecutor().execute(() -> TracerPerformanceMetricsLite.prepareUpload$lambda$1(this));
    }

    private static final void prepareUpload$lambda$1(TracerPerformanceMetricsLite this$0) {
        List list;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        List $this$prepareUpload_u24lambda_u241_u24lambda_u240 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        while (true) {
            PerfSampleLite perfSampleLite;
            Collection collection = $this$prepareUpload_u24lambda_u241_u24lambda_u240;
            PerfSampleLite perfSampleLite2 = perfSampleLite = this$0.queue.poll();
            if (perfSampleLite2 == null) break;
            Intrinsics.checkNotNullExpressionValue((Object)perfSampleLite2, (String)"queue.poll() ?: break");
            collection.add(perfSampleLite);
        }
        List samples = CollectionsKt.build((List)list);
        if (this$0.tracer.isDisabled()) {
            Log.d((String)"Tracer", (String)"Tracer is disabled");
            this$0.tracerIsDisabled = true;
            return;
        }
        this$0.uploader.upload(samples);
    }

    public static final /* synthetic */ void access$prepareUpload(TracerPerformanceMetricsLite $this) {
        $this.prepareUpload();
    }
}

