/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.lite.performance.metrics.util;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.SystemClock;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\u0018\u0000 \u00152\u00020\u0001:\u0003\u0015\u0016\u0017BC\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\n\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\u0012\u001a\u00020\u000b2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0007R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lru/ok/tracer/lite/performance/metrics/util/DelayedWork;", "", "looper", "Landroid/os/Looper;", "minDelayMillis", "", "maxDelayMillis", "minAmount", "maxAmount", "block", "Lkotlin/Function0;", "", "(Landroid/os/Looper;JJJJLkotlin/jvm/functions/Function0;)V", "atomicState", "Ljava/util/concurrent/atomic/AtomicReference;", "Lru/ok/tracer/lite/performance/metrics/util/DelayedWork$State;", "handler", "Landroid/os/Handler;", "schedule", "amount", "", "Companion", "State", "WorkCallback", "tracer-lite-performance-metrics_release"})
public final class DelayedWork {
    @NotNull
    private static final Companion Companion = new Companion(null);
    private final long minDelayMillis;
    private final long maxDelayMillis;
    private final long minAmount;
    private final long maxAmount;
    @NotNull
    private final Function0<Unit> block;
    @NotNull
    private final Handler handler;
    @NotNull
    private final AtomicReference<State> atomicState;
    @Deprecated
    private static final int MSG_RUN = 0;

    public DelayedWork(@NotNull Looper looper, long minDelayMillis, long maxDelayMillis, long minAmount, long maxAmount, @NotNull Function0<Unit> block) {
        Intrinsics.checkNotNullParameter((Object)looper, (String)"looper");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        this.minDelayMillis = minDelayMillis;
        this.maxDelayMillis = maxDelayMillis;
        this.minAmount = minAmount;
        this.maxAmount = maxAmount;
        this.block = block;
        if (!(this.minDelayMillis >= 0L)) {
            boolean $i$a$-require-DelayedWork$52 = false;
            String $i$a$-require-DelayedWork$52 = "minDelayMillis < 0";
            throw new IllegalArgumentException($i$a$-require-DelayedWork$52.toString());
        }
        if (!(this.maxDelayMillis >= this.minDelayMillis)) {
            boolean $i$a$-require-DelayedWork$62 = false;
            String $i$a$-require-DelayedWork$62 = "maxDelayMillis < minDelayMillis";
            throw new IllegalArgumentException($i$a$-require-DelayedWork$62.toString());
        }
        if (!(this.minAmount >= 1L)) {
            boolean $i$a$-require-DelayedWork$72 = false;
            String $i$a$-require-DelayedWork$72 = "minAmount < 1";
            throw new IllegalArgumentException($i$a$-require-DelayedWork$72.toString());
        }
        if (!(this.maxAmount >= this.minAmount)) {
            boolean bl = false;
            String string = "maxAmount < minAmount";
            throw new IllegalArgumentException(string.toString());
        }
        this.handler = new Handler(looper, (Handler.Callback)new WorkCallback());
        this.atomicState = new AtomicReference<State>(State.Companion.getNONE());
    }

    public /* synthetic */ DelayedWork(Looper looper, long l, long l2, long l3, long l4, Function0 function0, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            Looper looper2 = Looper.getMainLooper();
            Intrinsics.checkNotNullExpressionValue((Object)looper2, (String)"getMainLooper()");
            looper = looper2;
        }
        if ((n & 4) != 0) {
            l2 = Long.MAX_VALUE;
        }
        if ((n & 8) != 0) {
            l3 = 1L;
        }
        if ((n & 0x10) != 0) {
            l4 = Long.MAX_VALUE;
        }
        this(looper, l, l2, l3, l4, (Function0<Unit>)function0);
    }

    @JvmOverloads
    public final void schedule(int amount) {
        block4: {
            long nextRunMillis;
            long currentMillis;
            int newCollectedAmount;
            long newDeadlineMillis;
            State newState;
            State state;
            if (!(amount >= 0)) {
                boolean bl = false;
                String string = "amount < 0";
                throw new IllegalArgumentException(string.toString());
            }
            if (amount == 0) {
                return;
            }
            do {
                currentMillis = SystemClock.elapsedRealtime();
                state = this.atomicState.get();
                int collectedAmount = state.getCollectedAmount();
                long deadlineMillis = state.getDeadlineMillis();
                if ((long)collectedAmount > this.maxAmount) {
                    return;
                }
                newCollectedAmount = collectedAmount + amount;
                newDeadlineMillis = collectedAmount == 0 ? Long.MAX_VALUE : (deadlineMillis < Long.MAX_VALUE ? deadlineMillis : (this.maxDelayMillis < Long.MAX_VALUE ? currentMillis + this.maxDelayMillis : Long.MAX_VALUE));
                long l = (long)newCollectedAmount > this.maxAmount ? currentMillis : (nextRunMillis = (long)newCollectedAmount >= this.minAmount ? Math.min(currentMillis + this.minDelayMillis, deadlineMillis) : deadlineMillis);
            } while (!this.atomicState.compareAndSet(state, newState = new State(newDeadlineMillis, newCollectedAmount)));
            this.handler.removeMessages(0);
            if (nextRunMillis >= Long.MAX_VALUE) break block4;
            this.handler.sendEmptyMessageDelayed(0, nextRunMillis - currentMillis);
        }
    }

    public static /* synthetic */ void schedule$default(DelayedWork delayedWork, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = 1;
        }
        delayedWork.schedule(n);
    }

    @JvmOverloads
    public final void schedule() {
        DelayedWork.schedule$default(this, 0, 1, null);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\b\u0002\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\f"}, d2={"Lru/ok/tracer/lite/performance/metrics/util/DelayedWork$State;", "", "deadlineMillis", "", "collectedAmount", "", "(JI)V", "getCollectedAmount", "()I", "getDeadlineMillis", "()J", "Companion", "tracer-lite-performance-metrics_release"})
    private static final class State {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final long deadlineMillis;
        private final int collectedAmount;
        @NotNull
        private static final State NONE = new State(Long.MAX_VALUE, 0);

        public State(long deadlineMillis, int collectedAmount) {
            this.deadlineMillis = deadlineMillis;
            this.collectedAmount = collectedAmount;
        }

        public final long getDeadlineMillis() {
            return this.deadlineMillis;
        }

        public final int getCollectedAmount() {
            return this.collectedAmount;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lru/ok/tracer/lite/performance/metrics/util/DelayedWork$State$Companion;", "", "()V", "NONE", "Lru/ok/tracer/lite/performance/metrics/util/DelayedWork$State;", "getNONE", "()Lru/ok/tracer/lite/performance/metrics/util/DelayedWork$State;", "tracer-lite-performance-metrics_release"})
        public static final class Companion {
            private Companion() {
            }

            @NotNull
            public final State getNONE() {
                return NONE;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u0007"}, d2={"Lru/ok/tracer/lite/performance/metrics/util/DelayedWork$WorkCallback;", "Landroid/os/Handler$Callback;", "(Lru/ok/tracer/lite/performance/metrics/util/DelayedWork;)V", "handleMessage", "", "msg", "Landroid/os/Message;", "tracer-lite-performance-metrics_release"})
    private final class WorkCallback
    implements Handler.Callback {
        public boolean handleMessage(@NotNull Message msg) {
            Intrinsics.checkNotNullParameter((Object)msg, (String)"msg");
            DelayedWork.this.atomicState.set(State.Companion.getNONE());
            DelayedWork.this.block.invoke();
            return true;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lru/ok/tracer/lite/performance/metrics/util/DelayedWork$Companion;", "", "()V", "MSG_RUN", "", "tracer-lite-performance-metrics_release"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

