/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.lite.performance.metrics.upload;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.util.Log;
import java.io.Closeable;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.ok.tracer.base.apptoken.AppTokenUtils;
import ru.ok.tracer.base.commands.CommandsHandler;
import ru.ok.tracer.base.compat.PackageInfoCompat;
import ru.ok.tracer.base.compat.PackageManagerCompat;
import ru.ok.tracer.base.http.HttpRequest;
import ru.ok.tracer.base.http.HttpRequestBody;
import ru.ok.tracer.base.http.HttpResponse;
import ru.ok.tracer.base.http.HttpResponseBody;
import ru.ok.tracer.base.limits.TracerFeatureLimits;
import ru.ok.tracer.base.time.PrecisionClock;
import ru.ok.tracer.lite.TracerLibraryInfo;
import ru.ok.tracer.lite.TracerLite;
import ru.ok.tracer.lite.limits.TracerLiteLimits;
import ru.ok.tracer.lite.performance.metrics.PerfSampleLite;
import ru.ok.tracer.lite.upload.TracerLiteHttpClientHolder;
import ru.ok.tracer.lite.upload.UploadBeanUtilsLite;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0010\u001a\u00020\u00112\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u00010\u0013H\u0002J \u0010\u0014\u001a\u0004\u0018\u00010\u00112\u0014\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\u0001\u0018\u00010\u0013H\u0002J\u0016\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\u0010\u0010\u0015\u001a\u00020\u00112\u0006\u0010\u001a\u001a\u00020\u0019H\u0002J\u0014\u0010\u001b\u001a\u00020\u001c2\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001d"}, d2={"Lru/ok/tracer/lite/performance/metrics/upload/PerfSampleUploaderLite;", "", "tracer", "Lru/ok/tracer/lite/TracerLite;", "(Lru/ok/tracer/lite/TracerLite;)V", "commandHandler", "Lru/ok/tracer/base/commands/CommandsHandler;", "httpClientHolder", "Lru/ok/tracer/lite/upload/TracerLiteHttpClientHolder;", "limits", "Lru/ok/tracer/lite/limits/TracerLiteLimits;", "packageName", "", "versionCode", "", "versionName", "attributesToJson", "Lorg/json/JSONObject;", "attributes", "", "nullableAttributesToJson", "toJson", "Lorg/json/JSONArray;", "samples", "", "Lru/ok/tracer/lite/performance/metrics/PerfSampleLite;", "sample", "upload", "", "tracer-lite-performance-metrics_release"})
public final class PerfSampleUploaderLite {
    @NotNull
    private final TracerLite tracer;
    @NotNull
    private final String versionName;
    private final long versionCode;
    @NotNull
    private final String packageName;
    @NotNull
    private final TracerLiteHttpClientHolder httpClientHolder;
    @NotNull
    private final TracerLiteLimits limits;
    @NotNull
    private final CommandsHandler commandHandler;

    public PerfSampleUploaderLite(@NotNull TracerLite tracer) {
        Intrinsics.checkNotNullParameter((Object)tracer, (String)"tracer");
        this.tracer = tracer;
        Context context = this.tracer.getContext();
        PackageManager packageManager = context.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"context.packageManager");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        PackageInfo packageInfo = PackageManagerCompat.getPackageInfoCompat((PackageManager)packageManager, (String)string, (int)0);
        String string2 = packageInfo.versionName;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"packageInfo.versionName");
        this.versionName = string2;
        this.versionCode = PackageInfoCompat.getLongVersionCodeCompat((PackageInfo)packageInfo);
        String string3 = packageInfo.packageName;
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"packageInfo.packageName");
        this.packageName = string3;
        this.httpClientHolder = TracerLiteHttpClientHolder.Companion.get(this.tracer);
        this.limits = TracerLiteLimits.Companion.get(this.tracer);
        this.commandHandler = new CommandsHandler.Builder().setLimitsHandler((TracerFeatureLimits)this.limits).setFeatureName("PERFORMANCE_METRICS").build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void upload(@NotNull List<PerfSampleLite> samples) {
        Intrinsics.checkNotNullParameter(samples, (String)"samples");
        try {
            v0 = this.tracer.getLibToken();
            if (v0 == null) {
                $i$a$-checkNotNull-PerfSampleUploaderLite$upload$libToken$1 = false;
                $i$a$-checkNotNull-PerfSampleUploaderLite$upload$libToken$1 = "No lib token";
                throw new IllegalStateException($i$a$-checkNotNull-PerfSampleUploaderLite$upload$libToken$1.toString());
            }
            var3_6 = v0;
        }
        catch (Exception ex) {
            Log.e((String)"Tracer", (String)"No lib token");
            return;
        }
        libToken = var3_6;
        appToken = AppTokenUtils.getHostAppToken((Context)this.tracer.getContext());
        $this$upload_u24lambda_u241 = var5_8 = UploadBeanUtilsLite.composeLibUploadBean$default((Context)this.tracer.getContext(), (TracerLibraryInfo)this.tracer.getLibraryInfo(), null, null, null, (int)28, null);
        $i$a$-apply-PerfSampleUploaderLite$upload$bodyJsonObject$1 = false;
        $this$upload_u24lambda_u241.put("clientTimeUnixNano", PrecisionClock.currentTimeNanos());
        $this$upload_u24lambda_u241.put("samples", (Object)this.toJson(samples));
        bodyJsonObject = var5_8;
        p0 = this.tracer.getConfiguration().getApiUrl();
        $i$a$-let-PerfSampleUploaderLite$upload$url$1 = false;
        $this$upload_u24lambda_u242 = $i$a$-apply-PerfSampleUploaderLite$upload$bodyJsonObject$1 /* !! */  = Uri.parse((String)p0).buildUpon().appendEncodedPath("api/perf/upload").appendQueryParameter("crashToken", libToken);
        $i$a$-apply-PerfSampleUploaderLite$upload$url$2 = false;
        if (appToken != null) {
            $this$upload_u24lambda_u242.appendQueryParameter("crashHostAppToken", appToken);
        }
        v1 = $i$a$-apply-PerfSampleUploaderLite$upload$bodyJsonObject$1 /* !! */ .toString();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"tracer.configuration.api\u2026}\n            .toString()");
        url = v1;
        v2 = bodyJsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"bodyJsonObject.toString()");
        request = new HttpRequest(url, HttpRequestBody.Companion.fromString$default((HttpRequestBody.Companion)HttpRequestBody.Companion, (String)"application/json; charset=utf-8", (String)v2, null, (int)4, null));
        try {
            $i$a$-apply-PerfSampleUploaderLite$upload$bodyJsonObject$1 /* !! */  = (Closeable)this.httpClientHolder.getHttpClient().execute(request);
            var8_13 = null;
            try {
                response = (HttpResponse)$i$a$-apply-PerfSampleUploaderLite$upload$bodyJsonObject$1 /* !! */ ;
                $i$a$-use-PerfSampleUploaderLite$upload$1 = false;
                responseCode = response.getStatusCode();
                responseMessage = response.getMessage();
                v3 = response.getBody();
                responseContentType = v3 != null ? v3.getContentType() : null;
                v4 /* !! */  = response.getBody();
                if (v4 /* !! */  == null) ** GOTO lbl-1000
                v5 = v4 /* !! */ .getBytes();
                v4 /* !! */  = (HttpResponseBody)v5;
                if (v5 != null) {
                    v6 = StringsKt.decodeToString((byte[])v4 /* !! */ );
                } else lbl-1000:
                // 2 sources

                {
                    v6 = null;
                }
                responseContent = v6;
                this.commandHandler.handleResponse(responseContentType, responseContent);
                if (responseCode != 200) {
                    throw new IOException("HTTP " + responseCode + ' ' + responseMessage);
                }
                var9_15 = Unit.INSTANCE;
            }
            catch (Throwable var9_16) {
                var8_13 = var9_16;
                throw var9_16;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$a$-apply-PerfSampleUploaderLite$upload$bodyJsonObject$1 /* !! */ , (Throwable)var8_13);
            }
        }
        catch (IOException ex) {
            Log.e((String)"ru.ok.tracer", (String)"Tracer crash report failed", (Throwable)ex);
        }
    }

    private final JSONArray toJson(List<PerfSampleLite> samples) {
        JSONArray jSONArray;
        JSONArray $this$toJson_u24lambda_u244 = jSONArray = new JSONArray();
        boolean bl = false;
        for (PerfSampleLite sample : samples) {
            $this$toJson_u24lambda_u244.put((Object)this.toJson(sample));
        }
        return jSONArray;
    }

    /*
     * WARNING - void declaration
     */
    private final JSONObject toJson(PerfSampleLite sample) {
        void it;
        Map<String, Object> map;
        JSONObject jSONObject;
        JSONObject $this$toJson_u24lambda_u246 = jSONObject = new JSONObject();
        boolean bl = false;
        $this$toJson_u24lambda_u246.put("timeUnixNano", sample.getTimeUnixNano());
        $this$toJson_u24lambda_u246.put("name", (Object)sample.getName());
        $this$toJson_u24lambda_u246.put("value", sample.getValue());
        $this$toJson_u24lambda_u246.put("unit", (Object)sample.getUnit());
        Map<String, Object> map2 = map = sample.getAttributes();
        PerfSampleUploaderLite perfSampleUploaderLite = this;
        String string = "attributes";
        JSONObject jSONObject2 = $this$toJson_u24lambda_u246;
        boolean bl2 = false;
        boolean bl3 = !it.isEmpty();
        jSONObject2.put(string, (Object)perfSampleUploaderLite.nullableAttributesToJson(bl3 ? map : null));
        return jSONObject;
    }

    private final JSONObject nullableAttributesToJson(Map<String, ? extends Object> attributes) {
        return attributes != null ? this.attributesToJson(attributes) : null;
    }

    private final JSONObject attributesToJson(Map<String, ? extends Object> attributes) {
        JSONObject jSONObject;
        JSONObject $this$attributesToJson_u24lambda_u247 = jSONObject = new JSONObject();
        boolean bl = false;
        for (Map.Entry<String, ? extends Object> entry : attributes.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Object object = value;
            if (object instanceof String) {
                $this$attributesToJson_u24lambda_u247.put(key, value);
                continue;
            }
            if (object instanceof Boolean) {
                $this$attributesToJson_u24lambda_u247.put(key, ((Boolean)value).booleanValue());
                continue;
            }
            if (object instanceof Long) {
                $this$attributesToJson_u24lambda_u247.put(key, ((Number)value).longValue());
                continue;
            }
            if (object instanceof Double) {
                $this$attributesToJson_u24lambda_u247.put(key, ((Number)value).doubleValue());
                continue;
            }
            if (object instanceof Byte) {
                $this$attributesToJson_u24lambda_u247.put(key, value);
                continue;
            }
            if (object instanceof Short) {
                $this$attributesToJson_u24lambda_u247.put(key, value);
                continue;
            }
            if (object instanceof Integer) {
                $this$attributesToJson_u24lambda_u247.put(key, ((Number)value).intValue());
                continue;
            }
            if (object instanceof Float) {
                $this$attributesToJson_u24lambda_u247.put(key, value);
                continue;
            }
            $this$attributesToJson_u24lambda_u247.put(key, (Object)value.toString());
        }
        return jSONObject;
    }
}

