/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.opentelemetry;

import android.content.Context;
import io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.trace.TracerProvider;
import io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.resources.Resource;
import io.opentelemetry.sdk.resources.ResourceBuilder;
import io.opentelemetry.sdk.trace.SdkTracerProvider;
import io.opentelemetry.sdk.trace.SdkTracerProviderBuilder;
import io.opentelemetry.sdk.trace.SpanLimits;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.opentelemetry.OpenTelemetryConfiguration;
import ru.ok.tracer.opentelemetry.export.TracerOpenTelemetrySpanExporter;
import ru.ok.tracer.opentelemetry.export.TracerOpenTelemetrySpanProcessor;
import ru.ok.tracer.utils.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\n\u001a\u00020\u0005H\u0002J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\u0005H\u0016J\r\u0010\u000e\u001a\u00020\u000fH\u0000\u00a2\u0006\u0002\b\u0010R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u00078BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\t\u00a8\u0006\u0011"}, d2={"Lru/ok/tracer/opentelemetry/TracerOpenTelemetry;", "Lio/opentelemetry/api/OpenTelemetry;", "()V", "atomicTracerProvider", "Ljava/util/concurrent/atomic/AtomicReference;", "Lio/opentelemetry/api/trace/TracerProvider;", "clock", "Lio/opentelemetry/sdk/common/Clock;", "getClock", "()Lio/opentelemetry/sdk/common/Clock;", "createTracerProvider", "getPropagators", "Lio/opentelemetry/context/propagation/ContextPropagators;", "getTracerProvider", "init", "", "init$tracer_opentelemetry_release", "tracer-opentelemetry_release"})
public final class TracerOpenTelemetry
implements OpenTelemetry {
    @NotNull
    public static final TracerOpenTelemetry INSTANCE = new TracerOpenTelemetry();
    @NotNull
    private static final AtomicReference<TracerProvider> atomicTracerProvider = new AtomicReference();

    private TracerOpenTelemetry() {
    }

    private final Clock getClock() {
        Clock clock = Clock.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)clock, (String)"getDefault()");
        return clock;
    }

    public final void init$tracer_opentelemetry_release() {
        OpenTelemetryConfiguration config = OpenTelemetryConfiguration.Companion.get();
        if (config.getInstallGlobal$tracer_opentelemetry_release()) {
            GlobalOpenTelemetry.set((OpenTelemetry)INSTANCE);
        }
    }

    @NotNull
    public TracerProvider getTracerProvider() {
        TracerProvider tracerProvider;
        block4: {
            TracerProvider newValue$iv;
            AtomicReference<TracerProvider> $this$getOrInit$iv = atomicTracerProvider;
            boolean $i$f$getOrInit = false;
            do {
                TracerProvider tracerProvider2;
                TracerProvider oldValue$iv;
                if ((oldValue$iv = $this$getOrInit$iv.get()) != null) {
                    tracerProvider = oldValue$iv;
                    break block4;
                }
                boolean bl = false;
                try {
                    tracerProvider2 = INSTANCE.createTracerProvider();
                }
                catch (Exception ex) {
                    Logger.e((String)"Couldn't create TracerProvider", (Throwable)ex);
                    tracerProvider2 = TracerProvider.noop();
                }
                Intrinsics.checkNotNullExpressionValue((Object)tracerProvider2, (String)"try {\n            create\u2026Provider.noop()\n        }");
            } while (!$this$getOrInit$iv.compareAndSet(null, newValue$iv));
            tracerProvider = newValue$iv;
        }
        return tracerProvider;
    }

    private final TracerProvider createTracerProvider() {
        Context context = Tracer.INSTANCE.getContext();
        OpenTelemetryConfiguration config = OpenTelemetryConfiguration.Companion.get();
        if (!config.getEnabled$tracer_opentelemetry_release()) {
            TracerProvider tracerProvider = TracerProvider.noop();
            Intrinsics.checkNotNullExpressionValue((Object)tracerProvider, (String)"noop()");
            return tracerProvider;
        }
        SdkTracerProviderBuilder sdkTracerProviderBuilder = SdkTracerProvider.builder().setClock(this.getClock()).setSpanLimits(SpanLimits.builder().setMaxNumberOfEvents(config.getMaxNumberOfEventsPerSpan$tracer_opentelemetry_release()).setMaxNumberOfLinks(config.getMaxNumberOfLinksPerSpan$tracer_opentelemetry_release()).setMaxNumberOfAttributes(config.getMaxNumberOfAttributesPerSpan$tracer_opentelemetry_release()).setMaxNumberOfAttributesPerEvent(config.getMaxNumberOfAttributesPerEvent$tracer_opentelemetry_release()).setMaxNumberOfAttributesPerLink(config.getMaxNumberOfAttributesPerLink$tracer_opentelemetry_release()).setMaxAttributeValueLength(config.getMaxAttributeValueLength$tracer_opentelemetry_release()).build());
        ResourceBuilder resourceBuilder = Resource.builder();
        String string = config.getServiceName$tracer_opentelemetry_release();
        if (string == null) {
            string = "unknown_service:" + context.getPackageName();
        }
        SdkTracerProvider sdkTracerProvider = sdkTracerProviderBuilder.setResource(resourceBuilder.put("service.name", string).put("telemetry.sdk.name", "ru.ok.tracer").put("telemetry.sdk.version", "1.0.6").put("telemetry.sdk.language", "java").put("os.name", "Android").put("os.type", "linux").build()).addSpanProcessor(TracerOpenTelemetrySpanProcessor.Companion.create(TracerOpenTelemetrySpanExporter.Companion.create(this.getClock(), config.getMaxSpanCountToUpload$tracer_opentelemetry_release()), config.getCompleteTracesToUpload$tracer_opentelemetry_release())).build();
        Intrinsics.checkNotNullExpressionValue((Object)sdkTracerProvider, (String)"builder()\n            .s\u2026   )\n            .build()");
        return (TracerProvider)sdkTracerProvider;
    }

    @NotNull
    public ContextPropagators getPropagators() {
        ContextPropagators contextPropagators = ContextPropagators.noop();
        Intrinsics.checkNotNullExpressionValue((Object)contextPropagators, (String)"noop()");
        return contextPropagators;
    }
}

