/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.opentelemetry.export;

import android.net.Uri;
import android.util.Log;
import io.opentelemetry.sdk.common.Clock;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.io.Closeable;
import java.util.Collection;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.http.HttpRequest;
import ru.ok.tracer.base.http.HttpRequestBody;
import ru.ok.tracer.base.http.HttpResponse;
import ru.ok.tracer.base.http.HttpResponseBody;
import ru.ok.tracer.opentelemetry.FEATURE_OPEN_TELEMETRYKt;
import ru.ok.tracer.opentelemetry.export.OpenTelemetrySerializerKt;
import ru.ok.tracer.upload.NetworkResponseHandler;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerThreads;
import ru.ok.tracer.utils.config.ConfigStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00152\u00020\u0001:\u0002\u0015\u0016B\u0017\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u000b\u001a\u00020\f2\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0016J\b\u0010\u0010\u001a\u00020\fH\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH\u0002J\b\u0010\u0013\u001a\u00020\u0012H\u0002J\b\u0010\u0014\u001a\u00020\fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0007\u001a\u0010\u0012\f\u0012\n \n*\u0004\u0018\u00010\t0\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lru/ok/tracer/opentelemetry/export/TracerOpenTelemetrySpanExporter;", "Lio/opentelemetry/sdk/trace/export/SpanExporter;", "clock", "Lio/opentelemetry/sdk/common/Clock;", "maxCountToUpload", "", "(Lio/opentelemetry/sdk/common/Clock;I)V", "record", "Ljava/util/concurrent/atomic/AtomicReference;", "Lru/ok/tracer/opentelemetry/export/TracerOpenTelemetrySpanExporter$Record;", "kotlin.jvm.PlatformType", "export", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "spans", "", "Lio/opentelemetry/sdk/trace/data/SpanData;", "flush", "performUpload", "", "scheduleUpload", "shutdown", "Companion", "Record", "tracer-opentelemetry_release"})
public final class TracerOpenTelemetrySpanExporter
implements SpanExporter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Clock clock;
    private int maxCountToUpload;
    @NotNull
    private final AtomicReference<Record> record;

    private TracerOpenTelemetrySpanExporter(Clock clock, int maxCountToUpload) {
        this.clock = clock;
        this.maxCountToUpload = maxCountToUpload;
        this.record = new AtomicReference<Record>(new Record());
    }

    @NotNull
    public CompletableResultCode export(@NotNull Collection<? extends SpanData> spans) {
        Intrinsics.checkNotNullParameter(spans, (String)"spans");
        if (ConfigStorage.isLimited$default((ConfigStorage)ConfigStorage.INSTANCE, (TracerFeature)FEATURE_OPEN_TELEMETRYKt.getFEATURE_OPEN_TELEMETRY(), null, (int)2, null)) {
            Logger.d$default((String)"Open telemetry limited", null, (int)2, null);
            CompletableResultCode completableResultCode = CompletableResultCode.ofFailure();
            Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofFailure()");
            return completableResultCode;
        }
        Record record = this.record.get();
        Intrinsics.checkNotNull((Object)record);
        Record record2 = record;
        ConcurrentLinkedQueue<SpanData> queue = record2.getQueue();
        queue.addAll(spans);
        if (queue.size() >= this.maxCountToUpload) {
            this.scheduleUpload();
        }
        return record2.getResult();
    }

    @NotNull
    public CompletableResultCode flush() {
        Record record = this.record.get();
        ConcurrentLinkedQueue<SpanData> queue = record.getQueue();
        if (queue.isEmpty()) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
            Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess()");
            return completableResultCode;
        }
        this.scheduleUpload();
        return record.getResult();
    }

    @NotNull
    public CompletableResultCode shutdown() {
        return this.flush();
    }

    private final void scheduleUpload() {
        TracerThreads.INSTANCE.runOnIo(() -> TracerOpenTelemetrySpanExporter.scheduleUpload$lambda$0(this));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void performUpload(Collection<? extends SpanData> spans) {
        appToken = Tracer.INSTANCE.getAppToken();
        if (appToken == null) {
            Logger.w$default((String)"No app token", null, (int)2, null);
            return;
        }
        json = OpenTelemetrySerializerKt.composeTraceJson(spans);
        p0 = CoreTracerConfiguration.Companion.get().getApiUrl();
        $i$a$-let-TracerOpenTelemetrySpanExporter$performUpload$url$1 = false;
        v0 = Uri.parse((String)p0).buildUpon().appendEncodedPath("api/otel/trace").appendQueryParameter("crashToken", appToken).appendQueryParameter("clientTimeUnixNano", String.valueOf(this.clock.now())).toString();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"CoreTracerConfiguration.\u2026)\n            .toString()");
        url = v0;
        request = new HttpRequest(url, HttpRequestBody.Companion.fromString$default((HttpRequestBody.Companion)HttpRequestBody.Companion, (String)"application/json; charset=utf-8", (String)json, null, (int)4, null));
        var6_11 = (Closeable)Tracer.INSTANCE.getHttpClient().execute(request);
        var7_4 = null;
        try {
            response = (HttpResponse)var6_11;
            $i$a$-use-TracerOpenTelemetrySpanExporter$performUpload$1 = false;
            responseCode = response.getStatusCode();
            v1 = response.getBody();
            responseContentType = v1 != null ? v1.getContentType() : null;
            v2 /* !! */  = response.getBody();
            if (v2 /* !! */  == null) ** GOTO lbl-1000
            v3 = v2 /* !! */ .getBytes();
            v2 /* !! */  = (HttpResponseBody)v3;
            if (v3 != null) {
                v4 = StringsKt.decodeToString((byte[])v2 /* !! */ );
            } else lbl-1000:
            // 2 sources

            {
                v4 = null;
            }
            responseContent = v4;
            NetworkResponseHandler.universalHandleResponse$default((NetworkResponseHandler)NetworkResponseHandler.INSTANCE, (String)responseContentType, (String)responseContent, (String)FEATURE_OPEN_TELEMETRYKt.getFEATURE_OPEN_TELEMETRY().getName(), null, (int)8, null);
            Log.d((String)"Tracer", (String)("Request: " + json));
            if (responseCode != 200) {
                v5 = Log.e((String)"Tracer", (String)("HTTP " + responseCode + ", " + responseContent));
            } else {
                var13_16 = new Object[]{"Result: " + responseContent};
                Logger.d((String)"Tracer", (Object[])var13_16);
                v5 = Unit.INSTANCE;
            }
            var8_6 = v5;
        }
        catch (Throwable var8_7) {
            var7_4 = var8_7;
            throw var8_7;
        }
        finally {
            CloseableKt.closeFinally((Closeable)var6_11, (Throwable)var7_4);
        }
    }

    private static final void scheduleUpload$lambda$0(TracerOpenTelemetrySpanExporter this$0) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Record record = this$0.record.getAndSet(new Record());
        ConcurrentLinkedQueue<SpanData> queue = record.getQueue();
        if (queue.isEmpty()) {
            return;
        }
        try {
            this$0.performUpload((Collection<? extends SpanData>)queue);
            record.getResult().succeed();
        }
        catch (Exception ex) {
            record.getResult().fail();
        }
    }

    public /* synthetic */ TracerOpenTelemetrySpanExporter(Clock clock, int maxCountToUpload, DefaultConstructorMarker $constructor_marker) {
        this(clock, maxCountToUpload);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lru/ok/tracer/opentelemetry/export/TracerOpenTelemetrySpanExporter$Record;", "", "()V", "queue", "Ljava/util/concurrent/ConcurrentLinkedQueue;", "Lio/opentelemetry/sdk/trace/data/SpanData;", "getQueue", "()Ljava/util/concurrent/ConcurrentLinkedQueue;", "result", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "getResult", "()Lio/opentelemetry/sdk/common/CompletableResultCode;", "tracer-opentelemetry_release"})
    private static final class Record {
        @NotNull
        private final ConcurrentLinkedQueue<SpanData> queue = new ConcurrentLinkedQueue();
        @NotNull
        private final CompletableResultCode result = new CompletableResultCode();

        @NotNull
        public final ConcurrentLinkedQueue<SpanData> getQueue() {
            return this.queue;
        }

        @NotNull
        public final CompletableResultCode getResult() {
            return this.result;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lru/ok/tracer/opentelemetry/export/TracerOpenTelemetrySpanExporter$Companion;", "", "()V", "create", "Lru/ok/tracer/opentelemetry/export/TracerOpenTelemetrySpanExporter;", "clock", "Lio/opentelemetry/sdk/common/Clock;", "maxCountToUpload", "", "tracer-opentelemetry_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final TracerOpenTelemetrySpanExporter create(@NotNull Clock clock, int maxCountToUpload) {
            Intrinsics.checkNotNullParameter((Object)clock, (String)"clock");
            return new TracerOpenTelemetrySpanExporter(clock, maxCountToUpload, null);
        }

        public static /* synthetic */ TracerOpenTelemetrySpanExporter create$default(Companion companion, Clock clock, int n, int n2, Object object) {
            if ((n2 & 2) != 0) {
                n = 512;
            }
            return companion.create(clock, n);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

