/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.opentelemetry.export;

import io.opentelemetry.context.Context;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.trace.ReadWriteSpan;
import io.opentelemetry.sdk.trace.ReadableSpan;
import io.opentelemetry.sdk.trace.SpanProcessor;
import io.opentelemetry.sdk.trace.data.SpanData;
import io.opentelemetry.sdk.trace.export.SpanExporter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u0000  2\u00020\u0001:\u0002 !B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0016\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u000fH\u0016J\b\u0010\u0016\u001a\u00020\u0005H\u0016J\b\u0010\u0017\u001a\u00020\u0005H\u0016J\u0010\u0010\u0018\u001a\u00020\u00112\u0006\u0010\u0019\u001a\u00020\u001aH\u0016J\u0018\u0010\u001b\u001a\u00020\u00112\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u001eH\u0016J\b\u0010\u001f\u001a\u00020\u000fH\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lru/ok/tracer/opentelemetry/export/TracerOpenTelemetrySpanProcessor;", "Lio/opentelemetry/sdk/trace/SpanProcessor;", "exporter", "Lio/opentelemetry/sdk/trace/export/SpanExporter;", "completeToExport", "", "(Lio/opentelemetry/sdk/trace/export/SpanExporter;Z)V", "isShutdown", "Ljava/util/concurrent/atomic/AtomicBoolean;", "queues", "Ljava/util/concurrent/ConcurrentHashMap;", "", "Lru/ok/tracer/opentelemetry/export/TracerOpenTelemetrySpanProcessor$Record;", "results", "", "Lio/opentelemetry/sdk/common/CompletableResultCode;", "export", "", "spans", "", "Lio/opentelemetry/sdk/trace/data/SpanData;", "forceFlush", "isEndRequired", "isStartRequired", "onEnd", "span", "Lio/opentelemetry/sdk/trace/ReadableSpan;", "onStart", "parentContext", "Lio/opentelemetry/context/Context;", "Lio/opentelemetry/sdk/trace/ReadWriteSpan;", "shutdown", "Companion", "Record", "tracer-opentelemetry_release"})
public final class TracerOpenTelemetrySpanProcessor
implements SpanProcessor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpanExporter exporter;
    private final boolean completeToExport;
    @NotNull
    private final AtomicBoolean isShutdown;
    @NotNull
    private final Set<CompletableResultCode> results;
    @NotNull
    private final ConcurrentHashMap<String, Record> queues;

    public TracerOpenTelemetrySpanProcessor(@NotNull SpanExporter exporter, boolean completeToExport) {
        Intrinsics.checkNotNullParameter((Object)exporter, (String)"exporter");
        this.exporter = exporter;
        this.completeToExport = completeToExport;
        this.isShutdown = new AtomicBoolean();
        Set set = Collections.newSetFromMap(new ConcurrentHashMap());
        Intrinsics.checkNotNullExpressionValue(set, (String)"newSetFromMap(ConcurrentHashMap())");
        this.results = set;
        this.queues = new ConcurrentHashMap();
    }

    public void onStart(@NotNull Context parentContext, @NotNull ReadWriteSpan span) {
        Intrinsics.checkNotNullParameter((Object)parentContext, (String)"parentContext");
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        if (!this.completeToExport) {
            return;
        }
        String traceId = span.getSpanContext().getTraceId();
        ConcurrentMap $this$getOrPut$iv = this.queues;
        boolean $i$f$getOrPut = false;
        Object object = $this$getOrPut$iv.get(traceId);
        if (object == null) {
            boolean bl = false;
            Record default$iv = new Record();
            boolean bl2 = false;
            object = $this$getOrPut$iv.putIfAbsent(traceId, default$iv);
            if (object == null) {
                object = default$iv;
            }
        }
        Record record = (Record)object;
        record.getStartedCount().getAndIncrement();
    }

    public boolean isStartRequired() {
        return this.completeToExport;
    }

    public void onEnd(@NotNull ReadableSpan span) {
        Intrinsics.checkNotNullParameter((Object)span, (String)"span");
        List spans = null;
        if (this.completeToExport) {
            List endedSpans;
            String traceId = span.getSpanContext().getTraceId();
            Record record = this.queues.get(traceId);
            Intrinsics.checkNotNull((Object)record);
            Record record2 = record;
            List mutableSpans = null;
            while ((endedSpans = (List)record2.getEndedSpans().getAndSet(null)) == null) {
            }
            mutableSpans = endedSpans;
            ((Collection)mutableSpans).add(span.toSpanData());
            if (record2.getStartedCount().decrementAndGet() > 0) {
                record2.getEndedSpans().set(mutableSpans);
                return;
            }
            this.queues.remove(traceId);
            spans = mutableSpans;
        } else {
            spans = CollectionsKt.listOf((Object)span.toSpanData());
        }
        this.export(spans);
    }

    private final void export(List<? extends SpanData> spans) {
        CompletableResultCode result = this.exporter.export((Collection)spans);
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"result");
        this.results.add(result);
        result.whenComplete(() -> TracerOpenTelemetrySpanProcessor.export$lambda$1(this, result));
    }

    public boolean isEndRequired() {
        return true;
    }

    @NotNull
    public CompletableResultCode shutdown() {
        if (this.isShutdown.getAndSet(true)) {
            CompletableResultCode completableResultCode = CompletableResultCode.ofSuccess();
            Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofSuccess()");
            return completableResultCode;
        }
        CompletableResultCode result = new CompletableResultCode();
        CompletableResultCode flushResult = this.forceFlush();
        flushResult.whenComplete(() -> TracerOpenTelemetrySpanProcessor.shutdown$lambda$3(this, flushResult, result));
        return result;
    }

    @NotNull
    public CompletableResultCode forceFlush() {
        List spans = null;
        if (this.completeToExport) {
            List list;
            List $this$forceFlush_u24lambda_u244 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            Iterator iterator = ((Map)this.queues).entrySet().iterator();
            while (iterator.hasNext()) {
                List endedSpans;
                Record record = (Record)iterator.next().getValue();
                List mutableSpans = new ArrayList();
                while ((endedSpans = (List)record.getEndedSpans().getAndSet(null)) == null) {
                }
                CollectionsKt.addAll((Collection)mutableSpans, (Iterable)endedSpans);
                CollectionsKt.addAll((Collection)$this$forceFlush_u24lambda_u244, (Iterable)mutableSpans);
                mutableSpans.clear();
                record.getEndedSpans().set(mutableSpans);
            }
            spans = CollectionsKt.build((List)list);
        } else {
            spans = CollectionsKt.emptyList();
        }
        if (!((Collection)spans).isEmpty()) {
            this.export(spans);
        }
        CompletableResultCode completableResultCode = CompletableResultCode.ofAll((Collection)this.results);
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"ofAll(results)");
        return completableResultCode;
    }

    private static final void export$lambda$1(TracerOpenTelemetrySpanProcessor this$0, CompletableResultCode $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.results.remove($result);
    }

    private static final void shutdown$lambda$3$lambda$2(CompletableResultCode $flushResult, CompletableResultCode $shutdownResult, CompletableResultCode $result) {
        Intrinsics.checkNotNullParameter((Object)$flushResult, (String)"$flushResult");
        Intrinsics.checkNotNullParameter((Object)$shutdownResult, (String)"$shutdownResult");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        if (!$flushResult.isSuccess() || !$shutdownResult.isSuccess()) {
            $result.fail();
        } else {
            $result.succeed();
        }
    }

    private static final void shutdown$lambda$3(TracerOpenTelemetrySpanProcessor this$0, CompletableResultCode $flushResult, CompletableResultCode $result) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        Intrinsics.checkNotNullParameter((Object)$flushResult, (String)"$flushResult");
        Intrinsics.checkNotNullParameter((Object)$result, (String)"$result");
        CompletableResultCode completableResultCode = this$0.exporter.shutdown();
        Intrinsics.checkNotNullExpressionValue((Object)completableResultCode, (String)"exporter.shutdown()");
        CompletableResultCode shutdownResult = completableResultCode;
        shutdownResult.whenComplete(() -> TracerOpenTelemetrySpanProcessor.shutdown$lambda$3$lambda$2($flushResult, shutdownResult, $result));
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lru/ok/tracer/opentelemetry/export/TracerOpenTelemetrySpanProcessor$Companion;", "", "()V", "create", "Lio/opentelemetry/sdk/trace/SpanProcessor;", "exporter", "Lio/opentelemetry/sdk/trace/export/SpanExporter;", "completeToExport", "", "tracer-opentelemetry_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final SpanProcessor create(@NotNull SpanExporter exporter, boolean completeToExport) {
            Intrinsics.checkNotNullParameter((Object)exporter, (String)"exporter");
            return new TracerOpenTelemetrySpanProcessor(exporter, completeToExport);
        }

        public static /* synthetic */ SpanProcessor create$default(Companion companion, SpanExporter spanExporter, boolean bl, int n, Object object) {
            if ((n & 2) != 0) {
                bl = true;
            }
            return companion.create(spanExporter, bl);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R+\u0010\u0003\u001a\u001c\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0006 \u0007*\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00050\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lru/ok/tracer/opentelemetry/export/TracerOpenTelemetrySpanProcessor$Record;", "", "()V", "endedSpans", "Ljava/util/concurrent/atomic/AtomicReference;", "", "Lio/opentelemetry/sdk/trace/data/SpanData;", "kotlin.jvm.PlatformType", "getEndedSpans", "()Ljava/util/concurrent/atomic/AtomicReference;", "startedCount", "Ljava/util/concurrent/atomic/AtomicInteger;", "getStartedCount", "()Ljava/util/concurrent/atomic/AtomicInteger;", "tracer-opentelemetry_release"})
    public static final class Record {
        @NotNull
        private final AtomicInteger startedCount = new AtomicInteger();
        @NotNull
        private final AtomicReference<List<SpanData>> endedSpans = new AtomicReference<List>(new ArrayList());

        @NotNull
        public final AtomicInteger getStartedCount() {
            return this.startedCount;
        }

        @NotNull
        public final AtomicReference<List<SpanData>> getEndedSpans() {
            return this.endedSpans;
        }
    }
}

