/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.performance.metrics;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.performance.metrics.PerfSample;
import ru.ok.tracer.performance.metrics.PerformanceMetricsConfiguration;
import ru.ok.tracer.utils.Logger;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0001\u000eB\u000f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000b0\rR\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lru/ok/tracer/performance/metrics/PerfSamplesStorage;", "", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "maxSamples", "", "sampleCount", "add", "", "perfSample", "Lru/ok/tracer/performance/metrics/PerfSample;", "readAll", "", "Companion", "tracer-performance-metrics_release"})
public final class PerfSamplesStorage {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final File file;
    private final int maxSamples;
    private int sampleCount;
    private static final int ATTRIBUTE_TYPE_STRING = 1;
    private static final int ATTRIBUTE_TYPE_BOOLEAN = 2;
    private static final int ATTRIBUTE_TYPE_LONG = 3;
    private static final int ATTRIBUTE_TYPE_DOUBLE = 4;

    public PerfSamplesStorage(@Nullable File file) {
        this.file = file;
        this.maxSamples = PerformanceMetricsConfiguration.Companion.get$tracer_performance_metrics_release().getExperimentalMaxSamplesCount$tracer_performance_metrics_release();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void add(@NotNull PerfSample perfSample) {
        Intrinsics.checkNotNullParameter((Object)perfSample, (String)"perfSample");
        ++this.sampleCount;
        if (this.sampleCount > this.maxSamples) {
            Logger.e$default((String)("Max samples reached. " + this.sampleCount), null, (int)2, null);
            return;
        }
        if (this.file == null) {
            Logger.e$default((String)"No perf file", null, (int)2, null);
            return;
        }
        try {
            File file = this.file.getParentFile();
            if (file != null) {
                FileUtils.mkdirsChecked((File)file);
            }
            Closeable closeable = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(this.file, true)));
            Throwable throwable = null;
            try {
                DataOutputStream it = (DataOutputStream)closeable;
                boolean bl = false;
                PerfSamplesStorage.Companion.writePerfSample(it, perfSample);
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException ex) {
            Logger.e((String)("Couldn't persist " + perfSample.getName()), (Throwable)ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final List<PerfSample> readAll() {
        if (this.file == null) {
            Logger.e$default((String)"No perf file", null, (int)2, null);
            return CollectionsKt.emptyList();
        }
        try {
            Closeable closeable = new DataInputStream(new BufferedInputStream(new FileInputStream(this.file)));
            Throwable throwable = null;
            try {
                DataInputStream it = (DataInputStream)closeable;
                boolean bl = false;
                List list = PerfSamplesStorage.Companion.readPerfSamples(it);
                return list;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (IOException ex) {
            Logger.e((String)("Couldn't read persistent sample storage " + this.file), (Throwable)ex);
            return CollectionsKt.emptyList();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t*\u00020\u000bH\u0002J\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\nH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lru/ok/tracer/performance/metrics/PerfSamplesStorage$Companion;", "", "()V", "ATTRIBUTE_TYPE_BOOLEAN", "", "ATTRIBUTE_TYPE_DOUBLE", "ATTRIBUTE_TYPE_LONG", "ATTRIBUTE_TYPE_STRING", "readPerfSamples", "", "Lru/ok/tracer/performance/metrics/PerfSample;", "Ljava/io/DataInputStream;", "writePerfSample", "", "Ljava/io/DataOutputStream;", "perfSample", "tracer-performance-metrics_release"})
    public static final class Companion {
        private Companion() {
        }

        private final void writePerfSample(DataOutputStream $this$writePerfSample, PerfSample perfSample) {
            $this$writePerfSample.writeByte(3);
            $this$writePerfSample.writeLong(perfSample.getTimeUnixNano());
            $this$writePerfSample.writeUTF(perfSample.getName());
            $this$writePerfSample.writeLong(perfSample.getValue());
            $this$writePerfSample.writeUTF(perfSample.getUnit());
            $this$writePerfSample.writeInt(perfSample.getAttributes().size());
            for (Map.Entry<String, Object> entry : perfSample.getAttributes().entrySet()) {
                Object v;
                DataOutputStream dataOutputStream;
                String key = entry.getKey();
                Object value = entry.getValue();
                $this$writePerfSample.writeUTF(key);
                Object object = value;
                if (object instanceof Boolean) {
                    $this$writePerfSample.writeInt(2);
                    $this$writePerfSample.writeBoolean((Boolean)value);
                    continue;
                }
                if (((object instanceof Long ? true : object instanceof Integer) ? true : object instanceof Byte) ? true : object instanceof Short) {
                    $this$writePerfSample.writeInt(3);
                    Object object2 = value;
                    dataOutputStream = $this$writePerfSample;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Number");
                    dataOutputStream.writeLong(((Number)v).longValue());
                    continue;
                }
                if (object instanceof Double ? true : object instanceof Float) {
                    $this$writePerfSample.writeInt(4);
                    v = value;
                    dataOutputStream = $this$writePerfSample;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)v, (String)"null cannot be cast to non-null type kotlin.Number");
                    dataOutputStream.writeDouble(((Number)v).doubleValue());
                    continue;
                }
                $this$writePerfSample.writeInt(1);
                $this$writePerfSample.writeUTF(value.toString());
            }
        }

        private final List<PerfSample> readPerfSamples(DataInputStream $this$readPerfSamples) {
            int version;
            List list;
            List $this$readPerfSamples_u24lambda_u243 = list = CollectionsKt.createListBuilder();
            boolean bl = false;
            while ((version = $this$readPerfSamples.read()) == 3) {
                Map map;
                long timeUnixNano = $this$readPerfSamples.readLong();
                String name = $this$readPerfSamples.readUTF();
                long value = $this$readPerfSamples.readLong();
                String unit = $this$readPerfSamples.readUTF();
                Map $this$readPerfSamples_u24lambda_u243_u24lambda_u242 = map = MapsKt.createMapBuilder();
                boolean bl2 = false;
                int size = $this$readPerfSamples.readInt();
                for (int i = 0; i < size; ++i) {
                    Object object;
                    String key = $this$readPerfSamples.readUTF();
                    int type = $this$readPerfSamples.readInt();
                    Map map2 = $this$readPerfSamples_u24lambda_u243_u24lambda_u242;
                    switch (type) {
                        case 1: {
                            object = $this$readPerfSamples.readUTF();
                            break;
                        }
                        case 2: {
                            object = $this$readPerfSamples.readBoolean();
                            break;
                        }
                        case 3: {
                            object = $this$readPerfSamples.readLong();
                            break;
                        }
                        case 4: {
                            object = $this$readPerfSamples.readDouble();
                            break;
                        }
                        default: {
                            throw new IOException("Unsupported attribute value type " + type);
                        }
                    }
                    Object object2 = object;
                    map2.put(key, object2);
                }
                Map attributes = MapsKt.build((Map)map);
                Collection collection = $this$readPerfSamples_u24lambda_u243;
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"name");
                Intrinsics.checkNotNullExpressionValue((Object)unit, (String)"unit");
                collection.add(new PerfSample(timeUnixNano, name, value, unit, attributes));
            }
            return CollectionsKt.build((List)list);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

