/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.performance.metrics;

import android.content.Context;
import java.io.File;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerInitializer;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.performance.metrics.PerfSample;
import ru.ok.tracer.performance.metrics.PerfSamplesStorage;
import ru.ok.tracer.performance.metrics.PerfSamplesUploader;
import ru.ok.tracer.performance.metrics.PerformanceMetricsConfiguration;
import ru.ok.tracer.performance.metrics.TracerPerformanceMetrics;
import ru.ok.tracer.startup.Initializer;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;
import ru.ok.tracer.utils.TracerThreads;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u001a\u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\b\u0001\u0012\u0006\u0012\u0002\b\u00030\u00010\t0\bH\u0016\u00a8\u0006\n"}, d2={"Lru/ok/tracer/performance/metrics/PerformanceMetricsInitializer;", "Lru/ok/tracer/startup/Initializer;", "Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics;", "()V", "create", "context", "Landroid/content/Context;", "dependencies", "", "Ljava/lang/Class;", "tracer-performance-metrics_release"})
public final class PerformanceMetricsInitializer
implements Initializer<TracerPerformanceMetrics> {
    @NotNull
    public TracerPerformanceMetrics create(@NotNull Context context) {
        File perfDir;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Logger.d$default((String)"Performance metrics initialized!", null, (int)2, null);
        PerformanceMetricsConfiguration config = PerformanceMetricsConfiguration.Companion.get$tracer_performance_metrics_release();
        if (!config.getExperimentalEnabled$tracer_performance_metrics_release()) {
            Logger.d$default((String)"Performance metrics disabled", null, (int)2, null);
            return TracerPerformanceMetrics.INSTANCE;
        }
        try {
            perfDir = TracerFiles.INSTANCE.getTracerDir(context);
            File oldPerfFile = FilesKt.resolve((File)perfDir, (String)"perf-old.bin");
            File currentPerfFile = FilesKt.resolve((File)perfDir, (String)"perf-current.bin");
            if (oldPerfFile.exists()) {
                Logger.w$default((String)"Old perf file still exists! Delete it.", null, (int)2, null);
                FileUtils.deleteChecked((File)oldPerfFile);
            }
            if (currentPerfFile.exists()) {
                File file = oldPerfFile.getParentFile();
                if (file != null) {
                    FileUtils.mkdirsChecked((File)file);
                }
                FileUtils.renameToChecked((File)currentPerfFile, (File)oldPerfFile);
                TracerThreads.INSTANCE.runOnIo(() -> PerformanceMetricsInitializer.create$lambda$0(oldPerfFile));
            }
            Logger.d$default((String)"Perf storage file selected", null, (int)2, null);
            perfDir = currentPerfFile;
        }
        catch (Exception e) {
            Logger.e((Throwable)e);
            perfDir = null;
        }
        File perfSamplesStorageFile = perfDir;
        PerfSamplesStorage sampleStorage = new PerfSamplesStorage(perfSamplesStorageFile);
        TracerPerformanceMetrics.INSTANCE.attach$tracer_performance_metrics_release(sampleStorage);
        return TracerPerformanceMetrics.INSTANCE;
    }

    @NotNull
    public List<Class<? extends Initializer<?>>> dependencies() {
        return CollectionsKt.listOf(TracerInitializer.class);
    }

    private static final void create$lambda$0(File $oldPerfFile) {
        Intrinsics.checkNotNullParameter((Object)$oldPerfFile, (String)"$oldPerfFile");
        SystemState oldSystemState = Tracer.INSTANCE.getStateStorage().getPrevSystemState();
        if (oldSystemState != null) {
            PerfSamplesStorage oldStorage = new PerfSamplesStorage($oldPerfFile);
            Logger.d$default((String)"Read old perf samples", null, (int)2, null);
            List<PerfSample> samples = oldStorage.readAll();
            $oldPerfFile.delete();
            PerfSamplesUploader.INSTANCE.upload(samples, oldSystemState);
        }
    }
}

