/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.performance.metrics;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.base.time.PrecisionClock;
import ru.ok.tracer.base.ucum.UcumUtils;
import ru.ok.tracer.performance.metrics.PerfSample;
import ru.ok.tracer.performance.metrics.PerfSamplesStorage;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerThreads;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\u0005\u001a\u00020\u00062\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004H\u0000\u00a2\u0006\u0002\b\u0007JO\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2*\u0010\u000f\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u00110\u0010\"\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0011\u00a2\u0006\u0002\u0010\u0012JO\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2*\u0010\u000f\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u00110\u0010\"\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0011\u00a2\u0006\u0002\u0010\u0013J4\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0012\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u00010\u0014H\u0002R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics;", "", "()V", "sampleStorage", "Lru/ok/tracer/performance/metrics/PerfSamplesStorage;", "attach", "", "attach$tracer_performance_metrics_release", "sample", "name", "", "value", "", "unit", "Ljava/util/concurrent/TimeUnit;", "attributes", "", "Lkotlin/Pair;", "(Ljava/lang/String;JLjava/util/concurrent/TimeUnit;[Lkotlin/Pair;)V", "(Ljava/lang/String;JLjava/lang/String;[Lkotlin/Pair;)V", "", "tracer-performance-metrics_release"})
public final class TracerPerformanceMetrics {
    @NotNull
    public static final TracerPerformanceMetrics INSTANCE = new TracerPerformanceMetrics();
    @Nullable
    private static volatile PerfSamplesStorage sampleStorage;

    private TracerPerformanceMetrics() {
    }

    public final void attach$tracer_performance_metrics_release(@Nullable PerfSamplesStorage sampleStorage) {
        TracerPerformanceMetrics.sampleStorage = sampleStorage;
    }

    public final void sample(@NotNull String name, long value, @NotNull TimeUnit unit, Pair<String, ? extends Object> ... attributes) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.sample(name, value, UcumUtils.getToUcumString((TimeUnit)unit), MapsKt.mapOf(Arrays.copyOf(attributes, attributes.length)));
    }

    public final void sample(@NotNull String name, long value, @NotNull String unit, Pair<String, ? extends Object> ... attributes) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.sample(name, value, unit, MapsKt.mapOf(Arrays.copyOf(attributes, attributes.length)));
    }

    private final void sample(String name, long value, String unit, Map<String, ? extends Object> attributes) {
        PerfSamplesStorage sampleStorage = TracerPerformanceMetrics.sampleStorage;
        if (sampleStorage == null) {
            Logger.w$default((String)"Tracer not (yet) initialized", null, (int)2, null);
            return;
        }
        TracerThreads.INSTANCE.runInBgSequential(() -> TracerPerformanceMetrics.sample$lambda$0(name, value, unit, attributes, sampleStorage));
    }

    private static final void sample$lambda$0(String $name, long $value, String $unit, Map $attributes, PerfSamplesStorage $sampleStorage) {
        Intrinsics.checkNotNullParameter((Object)$name, (String)"$name");
        Intrinsics.checkNotNullParameter((Object)$unit, (String)"$unit");
        Intrinsics.checkNotNullParameter((Object)$attributes, (String)"$attributes");
        PerfSample perfSample = new PerfSample(PrecisionClock.currentTimeNanos(), $name, $value, $unit, $attributes);
        $sampleStorage.add(perfSample);
    }
}

