/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.performance.metrics;

import android.net.Uri;
import android.util.Log;
import java.io.Closeable;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.SystemStateSerializer;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.http.HttpRequest;
import ru.ok.tracer.base.http.HttpRequestBody;
import ru.ok.tracer.base.http.HttpResponse;
import ru.ok.tracer.base.http.HttpResponseBody;
import ru.ok.tracer.base.time.PrecisionClock;
import ru.ok.tracer.performance.metrics.FEATURE_PERFORMANCE_METRICSKt;
import ru.ok.tracer.performance.metrics.PerfSample;
import ru.ok.tracer.upload.NetworkResponseHandler;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.config.ConfigStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006H\u0002J\u001c\u0010\b\u001a\u00020\t2\f\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Lru/ok/tracer/performance/metrics/PerfSamplesUploader;", "", "()V", "toJson", "Lorg/json/JSONArray;", "samples", "", "Lru/ok/tracer/performance/metrics/PerfSample;", "upload", "", "systemState", "Lru/ok/tracer/SystemState;", "tracer-performance-metrics_release"})
public final class PerfSamplesUploader {
    @NotNull
    public static final PerfSamplesUploader INSTANCE = new PerfSamplesUploader();

    private PerfSamplesUploader() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void upload(@NotNull List<PerfSample> samples, @NotNull SystemState systemState) {
        Intrinsics.checkNotNullParameter(samples, (String)"samples");
        Intrinsics.checkNotNullParameter((Object)systemState, (String)"systemState");
        if (ConfigStorage.isLimited$default((ConfigStorage)ConfigStorage.INSTANCE, (TracerFeature)FEATURE_PERFORMANCE_METRICSKt.getFEATURE_PERFORMANCE_METRICS(), null, (int)2, null)) {
            Logger.d$default((String)"Performance metrics limited", null, (int)2, null);
            return;
        }
        if (samples.isEmpty()) {
            Logger.d$default((String)"No samples to upload", null, (int)2, null);
            return;
        }
        var3_3 = new Object[]{samples.size()};
        Logger.d((String)"Upload perf samples. %s", (Object[])var3_3);
        appToken = Tracer.INSTANCE.getAppToken();
        if (appToken == null) {
            Logger.w$default((String)"No app token", null, (int)2, null);
            return;
        }
        $this$upload_u24lambda_u240 = var5_4 = SystemStateSerializer.INSTANCE.toJsonObject(systemState);
        $i$a$-apply-PerfSamplesUploader$upload$bodyJsonObject$1 = false;
        $this$upload_u24lambda_u240.put("clientTimeUnixNano", PrecisionClock.currentTimeNanos());
        $this$upload_u24lambda_u240.put("samples", (Object)PerfSamplesUploader.INSTANCE.toJson(samples));
        bodyJsonObject = var5_4;
        p0 = CoreTracerConfiguration.Companion.get().getApiUrl();
        $i$a$-let-PerfSamplesUploader$upload$url$1 = false;
        v0 = Uri.parse((String)p0).buildUpon().appendEncodedPath("api/perf/upload").appendQueryParameter("crashToken", appToken).toString();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"CoreTracerConfiguration.\u2026)\n            .toString()");
        url = v0;
        v1 = bodyJsonObject.toString();
        Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"bodyJsonObject.toString()");
        request = new HttpRequest(url, HttpRequestBody.Companion.fromString$default((HttpRequestBody.Companion)HttpRequestBody.Companion, (String)"application/json; charset=utf-8", (String)v1, null, (int)4, null));
        try {
            $i$a$-apply-PerfSamplesUploader$upload$bodyJsonObject$1 = (Closeable)Tracer.INSTANCE.getHttpClient().execute(request);
            var8_10 = null;
            try {
                response = (HttpResponse)$i$a$-apply-PerfSamplesUploader$upload$bodyJsonObject$1;
                $i$a$-use-PerfSamplesUploader$upload$1 = false;
                responseCode = response.getStatusCode();
                v2 = response.getBody();
                responseContentType = v2 != null ? v2.getContentType() : null;
                v3 /* !! */  = response.getBody();
                if (v3 /* !! */  == null) ** GOTO lbl-1000
                v4 = v3 /* !! */ .getBytes();
                v3 /* !! */  = (HttpResponseBody)v4;
                if (v4 != null) {
                    v5 = StringsKt.decodeToString((byte[])v3 /* !! */ );
                } else lbl-1000:
                // 2 sources

                {
                    v5 = null;
                }
                responseContent = v5;
                NetworkResponseHandler.universalHandleResponse$default((NetworkResponseHandler)NetworkResponseHandler.INSTANCE, (String)responseContentType, (String)responseContent, (String)FEATURE_PERFORMANCE_METRICSKt.getFEATURE_PERFORMANCE_METRICS().getName(), null, (int)8, null);
                if (responseCode != 200) {
                    v6 = Log.e((String)"Tracer", (String)("HTTP " + responseCode + ", " + responseContent));
                } else {
                    var14_19 = new Object[]{"Result: " + responseContent};
                    Logger.d((String)"Tracer", (Object[])var14_19);
                    v6 = Unit.INSTANCE;
                }
                var9_12 = v6;
            }
            catch (Throwable var9_13) {
                var8_10 = var9_13;
                throw var9_13;
            }
            finally {
                CloseableKt.closeFinally((Closeable)$i$a$-apply-PerfSamplesUploader$upload$bodyJsonObject$1, (Throwable)var8_10);
            }
        }
        catch (Exception ex) {
            Logger.e((Throwable)ex);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final JSONArray toJson(List<PerfSample> samples) {
        JSONArray jSONArray;
        JSONArray $this$toJson_u24lambda_u244 = jSONArray = new JSONArray();
        boolean bl = false;
        for (PerfSample sample : samples) {
            void $this$toJson_u24lambda_u244_u24lambda_u243;
            JSONObject jSONObject;
            JSONObject jSONObject2 = jSONObject = new JSONObject();
            JSONArray jSONArray2 = $this$toJson_u24lambda_u244;
            boolean bl2 = false;
            $this$toJson_u24lambda_u244_u24lambda_u243.put("timeUnixNano", sample.getTimeUnixNano());
            $this$toJson_u24lambda_u244_u24lambda_u243.put("name", (Object)sample.getName());
            $this$toJson_u24lambda_u244_u24lambda_u243.put("value", sample.getValue());
            $this$toJson_u24lambda_u244_u24lambda_u243.put("unit", (Object)sample.getUnit());
            if (!sample.getAttributes().isEmpty()) {
                JSONObject jSONObject3;
                JSONObject jSONObject4 = jSONObject3 = new JSONObject();
                String string = "attributes";
                void var14_14 = $this$toJson_u24lambda_u244_u24lambda_u243;
                boolean bl3 = false;
                for (Map.Entry<String, Object> entry : sample.getAttributes().entrySet()) {
                    void $this$toJson_u24lambda_u244_u24lambda_u243_u24lambda_u242;
                    String key = entry.getKey();
                    Object value = entry.getValue();
                    Object object = value;
                    if (object instanceof String) {
                        $this$toJson_u24lambda_u244_u24lambda_u243_u24lambda_u242.put(key, value);
                        continue;
                    }
                    if (object instanceof Boolean) {
                        $this$toJson_u24lambda_u244_u24lambda_u243_u24lambda_u242.put(key, ((Boolean)value).booleanValue());
                        continue;
                    }
                    if (object instanceof Long) {
                        $this$toJson_u24lambda_u244_u24lambda_u243_u24lambda_u242.put(key, ((Number)value).longValue());
                        continue;
                    }
                    if (object instanceof Double) {
                        $this$toJson_u24lambda_u244_u24lambda_u243_u24lambda_u242.put(key, ((Number)value).doubleValue());
                        continue;
                    }
                    if (object instanceof Byte) {
                        $this$toJson_u24lambda_u244_u24lambda_u243_u24lambda_u242.put(key, value);
                        continue;
                    }
                    if (object instanceof Short) {
                        $this$toJson_u24lambda_u244_u24lambda_u243_u24lambda_u242.put(key, value);
                        continue;
                    }
                    if (object instanceof Integer) {
                        $this$toJson_u24lambda_u244_u24lambda_u243_u24lambda_u242.put(key, ((Number)value).intValue());
                        continue;
                    }
                    if (object instanceof Float) {
                        $this$toJson_u24lambda_u244_u24lambda_u243_u24lambda_u242.put(key, value);
                        continue;
                    }
                    $this$toJson_u24lambda_u244_u24lambda_u243_u24lambda_u242.put(key, (Object)value.toString());
                }
                Unit unit = Unit.INSTANCE;
                var14_14.put(string, (Object)jSONObject3);
            }
            jSONArray2.put((Object)jSONObject);
        }
        return jSONArray;
    }
}

