/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.performance.metrics;

import android.content.Context;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.MapsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.base.io.FileUtils;
import ru.ok.tracer.base.time.PrecisionClock;
import ru.ok.tracer.base.ucum.UcumUtils;
import ru.ok.tracer.performance.metrics.PerfSample;
import ru.ok.tracer.performance.metrics.PerfSamplesStorage;
import ru.ok.tracer.performance.metrics.PerfSamplesUploader;
import ru.ok.tracer.performance.metrics.PerformanceMetricsConfiguration;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;
import ru.ok.tracer.utils.TracerThreads;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001dB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0015\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\tJ\u0010\u0010\n\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002JO\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112*\u0010\u0012\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u00140\u0013\"\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u0014\u00a2\u0006\u0002\u0010\u0015JO\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2*\u0010\u0012\u001a\u0016\u0012\u0012\b\u0001\u0012\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u00140\u0013\"\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u0014\u00a2\u0006\u0002\u0010\u0016J4\u0010\u000b\u001a\u00020\u00062\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\r2\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\r\u0012\u0004\u0012\u00020\u00010\u0017H\u0002J\u0010\u0010\u0018\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u00062\u0006\u0010\u001b\u001a\u00020\u001cH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics;", "", "()V", "state", "Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State;", "attach", "", "context", "Landroid/content/Context;", "attach$tracer_performance_metrics_release", "initOnBgSequential", "sample", "name", "", "value", "", "unit", "Ljava/util/concurrent/TimeUnit;", "attributes", "", "Lkotlin/Pair;", "(Ljava/lang/String;JLjava/util/concurrent/TimeUnit;[Lkotlin/Pair;)V", "(Ljava/lang/String;JLjava/lang/String;[Lkotlin/Pair;)V", "", "sampleOnBgSequential", "Lru/ok/tracer/performance/metrics/PerfSample;", "uploadOnIo", "file", "Ljava/io/File;", "State", "tracer-performance-metrics_release"})
public final class TracerPerformanceMetrics {
    @NotNull
    public static final TracerPerformanceMetrics INSTANCE = new TracerPerformanceMetrics();
    @NotNull
    private static volatile State state = State.None.INSTANCE;

    private TracerPerformanceMetrics() {
    }

    public final void attach$tracer_performance_metrics_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PerformanceMetricsConfiguration config = PerformanceMetricsConfiguration.Companion.get$tracer_performance_metrics_release();
        if (!config.getExperimentalEnabled$tracer_performance_metrics_release()) {
            Logger.d$default((String)"Performance metrics disabled", null, (int)2, null);
            return;
        }
        state = new State.Initializing();
        this.initOnBgSequential(context);
    }

    private final void initOnBgSequential(Context context) {
        TracerThreads.INSTANCE.runInBgSequential(() -> TracerPerformanceMetrics.initOnBgSequential$lambda$0(context));
    }

    private final void uploadOnIo(File file) {
        TracerThreads.INSTANCE.runOnIo(() -> TracerPerformanceMetrics.uploadOnIo$lambda$1(file));
    }

    public final void sample(@NotNull String name, long value, @NotNull TimeUnit unit, Pair<String, ? extends Object> ... attributes) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.sample(name, value, UcumUtils.getToUcumString((TimeUnit)unit), MapsKt.mapOf(Arrays.copyOf(attributes, attributes.length)));
    }

    public final void sample(@NotNull String name, long value, @NotNull String unit, Pair<String, ? extends Object> ... attributes) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter((Object)unit, (String)"unit");
        Intrinsics.checkNotNullParameter(attributes, (String)"attributes");
        this.sample(name, value, unit, MapsKt.mapOf(Arrays.copyOf(attributes, attributes.length)));
    }

    private final void sample(String name, long value, String unit, Map<String, ? extends Object> attributes) {
        State state = TracerPerformanceMetrics.state;
        if (Intrinsics.areEqual((Object)state, (Object)State.None.INSTANCE)) {
            Logger.w$default((String)"Tracer not (yet) initialized. Sample dropped", null, (int)2, null);
        } else if (Intrinsics.areEqual((Object)state, (Object)State.Broken.INSTANCE)) {
            Logger.w$default((String)"Performance Metrics storage broken. Sample dropped", null, (int)2, null);
        } else {
            this.sampleOnBgSequential(new PerfSample(PrecisionClock.currentTimeNanos(), name, value, unit, attributes));
        }
    }

    private final void sampleOnBgSequential(PerfSample sample) {
        TracerThreads.INSTANCE.runInBgSequential(() -> TracerPerformanceMetrics.sampleOnBgSequential$lambda$2(sample));
    }

    private static final void initOnBgSequential$lambda$0(Context $context) {
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        try {
            Logger.d$default((String)"Performance metrics initializing", null, (int)2, null);
            File dir = TracerFiles.INSTANCE.getTracerDir($context);
            File oldFile = FilesKt.resolve((File)dir, (String)"perf-old.bin");
            File file = FilesKt.resolve((File)dir, (String)"perf-current.bin");
            if (oldFile.exists()) {
                Logger.w$default((String)"Old perf file still exists! Delete it.", null, (int)2, null);
                FileUtils.deleteChecked((File)oldFile);
            }
            if (file.exists()) {
                File file2 = oldFile.getParentFile();
                if (file2 != null) {
                    FileUtils.mkdirsChecked((File)file2);
                }
                FileUtils.renameToChecked((File)file, (File)oldFile);
                INSTANCE.uploadOnIo(oldFile);
            }
            PerfSamplesStorage samplesStorage = new PerfSamplesStorage(file);
            State prevState = state;
            if (prevState instanceof State.Initializing) {
                samplesStorage.addAll((Iterable<PerfSample>)((State.Initializing)prevState).getQueue());
            } else {
                Logger.w$default((String)("Unexpected PerformanceMetrics state " + state + ". Continuing"), null, (int)2, null);
            }
            state = new State.Ready(samplesStorage);
            Logger.d$default((String)"Performance metrics initialized!", null, (int)2, null);
        }
        catch (Exception e) {
            Logger.e((String)"Performance metrics broken", (Throwable)e);
            state = State.Broken.INSTANCE;
        }
    }

    private static final void uploadOnIo$lambda$1(File $file) {
        Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
        SystemState oldSystemState = Tracer.INSTANCE.getStateStorage().getPrevSystemState();
        if (oldSystemState != null) {
            PerfSamplesStorage oldStorage = new PerfSamplesStorage($file);
            List<PerfSample> samples = oldStorage.readAll();
            $file.delete();
            PerfSamplesUploader.INSTANCE.upload(samples, oldSystemState);
        }
    }

    private static final void sampleOnBgSequential$lambda$2(PerfSample $sample) {
        Intrinsics.checkNotNullParameter((Object)$sample, (String)"$sample");
        State state = TracerPerformanceMetrics.state;
        if (state instanceof State.Initializing) {
            ((State.Initializing)state).getQueue().add($sample);
        } else if (state instanceof State.Ready) {
            ((State.Ready)state).getStorage().add($sample);
        } else {
            Logger.w$default((String)("Unexpected PerformanceMetrics state " + state + ". Sample dropped"), null, (int)2, null);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001:\u0004\u0002\u0003\u0004\u0005\u0082\u0001\u0004\u0006\u0007\b\t\u00a8\u0006\n"}, d2={"Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State;", "", "Broken", "Initializing", "None", "Ready", "Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State$Broken;", "Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State$Initializing;", "Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State$None;", "Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State$Ready;", "tracer-performance-metrics_release"})
    private static interface State {

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State$None;", "Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State;", "()V", "tracer-performance-metrics_release"})
        public static final class None
        implements State {
            @NotNull
            public static final None INSTANCE = new None();

            private None() {
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R\u0017\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State$Initializing;", "Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State;", "()V", "queue", "", "Lru/ok/tracer/performance/metrics/PerfSample;", "getQueue", "()Ljava/util/Collection;", "tracer-performance-metrics_release"})
        public static final class Initializing
        implements State {
            @NotNull
            private final Collection<PerfSample> queue = new LinkedList();

            @NotNull
            public final Collection<PerfSample> getQueue() {
                return this.queue;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State$Ready;", "Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State;", "storage", "Lru/ok/tracer/performance/metrics/PerfSamplesStorage;", "(Lru/ok/tracer/performance/metrics/PerfSamplesStorage;)V", "getStorage", "()Lru/ok/tracer/performance/metrics/PerfSamplesStorage;", "tracer-performance-metrics_release"})
        public static final class Ready
        implements State {
            @NotNull
            private final PerfSamplesStorage storage;

            public Ready(@NotNull PerfSamplesStorage storage) {
                Intrinsics.checkNotNullParameter((Object)storage, (String)"storage");
                this.storage = storage;
            }

            @NotNull
            public final PerfSamplesStorage getStorage() {
                return this.storage;
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State$Broken;", "Lru/ok/tracer/performance/metrics/TracerPerformanceMetrics$State;", "()V", "tracer-performance-metrics_release"})
        public static final class Broken
        implements State {
            @NotNull
            public static final Broken INSTANCE = new Broken();

            private Broken() {
            }
        }
    }
}

