/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.profiler.sampling;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Debug;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.annotation.WorkerThread;
import java.io.File;
import java.io.IOException;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.profiler.sampling.FEATURE_SAMPLED_TRACEKt;
import ru.ok.tracer.profiler.sampling.SamplingProfilerConfiguration;
import ru.ok.tracer.upload.SampleUploader;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;
import ru.ok.tracer.utils.TracerThreads;
import ru.ok.tracer.utils.config.ConfigStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0004!\"#$B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u000b\u001a\u00020\fH\u0007J\u0012\u0010\r\u001a\u00020\f2\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0007J\u0015\u0010\u0010\u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0011J\b\u0010\u0012\u001a\u00020\fH\u0003J\u0018\u0010\u0013\u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u001a\u0010\u0017\u001a\u00020\f2\u0006\u0010\u0018\u001a\u00020\u00192\b\b\u0002\u0010\u000e\u001a\u00020\u000fH\u0003J \u0010\u001a\u001a\u00020\f2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u0011\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001fH\u0083\bJ \u0010 \u001a\u00020\f2\u0006\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0018\u0010 \u001a\u00020\f2\u0006\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0015\u001a\u00020\u0016H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b8C@CX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u0002\u00a8\u0006%"}, d2={"Lru/ok/tracer/profiler/sampling/SamplingProfiler;", "", "()V", "context", "Landroid/content/Context;", "mainHandler", "Landroid/os/Handler;", "<set-?>", "Lru/ok/tracer/profiler/sampling/SamplingProfiler$State;", "state", "getState$annotations", "abort", "", "commit", "tagSuffix", "", "init", "init$tracer_profiler_sampling_release", "onFinish", "onStart", "tag", "duration", "", "onStop", "send", "", "onUpload", "sampleFile", "Ljava/io/File;", "runOnMain", "runnable", "Ljava/lang/Runnable;", "start", "Finished", "InProgress", "None", "State", "tracer-profiler-sampling_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class SamplingProfiler {
    @NotNull
    public static final SamplingProfiler INSTANCE = new SamplingProfiler();
    private static Context context;
    @NotNull
    private static final Handler mainHandler;
    @NotNull
    private static State state;

    private SamplingProfiler() {
    }

    private static /* synthetic */ void getState$annotations() {
    }

    public final void init$tracer_profiler_sampling_release(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        SamplingProfiler.context = context;
    }

    @Deprecated(message="Replace with start(tag, duration)", replaceWith=@ReplaceWith(expression="this.start(tag, duration)", imports={}))
    @JvmStatic
    @AnyThread
    public static final void start(@NotNull Context context, @NotNull String tag, long duration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        SamplingProfiler.start(tag, duration);
    }

    @JvmStatic
    @AnyThread
    public static final void start(@NotNull String tag, long duration) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (Tracer.isDisabled()) {
            Logger.d$default((String)"Tracer is disabled", null, (int)2, null);
            return;
        }
        SamplingProfiler samplingProfiler = INSTANCE;
        Runnable runnable$iv = () -> SamplingProfiler.start$lambda$0(tag, duration);
        boolean $i$f$runOnMain = false;
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable$iv.run();
        } else {
            mainHandler.post(runnable$iv);
        }
    }

    @JvmStatic
    @AnyThread
    @JvmOverloads
    public static final void commit(@NotNull String tagSuffix) {
        Intrinsics.checkNotNullParameter((Object)tagSuffix, (String)"tagSuffix");
        SamplingProfiler samplingProfiler = INSTANCE;
        Runnable runnable$iv = () -> SamplingProfiler.commit$lambda$1(tagSuffix);
        boolean $i$f$runOnMain = false;
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable$iv.run();
        } else {
            mainHandler.post(runnable$iv);
        }
    }

    public static /* synthetic */ void commit$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        SamplingProfiler.commit(string);
    }

    @JvmStatic
    @AnyThread
    public static final void abort() {
        SamplingProfiler samplingProfiler = INSTANCE;
        Runnable runnable$iv = SamplingProfiler::abort$lambda$2;
        boolean $i$f$runOnMain = false;
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable$iv.run();
        } else {
            mainHandler.post(runnable$iv);
        }
    }

    @MainThread
    private final void onStart(String tag, long duration) {
        File file;
        SamplingProfilerConfiguration config = SamplingProfilerConfiguration.Companion.get$tracer_profiler_sampling_release();
        if (!config.getEnabled()) {
            Logger.d$default((String)"SamplingProfiler: disabled", null, (int)2, null);
            return;
        }
        if (!Intrinsics.areEqual((Object)state, (Object)None.INSTANCE)) {
            Logger.d$default((String)"SamplingProfiler: Is in progress", null, (int)2, null);
            return;
        }
        if (ConfigStorage.INSTANCE.isLimited(FEATURE_SAMPLED_TRACEKt.getFEATURE_SAMPLED_TRACE(), tag)) {
            Logger.d$default((String)"SamplingProfiler: Limited", null, (int)2, null);
            return;
        }
        long startRealtime = SystemClock.elapsedRealtime();
        Object[] objectArray = new Object[]{startRealtime};
        Logger.d((String)"SamplingProfiler: Is running.. Started at %s", (Object[])objectArray);
        try {
            Context context = SamplingProfiler.context;
            if (context == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"context");
                context = null;
            }
            file = TracerFiles.INSTANCE.getNewSampleFile(context, FEATURE_SAMPLED_TRACEKt.getFEATURE_SAMPLED_TRACE(), ".trace");
        }
        catch (IOException e) {
            Logger.e((String)"SamplingProfiler: Failed to get sample file.", (Throwable)e);
            return;
        }
        File sampleFile = file;
        int bufferSize = config.getBufferSizeMb();
        int intervalUs = config.getSamplingIntervalUs();
        Logger.d$default((String)("Sampling run config: " + sampleFile.getPath() + ", " + bufferSize + ", " + intervalUs), null, (int)2, null);
        Debug.startMethodTracingSampling((String)sampleFile.getPath(), (int)bufferSize, (int)intervalUs);
        state = new InProgress(sampleFile, tag, duration, startRealtime);
        mainHandler.postDelayed(SamplingProfiler::onStart$lambda$3, duration);
    }

    @MainThread
    private final void onFinish() {
        State state = SamplingProfiler.state;
        if (state instanceof None) {
            throw new IllegalStateException("Cannot finish");
        }
        if (state instanceof Finished) {
            return;
        }
        if (state instanceof InProgress) {
            // empty if block
        }
        Debug.stopMethodTracing();
        State state2 = SamplingProfiler.state;
        Intrinsics.checkNotNull((Object)state2, (String)"null cannot be cast to non-null type ru.ok.tracer.profiler.sampling.SamplingProfiler.InProgress");
        InProgress state3 = (InProgress)state2;
        SamplingProfiler.state = new Finished(state3.getSampleFile(), state3.getTag(), RangesKt.coerceAtMost((long)state3.getRequestedDuration(), (long)(SystemClock.elapsedRealtime() - state3.getStartRealtime())));
    }

    @MainThread
    private final void onStop(boolean send, String tagSuffix) {
        mainHandler.removeCallbacksAndMessages(null);
        State state = SamplingProfiler.state;
        if (state instanceof None) {
            Logger.w$default((String)"SamplingProfiler: Profiling not started", null, (int)2, null);
            return;
        }
        if (state instanceof InProgress) {
            Logger.d$default((String)("SamplingProfiler: Profiling in progress and will be stopped. Need commit result = " + send), null, (int)2, null);
            this.onFinish();
        } else if (state instanceof Finished) {
            Logger.d$default((String)("SamplingProfiler: Profiling already ended and now computing result. Need send = " + send), null, (int)2, null);
        }
        State state2 = SamplingProfiler.state;
        Intrinsics.checkNotNull((Object)state2, (String)"null cannot be cast to non-null type ru.ok.tracer.profiler.sampling.SamplingProfiler.Finished");
        Finished state3 = (Finished)state2;
        if (Tracer.isDisabled()) {
            Logger.d$default((String)"Tracer is disabled", null, (int)2, null);
        } else if (send) {
            TracerThreads.INSTANCE.runOnIo(() -> SamplingProfiler.onStop$lambda$4(state3, tagSuffix));
        }
        SamplingProfiler.state = None.INSTANCE;
    }

    static /* synthetic */ void onStop$default(SamplingProfiler samplingProfiler, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        samplingProfiler.onStop(bl, string);
    }

    @WorkerThread
    private final void onUpload(File sampleFile, String tag, long duration) {
        Context context = SamplingProfiler.context;
        if (context == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"context");
            context = null;
        }
        SampleUploader.upload$default((SampleUploader)SampleUploader.INSTANCE, (Context)context, (TracerFeature)FEATURE_SAMPLED_TRACEKt.getFEATURE_SAMPLED_TRACE(), (File)sampleFile, (boolean)false, (String)tag, (Long)duration, null, (int)72, null);
    }

    @AnyThread
    private final void runOnMain(Runnable runnable) {
        boolean $i$f$runOnMain = false;
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable.run();
        } else {
            mainHandler.post(runnable);
        }
    }

    @JvmStatic
    @AnyThread
    @JvmOverloads
    public static final void commit() {
        SamplingProfiler.commit$default(null, 1, null);
    }

    private static final void start$lambda$0(String $tag, long $duration) {
        Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
        INSTANCE.onStart($tag, $duration);
    }

    private static final void commit$lambda$1(String $tagSuffix) {
        Intrinsics.checkNotNullParameter((Object)$tagSuffix, (String)"$tagSuffix");
        INSTANCE.onStop(true, $tagSuffix);
    }

    private static final void abort$lambda$2() {
        SamplingProfiler.onStop$default(INSTANCE, false, null, 2, null);
    }

    private static final void onStart$lambda$3() {
        INSTANCE.onFinish();
    }

    private static final void onStop$lambda$4(Finished $state, String $tagSuffix) {
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$tagSuffix, (String)"$tagSuffix");
        File sampleFile = $state.getSampleFile();
        long duration = $state.getDuration();
        String tag = ((CharSequence)$tagSuffix).length() == 0 ? $state.getTag() : $state.getTag() + '_' + $tagSuffix;
        INSTANCE.onUpload(sampleFile, tag, duration);
    }

    static {
        mainHandler = new Handler(Looper.getMainLooper());
        state = None.INSTANCE;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\br\u0018\u00002\u00020\u0001\u0082\u0001\u0003\u0002\u0003\u0004\u00a8\u0006\u0005"}, d2={"Lru/ok/tracer/profiler/sampling/SamplingProfiler$State;", "", "Lru/ok/tracer/profiler/sampling/SamplingProfiler$Finished;", "Lru/ok/tracer/profiler/sampling/SamplingProfiler$InProgress;", "Lru/ok/tracer/profiler/sampling/SamplingProfiler$None;", "tracer-profiler-sampling_release"})
    private static interface State {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lru/ok/tracer/profiler/sampling/SamplingProfiler$None;", "Lru/ok/tracer/profiler/sampling/SamplingProfiler$State;", "()V", "tracer-profiler-sampling_release"})
    private static final class None
    implements State {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\n\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0011"}, d2={"Lru/ok/tracer/profiler/sampling/SamplingProfiler$InProgress;", "Lru/ok/tracer/profiler/sampling/SamplingProfiler$State;", "sampleFile", "Ljava/io/File;", "tag", "", "requestedDuration", "", "startRealtime", "(Ljava/io/File;Ljava/lang/String;JJ)V", "getRequestedDuration", "()J", "getSampleFile", "()Ljava/io/File;", "getStartRealtime", "getTag", "()Ljava/lang/String;", "tracer-profiler-sampling_release"})
    private static final class InProgress
    implements State {
        @NotNull
        private final File sampleFile;
        @NotNull
        private final String tag;
        private final long requestedDuration;
        private final long startRealtime;

        public InProgress(@NotNull File sampleFile, @NotNull String tag, long requestedDuration, long startRealtime) {
            Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.sampleFile = sampleFile;
            this.tag = tag;
            this.requestedDuration = requestedDuration;
            this.startRealtime = startRealtime;
        }

        @NotNull
        public final File getSampleFile() {
            return this.sampleFile;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public final long getRequestedDuration() {
            return this.requestedDuration;
        }

        public final long getStartRealtime() {
            return this.startRealtime;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lru/ok/tracer/profiler/sampling/SamplingProfiler$Finished;", "Lru/ok/tracer/profiler/sampling/SamplingProfiler$State;", "sampleFile", "Ljava/io/File;", "tag", "", "duration", "", "(Ljava/io/File;Ljava/lang/String;J)V", "getDuration", "()J", "getSampleFile", "()Ljava/io/File;", "getTag", "()Ljava/lang/String;", "tracer-profiler-sampling_release"})
    private static final class Finished
    implements State {
        @NotNull
        private final File sampleFile;
        @NotNull
        private final String tag;
        private final long duration;

        public Finished(@NotNull File sampleFile, @NotNull String tag, long duration) {
            Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.sampleFile = sampleFile;
            this.tag = tag;
            this.duration = duration;
        }

        @NotNull
        public final File getSampleFile() {
            return this.sampleFile;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public final long getDuration() {
            return this.duration;
        }
    }
}

