/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.profiler.systrace;

import android.annotation.SuppressLint;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.SystemClock;
import androidx.annotation.AnyThread;
import androidx.annotation.MainThread;
import androidx.annotation.WorkerThread;
import java.io.File;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.profiler.systrace.FEATURE_SYSTRACEKt;
import ru.ok.tracer.profiler.systrace.SystraceHook;
import ru.ok.tracer.profiler.systrace.SystraceProfiler;
import ru.ok.tracer.profiler.systrace.SystraceProfilerConfiguration;
import ru.ok.tracer.upload.SampleUploader;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerThreads;
import ru.ok.tracer.utils.config.ConfigStorage;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u00c7\u0002\u0018\u00002\u00020\u0001:\u0005\u001e\u001f !\"B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\t\u001a\u00020\nH\u0007J\u0012\u0010\u000b\u001a\u00020\n2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\u0018\u0010\u000e\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\u001a\u0010\u0012\u001a\u00020\n2\u0006\u0010\u0013\u001a\u00020\u00142\b\b\u0002\u0010\f\u001a\u00020\rH\u0003J(\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0003J\u0011\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0083\bJ \u0010\u001d\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007J\u0018\u0010\u001d\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u0011H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u00068C@CX\u0082\u000e\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002\u00a8\u0006#"}, d2={"Lru/ok/tracer/profiler/systrace/SystraceProfiler;", "", "()V", "mainHandler", "Landroid/os/Handler;", "<set-?>", "Lru/ok/tracer/profiler/systrace/SystraceProfiler$State;", "state", "getState$annotations", "abort", "", "commit", "tagSuffix", "", "onStart", "tag", "duration", "", "onStop", "send", "", "onUpload", "context", "Landroid/content/Context;", "sampleFile", "Ljava/io/File;", "runOnMain", "runnable", "Ljava/lang/Runnable;", "start", "Finished", "InProgress", "None", "Preparing", "State", "tracer-profiler-systrace_release"})
@SuppressLint(value={"StaticFieldLeak"})
public final class SystraceProfiler {
    @NotNull
    public static final SystraceProfiler INSTANCE = new SystraceProfiler();
    @NotNull
    private static final Handler mainHandler = new Handler(Looper.getMainLooper());
    @NotNull
    private static State state = None.INSTANCE;

    private SystraceProfiler() {
    }

    private static /* synthetic */ void getState$annotations() {
    }

    @Deprecated(message="Replace with start(tag, duration)", replaceWith=@ReplaceWith(expression="this.start(tag, duration)", imports={}))
    @JvmStatic
    @AnyThread
    public static final void start(@NotNull Context context, @NotNull String tag, long duration) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        SystraceProfiler.start(tag, duration);
    }

    @JvmStatic
    @AnyThread
    public static final void start(@NotNull String tag, long duration) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (Tracer.isDisabled()) {
            Logger.d$default((String)"Tracer is disabled", null, (int)2, null);
            return;
        }
        SystraceProfiler systraceProfiler = INSTANCE;
        Runnable runnable$iv = () -> SystraceProfiler.start$lambda$0(tag, duration);
        boolean $i$f$runOnMain = false;
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable$iv.run();
        } else {
            SystraceProfiler.mainHandler.post(runnable$iv);
        }
    }

    @JvmStatic
    @AnyThread
    @JvmOverloads
    public static final void commit(@NotNull String tagSuffix) {
        Intrinsics.checkNotNullParameter((Object)tagSuffix, (String)"tagSuffix");
        if (Tracer.isDisabled()) {
            Logger.d$default((String)"Tracer is disabled", null, (int)2, null);
            return;
        }
        SystraceProfiler systraceProfiler = INSTANCE;
        Runnable runnable$iv = () -> SystraceProfiler.commit$lambda$1(tagSuffix);
        boolean $i$f$runOnMain = false;
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable$iv.run();
        } else {
            SystraceProfiler.mainHandler.post(runnable$iv);
        }
    }

    public static /* synthetic */ void commit$default(String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = "";
        }
        SystraceProfiler.commit(string);
    }

    @JvmStatic
    @AnyThread
    public static final void abort() {
        if (Tracer.isDisabled()) {
            Logger.d$default((String)"Tracer is disabled", null, (int)2, null);
            return;
        }
        SystraceProfiler systraceProfiler = INSTANCE;
        Runnable runnable$iv = SystraceProfiler::abort$lambda$2;
        boolean $i$f$runOnMain = false;
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable$iv.run();
        } else {
            SystraceProfiler.mainHandler.post(runnable$iv);
        }
    }

    @MainThread
    private final void onStart(String tag, long duration) {
        Context context;
        try {
            context = Tracer.INSTANCE.getContext();
        }
        catch (IllegalStateException ex) {
            Logger.e$default((String)"Tracer is not initialized", null, (int)2, null);
            return;
        }
        Context context2 = context;
        SystraceProfilerConfiguration config = SystraceProfilerConfiguration.Companion.get$tracer_profiler_systrace_release();
        if (!config.getEnabled()) {
            Logger.d$default((String)"SystraceProfiler: disabled", null, (int)2, null);
            return;
        }
        if (!Intrinsics.areEqual((Object)state, (Object)None.INSTANCE)) {
            Logger.d$default((String)"SystraceProfiler: Is in progress", null, (int)2, null);
            return;
        }
        if (ConfigStorage.INSTANCE.isLimited(FEATURE_SYSTRACEKt.getFEATURE_SYSTRACE(), tag)) {
            Logger.d$default((String)"SystraceProfiler: Limited", null, (int)2, null);
            return;
        }
        if (!SystraceHook.INSTANCE.install(true)) {
            Logger.d$default((String)"SystraceProfiler: Can't install hook", null, (int)2, null);
            return;
        }
        long startRealtime = SystemClock.elapsedRealtime();
        SystraceHook.TraceListener traceListener2 = new SystraceHook.TraceListener(duration, startRealtime, tag){
            final /* synthetic */ long $duration;
            final /* synthetic */ long $startRealtime;
            final /* synthetic */ String $tag;
            {
                this.$duration = $duration;
                this.$startRealtime = $startRealtime;
                this.$tag = $tag;
            }

            public void onStart(@NotNull Thread execThread, @NotNull Runnable stopRunnable) {
                Intrinsics.checkNotNullParameter((Object)execThread, (String)"execThread");
                Intrinsics.checkNotNullParameter((Object)stopRunnable, (String)"stopRunnable");
                Logger.d$default((String)"SystraceProfiler: started", null, (int)2, null);
                SystraceProfiler systraceProfiler = SystraceProfiler.INSTANCE;
                Runnable runnable$iv = () -> onStart.traceListener.1.onStart$lambda$0(execThread, stopRunnable);
                boolean $i$f$runOnMain = false;
                if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
                    runnable$iv.run();
                } else {
                    SystraceProfiler.access$getMainHandler$p().post(runnable$iv);
                }
                SystraceProfiler.access$getMainHandler$p().postDelayed(stopRunnable, this.$duration);
            }

            public void onFinish(@NotNull File file) {
                Intrinsics.checkNotNullParameter((Object)file, (String)"file");
                long realDuration = RangesKt.coerceAtMost((long)this.$duration, (long)(SystemClock.elapsedRealtime() - this.$startRealtime));
                Object object = new Object[]{realDuration};
                Logger.d((String)"SystraceProfiler: Is ended. Duration: %s", (Object[])object);
                object = SystraceProfiler.INSTANCE;
                Runnable runnable$iv = () -> onStart.traceListener.1.onFinish$lambda$1(file, this.$tag, realDuration);
                boolean $i$f$runOnMain = false;
                if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
                    runnable$iv.run();
                } else {
                    SystraceProfiler.access$getMainHandler$p().post(runnable$iv);
                }
            }

            private static final void onStart$lambda$0(Thread $execThread, Runnable $stopRunnable) {
                Intrinsics.checkNotNullParameter((Object)$execThread, (String)"$execThread");
                Intrinsics.checkNotNullParameter((Object)$stopRunnable, (String)"$stopRunnable");
                SystraceProfiler.access$setState$p(new InProgress($execThread, $stopRunnable));
            }

            private static final void onFinish$lambda$1(File $file, String $tag, long $realDuration) {
                Intrinsics.checkNotNullParameter((Object)$file, (String)"$file");
                Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
                SystraceProfiler.access$setState$p(new Finished($file, $tag, $realDuration));
            }
        };
        SystraceHook.INSTANCE.start(context2, traceListener2);
        state = Preparing.INSTANCE;
    }

    @MainThread
    private final void onStop(boolean send, String tagSuffix) {
        Context context;
        try {
            context = Tracer.INSTANCE.getContext();
        }
        catch (IllegalStateException ex) {
            Logger.e$default((String)"Tracer is not initialized", null, (int)2, null);
            return;
        }
        Context context2 = context;
        State state = SystraceProfiler.state;
        if (Intrinsics.areEqual((Object)state, (Object)None.INSTANCE)) {
            return;
        }
        if (Intrinsics.areEqual((Object)state, (Object)Preparing.INSTANCE)) {
            return;
        }
        if (state instanceof InProgress) {
            Logger.d$default((String)("SystraceProfiler: Profiling in progress and will be stopped. Need commit result = " + send), null, (int)2, null);
            mainHandler.removeCallbacksAndMessages(null);
            ((InProgress)state).getStopRunnable().run();
            TracerThreads.INSTANCE.runOnIo(() -> SystraceProfiler.onStop$lambda$4(state, send, tagSuffix));
        } else if (state instanceof Finished) {
            Logger.d$default((String)("SystraceProfiler: Profiling already ended and now computing result. Need send = " + send), null, (int)2, null);
            if (Tracer.isDisabled()) {
                Logger.d$default((String)"Tracer is disabled", null, (int)2, null);
            } else if (send) {
                TracerThreads.INSTANCE.runOnIo(() -> SystraceProfiler.onStop$lambda$5(state, tagSuffix, context2));
            }
            SystraceProfiler.state = None.INSTANCE;
        }
    }

    static /* synthetic */ void onStop$default(SystraceProfiler systraceProfiler, boolean bl, String string, int n, Object object) {
        if ((n & 2) != 0) {
            string = "";
        }
        systraceProfiler.onStop(bl, string);
    }

    @WorkerThread
    private final void onUpload(Context context, File sampleFile, String tag, long duration) {
        SampleUploader.upload$default((SampleUploader)SampleUploader.INSTANCE, (Context)context, (TracerFeature)FEATURE_SYSTRACEKt.getFEATURE_SYSTRACE(), (File)sampleFile, (boolean)false, (String)tag, (Long)duration, null, null, (int)200, null);
    }

    @AnyThread
    private final void runOnMain(Runnable runnable) {
        boolean $i$f$runOnMain = false;
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable.run();
        } else {
            SystraceProfiler.mainHandler.post(runnable);
        }
    }

    @JvmStatic
    @AnyThread
    @JvmOverloads
    public static final void commit() {
        SystraceProfiler.commit$default(null, 1, null);
    }

    private static final void start$lambda$0(String $tag, long $duration) {
        Intrinsics.checkNotNullParameter((Object)$tag, (String)"$tag");
        INSTANCE.onStart($tag, $duration);
    }

    private static final void commit$lambda$1(String $tagSuffix) {
        Intrinsics.checkNotNullParameter((Object)$tagSuffix, (String)"$tagSuffix");
        INSTANCE.onStop(true, $tagSuffix);
    }

    private static final void abort$lambda$2() {
        SystraceProfiler.onStop$default(INSTANCE, false, null, 2, null);
    }

    private static final void onStop$lambda$4$lambda$3(boolean $send, String $tagSuffix) {
        Intrinsics.checkNotNullParameter((Object)$tagSuffix, (String)"$tagSuffix");
        INSTANCE.onStop($send, $tagSuffix);
    }

    private static final void onStop$lambda$4(State $state, boolean $send, String $tagSuffix) {
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$tagSuffix, (String)"$tagSuffix");
        ((InProgress)$state).getExecThread().join();
        SystraceProfiler systraceProfiler = INSTANCE;
        Runnable runnable$iv = () -> SystraceProfiler.onStop$lambda$4$lambda$3($send, $tagSuffix);
        boolean $i$f$runOnMain = false;
        if (Intrinsics.areEqual((Object)Looper.myLooper(), (Object)Looper.getMainLooper())) {
            runnable$iv.run();
        } else {
            SystraceProfiler.mainHandler.post(runnable$iv);
        }
    }

    private static final void onStop$lambda$5(State $state, String $tagSuffix, Context $context) {
        Intrinsics.checkNotNullParameter((Object)$state, (String)"$state");
        Intrinsics.checkNotNullParameter((Object)$tagSuffix, (String)"$tagSuffix");
        Intrinsics.checkNotNullParameter((Object)$context, (String)"$context");
        File sampleFile = ((Finished)$state).getSampleFile();
        long duration = ((Finished)$state).getDuration();
        String tag = ((CharSequence)$tagSuffix).length() == 0 ? ((Finished)$state).getTag() : ((Finished)$state).getTag() + '_' + $tagSuffix;
        INSTANCE.onUpload($context, sampleFile, tag, duration);
    }

    public static final /* synthetic */ void access$setState$p(State state) {
        SystraceProfiler.state = state;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\bb\u0018\u00002\u00020\u0001\u00a8\u0006\u0002"}, d2={"Lru/ok/tracer/profiler/systrace/SystraceProfiler$State;", "", "tracer-profiler-systrace_release"})
    private static interface State {
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lru/ok/tracer/profiler/systrace/SystraceProfiler$None;", "Lru/ok/tracer/profiler/systrace/SystraceProfiler$State;", "()V", "tracer-profiler-systrace_release"})
    private static final class None
    implements State {
        @NotNull
        public static final None INSTANCE = new None();

        private None() {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c2\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lru/ok/tracer/profiler/systrace/SystraceProfiler$Preparing;", "Lru/ok/tracer/profiler/systrace/SystraceProfiler$State;", "()V", "tracer-profiler-systrace_release"})
    private static final class Preparing
    implements State {
        @NotNull
        public static final Preparing INSTANCE = new Preparing();

        private Preparing() {
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Lru/ok/tracer/profiler/systrace/SystraceProfiler$InProgress;", "Lru/ok/tracer/profiler/systrace/SystraceProfiler$State;", "execThread", "Ljava/lang/Thread;", "stopRunnable", "Ljava/lang/Runnable;", "(Ljava/lang/Thread;Ljava/lang/Runnable;)V", "getExecThread", "()Ljava/lang/Thread;", "getStopRunnable", "()Ljava/lang/Runnable;", "tracer-profiler-systrace_release"})
    private static final class InProgress
    implements State {
        @NotNull
        private final Thread execThread;
        @NotNull
        private final Runnable stopRunnable;

        public InProgress(@NotNull Thread execThread, @NotNull Runnable stopRunnable) {
            Intrinsics.checkNotNullParameter((Object)execThread, (String)"execThread");
            Intrinsics.checkNotNullParameter((Object)stopRunnable, (String)"stopRunnable");
            this.execThread = execThread;
            this.stopRunnable = stopRunnable;
        }

        @NotNull
        public final Thread getExecThread() {
            return this.execThread;
        }

        @NotNull
        public final Runnable getStopRunnable() {
            return this.stopRunnable;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\b\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lru/ok/tracer/profiler/systrace/SystraceProfiler$Finished;", "Lru/ok/tracer/profiler/systrace/SystraceProfiler$State;", "sampleFile", "Ljava/io/File;", "tag", "", "duration", "", "(Ljava/io/File;Ljava/lang/String;J)V", "getDuration", "()J", "getSampleFile", "()Ljava/io/File;", "getTag", "()Ljava/lang/String;", "tracer-profiler-systrace_release"})
    private static final class Finished
    implements State {
        @NotNull
        private final File sampleFile;
        @NotNull
        private final String tag;
        private final long duration;

        public Finished(@NotNull File sampleFile, @NotNull String tag, long duration) {
            Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
            Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
            this.sampleFile = sampleFile;
            this.tag = tag;
            this.duration = duration;
        }

        @NotNull
        public final File getSampleFile() {
            return this.sampleFile;
        }

        @NotNull
        public final String getTag() {
            return this.tag;
        }

        public final long getDuration() {
            return this.duration;
        }
    }
}

