/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.profiler.systrace;

import android.content.Context;
import android.os.Build;
import android.os.Trace;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.concurrent.atomic.AtomicInteger;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.profiler.systrace.FEATURE_SYSTRACEKt;
import ru.ok.tracer.profiler.systrace.SystraceHook;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0019\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u00042\u0006\u0010\u0011\u001a\u00020\u000bH\u0082 J\u000e\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0011\u001a\u00020\u000bJ\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0082 J\u0016\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bJ\b\u0010\u001c\u001a\u00020\u0014H\u0002J\t\u0010\u001d\u001a\u00020\u0014H\u0082 R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\fR\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lru/ok/tracer/profiler/systrace/SystraceHook;", "", "()V", "STATE_IDLE", "", "STATE_INSTALLED", "STATE_INSTALLING", "STATE_INSTALL_FAILED", "STATE_STARTED", "STATE_UNHOOKED", "isInstalled", "", "()Z", "state", "Ljava/util/concurrent/atomic/AtomicInteger;", "hook", "sdkVersion", "startRecord", "install", "process", "", "path", "", "start", "context", "Landroid/content/Context;", "traceListener", "Lru/ok/tracer/profiler/systrace/SystraceHook$TraceListener;", "stopProcess", "unhook", "TraceListener", "tracer-profiler-systrace_release"})
public final class SystraceHook {
    @NotNull
    public static final SystraceHook INSTANCE = new SystraceHook();
    private static final int STATE_IDLE = 0;
    private static final int STATE_INSTALLING = 1;
    private static final int STATE_INSTALLED = 2;
    private static final int STATE_STARTED = 3;
    private static final int STATE_UNHOOKED = 4;
    private static final int STATE_INSTALL_FAILED = 5;
    @NotNull
    private static final AtomicInteger state = new AtomicInteger(0);

    private SystraceHook() {
    }

    public final boolean isInstalled() {
        return state.get() == 2;
    }

    public final boolean install(boolean startRecord) {
        if (!state.compareAndSet(0, 1)) {
            Logger.d$default((String)"Skip install tracer. Not first attempt.", null, (int)2, null);
            return false;
        }
        try {
            System.loadLibrary("trhook2");
        }
        catch (UnsatisfiedLinkError e) {
            state.set(5);
            return false;
        }
        Method nativeGetEnabledTags = null;
        try {
            nativeGetEnabledTags = Trace.class.getDeclaredMethod("nativeGetEnabledTags", new Class[0]);
            nativeGetEnabledTags.setAccessible(true);
        }
        catch (NoSuchMethodException e) {
            nativeGetEnabledTags = null;
        }
        Field sEnabledTags = null;
        try {
            sEnabledTags = Trace.class.getDeclaredField("sEnabledTags");
            sEnabledTags.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            sEnabledTags = null;
        }
        if ((nativeGetEnabledTags == null || sEnabledTags == null) && Build.VERSION.SDK_INT < 35) {
            state.set(5);
            return false;
        }
        Logger.d$default((String)"Hooking...", null, (int)2, null);
        if (!this.hook(Build.VERSION.SDK_INT, startRecord)) {
            state.set(5);
            return false;
        }
        if (nativeGetEnabledTags != null && sEnabledTags != null) {
            try {
                sEnabledTags.set(null, nativeGetEnabledTags.invoke(null, new Object[0]));
            }
            catch (Exception e) {
                Logger.e((String)"Hook trace failed", (Throwable)e);
                state.set(5);
                return false;
            }
        }
        Logger.d$default((String)"Installed", null, (int)2, null);
        state.set(2);
        return true;
    }

    public final void start(@NotNull Context context, @NotNull TraceListener traceListener2) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)traceListener2, (String)"traceListener");
        if (!state.compareAndSet(2, 3)) {
            Logger.d$default((String)("Wrong state: " + state.get()), null, (int)2, null);
            return;
        }
        Thread executingThread2 = new Thread(context, traceListener2){
            final /* synthetic */ Context $context;
            final /* synthetic */ TraceListener $traceListener;
            {
                this.$context = $context;
                this.$traceListener = $traceListener;
                super("Tracer-systrace");
            }

            public void run() {
                File file;
                try {
                    file = TracerFiles.getNewSampleFile$default((TracerFiles)TracerFiles.INSTANCE, (Context)this.$context, (TracerFeature)FEATURE_SYSTRACEKt.getFEATURE_SYSTRACE(), null, (int)4, null);
                }
                catch (IOException e) {
                    Logger.e((String)"Systrace: Failed to get sample file.", (Throwable)e);
                    return;
                }
                File file2 = file;
                Logger.d$default((String)"Systrace: Processing...", null, (int)2, null);
                this.$traceListener.onStart(this, start.executingThread.1::run$lambda$0);
                String string = file2.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.toString()");
                SystraceHook.access$process(SystraceHook.INSTANCE, string);
                Logger.d$default((String)"Systrace: Processing stopped. Execute consumer", null, (int)2, null);
                this.$traceListener.onFinish(file2);
                Logger.d$default((String)"Systrace: Write finished.", null, (int)2, null);
            }

            private static final void run$lambda$0() {
                Logger.d$default((String)"Systrace: Send stop.", null, (int)2, null);
                SystraceHook.access$stopProcess(SystraceHook.INSTANCE);
            }
        };
        executingThread2.start();
    }

    private final void stopProcess() {
        block3: while (true) {
            int s = state.get();
            switch (s) {
                case 2: 
                case 3: {
                    if (!state.compareAndSet(s, 4)) continue block3;
                    this.unhook();
                    state.compareAndSet(4, 0);
                    return;
                }
            }
            break;
        }
        Logger.d$default((String)("Systrace: Wrong state: " + state.get()), null, (int)2, null);
    }

    private final native boolean hook(int var1, boolean var2);

    private final native void process(String var1);

    private final native void unhook();

    public static final /* synthetic */ void access$process(SystraceHook $this, String path) {
        $this.process(path);
    }

    public static final /* synthetic */ void access$stopProcess(SystraceHook $this) {
        $this.stopProcess();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&J\u0018\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH&\u00a8\u0006\u000b"}, d2={"Lru/ok/tracer/profiler/systrace/SystraceHook$TraceListener;", "", "onFinish", "", "file", "Ljava/io/File;", "onStart", "execThread", "Ljava/lang/Thread;", "stopRunnable", "Ljava/lang/Runnable;", "tracer-profiler-systrace_release"})
    public static interface TraceListener {
        public void onStart(@NotNull Thread var1, @NotNull Runnable var2);

        public void onFinish(@NotNull File var1);
    }
}

