/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.upload;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import java.io.File;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.compat.PackageInfoCompat;
import ru.ok.tracer.base.compat.PackageManagerCompat;
import ru.ok.tracer.upload.SampleUploadWorker;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010$\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J[\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\b\u0002\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0012\u00a2\u0006\u0002\u0010\u0013\u00a8\u0006\u0014"}, d2={"Lru/ok/tracer/upload/SampleUploader;", "", "()V", "upload", "", "context", "Landroid/content/Context;", "feature", "Lru/ok/tracer/TracerFeature;", "sampleFile", "Ljava/io/File;", "useGzip", "", "tag", "", "attr1", "", "customProperties", "", "(Landroid/content/Context;Lru/ok/tracer/TracerFeature;Ljava/io/File;ZLjava/lang/String;Ljava/lang/Long;Ljava/util/Map;)V", "tracer-sample-upload_release"})
public final class SampleUploader {
    @NotNull
    public static final SampleUploader INSTANCE = new SampleUploader();

    private SampleUploader() {
    }

    public final void upload(@NotNull Context context, @NotNull TracerFeature feature, @NotNull File sampleFile, boolean useGzip, @Nullable String tag, @Nullable Long attr1, @NotNull Map<String, String> customProperties) {
        Constraints.Builder builder;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
        Intrinsics.checkNotNullParameter(customProperties, (String)"customProperties");
        PackageManager packageManager = context.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"context.packageManager");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        Data data = SampleUploadWorker.Companion.createData(feature, sampleFile, useGzip, tag, attr1, PackageInfoCompat.getLongVersionCodeCompat((PackageInfo)PackageManagerCompat.getPackageInfoCompat((PackageManager)packageManager, (String)string, (int)0)), customProperties);
        Constraints.Builder $this$upload_u24lambda_u240 = builder = new Constraints.Builder();
        boolean bl = false;
        if (!CoreTracerConfiguration.Companion.get().getDebugUpload()) {
            if (Build.VERSION.SDK_INT >= 23) {
                $this$upload_u24lambda_u240.setRequiresDeviceIdle(true);
            }
            $this$upload_u24lambda_u240.setRequiredNetworkType(NetworkType.UNMETERED);
            $this$upload_u24lambda_u240.setRequiresBatteryNotLow(true);
        }
        Constraints constraints = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Builder()\n            .a\u2026   }\n            .build()");
        Constraints constraints2 = constraints;
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(SampleUploadWorker.class).setConstraints(constraints2)).setInputData(data)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(SampleUploadWork\u2026ata)\n            .build()");
        OneTimeWorkRequest request = (OneTimeWorkRequest)workRequest;
        WorkManager.getInstance((Context)context).enqueue((WorkRequest)request);
    }

    public static /* synthetic */ void upload$default(SampleUploader sampleUploader, Context context, TracerFeature tracerFeature, File file, boolean bl, String string, Long l, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            l = null;
        }
        if ((n & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        sampleUploader.upload(context, tracerFeature, file, bl, string, l, map);
    }
}

