/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.upload;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.util.Log;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.compat.PackageInfoCompat;
import ru.ok.tracer.base.compat.PackageManagerCompat;
import ru.ok.tracer.base.http.HttpMultipartBodyBuilder;
import ru.ok.tracer.base.http.HttpRequest;
import ru.ok.tracer.base.http.HttpRequestBody;
import ru.ok.tracer.base.http.HttpResponse;
import ru.ok.tracer.base.http.HttpResponseBody;
import ru.ok.tracer.upload.NetworkResponseHandler;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\n\u0010\u0013\u001a\u0004\u0018\u00010\bH\u0002J \u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0018H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001b"}, d2={"Lru/ok/tracer/upload/SampleUploadWorker;", "Landroidx/work/Worker;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "featureName", "", "getFeatureName", "()Ljava/lang/String;", "tag", "getTag", "tagLimit", "", "getTagLimit", "()I", "doWork", "Landroidx/work/ListenableWorker$Result;", "getUploadToken", "uploadFile", "", "uploadToken", "sampleFile", "Ljava/io/File;", "tmpFile", "Companion", "tracer-sample-upload_release"})
public final class SampleUploadWorker
extends Worker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PARAM_FEATURE_NAME = "tracer_feature_name";
    @NotNull
    private static final String PARAM_FEATURE_USE_GZIP = "tracer_feature_uze_gzip";
    @NotNull
    private static final String PARAM_SAMPLE_FILE_PATH = "tracer_sample_file_path";
    @NotNull
    private static final String PARAM_FEATURE_TAG = "tracer_feature_tag";
    @NotNull
    private static final String PARAM_FEATURE_TAG_LIMIT = "tracer_feature_tag_limit";
    @NotNull
    private static final String PARAM_VERSION_CODE = "tracer_version_code";
    @NotNull
    private static final String PARAM_ATTR1 = "tracer_attr1";
    @NotNull
    private static final String PARAM_HAS_ATTR1 = "tracer_has_attr1";
    @NotNull
    private static final String PARAM_CUSTOM_PROPERTIES_KEYS = "tracer_custom_properties_keys";

    public SampleUploadWorker(@NotNull Context context, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(context, workerParams);
    }

    private final String getFeatureName() {
        String string = this.getInputData().getString(PARAM_FEATURE_NAME);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String getTag() {
        return this.getInputData().getString(PARAM_FEATURE_TAG);
    }

    private final int getTagLimit() {
        return this.getInputData().getInt(PARAM_FEATURE_TAG_LIMIT, -1);
    }

    @NotNull
    public ListenableWorker.Result doWork() {
        File tmpFile = null;
        File sampleFile = null;
        try {
            String string = this.getInputData().getString(PARAM_SAMPLE_FILE_PATH);
            Intrinsics.checkNotNull((Object)string);
            sampleFile = new File(string);
            if (!sampleFile.exists()) {
                Logger.w$default((String)("sample file not exists with path: " + sampleFile.getPath()), null, (int)2, null);
                ListenableWorker.Result result = ListenableWorker.Result.success();
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
                return result;
            }
            long sampleVersionCode = this.getInputData().getLong(PARAM_VERSION_CODE, 0L);
            PackageManager packageManager = this.getApplicationContext().getPackageManager();
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"applicationContext.packageManager");
            String string2 = this.getApplicationContext().getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"applicationContext.packageName");
            long currentVersionCode = PackageInfoCompat.getLongVersionCodeCompat((PackageInfo)PackageManagerCompat.getPackageInfoCompat((PackageManager)packageManager, (String)string2, (int)0));
            if (currentVersionCode != sampleVersionCode) {
                Object[] objectArray = new Object[]{sampleVersionCode, currentVersionCode};
                Logger.d((String)"Version code mismatch. Old: %s, New: %s", (Object[])objectArray);
                sampleFile.delete();
                ListenableWorker.Result result = ListenableWorker.Result.success();
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
                return result;
            }
            String uploadToken = this.getUploadToken();
            if (uploadToken != null) {
                Context context = this.getApplicationContext();
                Intrinsics.checkNotNullExpressionValue((Object)context, (String)"applicationContext");
                String string3 = this.getId().toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"id.toString()");
                tmpFile = TracerFiles.INSTANCE.createTempFile(context, string3);
                this.uploadFile(uploadToken, sampleFile, tmpFile);
            }
        }
        catch (Exception e) {
            if (tmpFile != null && tmpFile.exists()) {
                tmpFile.delete();
            }
            if (sampleFile != null && sampleFile.exists()) {
                sampleFile.delete();
            }
            Logger.e((Throwable)e);
        }
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void uploadFile(String uploadToken, File sampleFile, File tmpFile) {
        featureUseGzip = this.getInputData().getBoolean("tracer_feature_uze_gzip", true);
        if (featureUseGzip) {
            inStream = new BufferedInputStream(new FileInputStream(sampleFile));
            outStream = new GZIPOutputStream(new BufferedOutputStream(new FileOutputStream(tmpFile)));
            var7_7 = (Closeable)inStream;
            var8_8 = null;
            try {
                inStr = (BufferedInputStream)var7_7;
                $i$a$-use-SampleUploadWorker$uploadFile$1 = false;
                var12_22 = outStream;
                var13_24 = null;
                try {
                    outStr = (GZIPOutputStream)var12_22;
                    $i$a$-use-SampleUploadWorker$uploadFile$1$1 = false;
                    outStr = ByteStreamsKt.copyTo$default((InputStream)inStr, (OutputStream)outStr, (int)0, (int)2, null);
                }
                catch (Throwable outStr) {
                    var13_24 = outStr;
                    throw outStr;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)var12_22, (Throwable)var13_24);
                }
                inStr = outStr;
            }
            catch (Throwable inStr) {
                var8_8 = inStr;
                throw inStr;
            }
            finally {
                CloseableKt.closeFinally((Closeable)var7_7, (Throwable)var8_8);
            }
        }
        FilesKt.copyTo$default((File)sampleFile, (File)tmpFile, (boolean)true, (int)0, (int)4, null);
        inStream = new Object[]{sampleFile.length(), tmpFile.length()};
        Logger.d((String)"Sample size: %s. Upload size: %s", (Object[])inStream);
        sampleFile.delete();
        content = FilesKt.readBytes((File)tmpFile);
        p0 = CoreTracerConfiguration.Companion.get().getApiUrl();
        $i$a$-let-SampleUploadWorker$uploadFile$url$1 = false;
        v0 = Uri.parse((String)p0).buildUpon().appendEncodedPath("api/sample/upload").appendQueryParameter("uploadToken", uploadToken).toString();
        Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"CoreTracerConfiguration.\u2026)\n            .toString()");
        url = v0;
        this_$iv /* !! */  = HttpMultipartBodyBuilder.Companion;
        $i$f$build = false;
        $i$a$-let-SampleUploadWorker$uploadFile$url$1 = new HttpMultipartBodyBuilder();
        var12_22 = $i$a$-let-SampleUploadWorker$uploadFile$url$1;
        var19_33 = url;
        $i$a$-build-SampleUploadWorker$uploadFile$request$1 = false;
        $this$uploadFile_u24lambda_u242.add("file", "sample", HttpRequestBody.Companion.fromBytes("application/octet-stream", content));
        var20_34 = $i$a$-let-SampleUploadWorker$uploadFile$url$1.build();
        var21_35 = var19_33;
        request = new HttpRequest(var21_35, var20_34);
        try {
            this_$iv /* !! */  = (Closeable)Tracer.INSTANCE.getHttpClient().execute(request);
            var9_17 = null;
            try {
                it = (HttpResponse)this_$iv /* !! */ ;
                $i$a$-use-SampleUploadWorker$uploadFile$2 = false;
                responseCode = it.getStatusCode();
                responseMessage = it.getMessage();
                v1 = it.getBody();
                responseContentType = v1 != null ? v1.getContentType() : null;
                v2 /* !! */  = it.getBody();
                if (v2 /* !! */  == null) ** GOTO lbl-1000
                v3 = v2 /* !! */ .getBytes();
                v2 /* !! */  = (HttpResponseBody)v3;
                if (v3 != null) {
                    v4 = StringsKt.decodeToString((byte[])v2 /* !! */ );
                } else lbl-1000:
                // 2 sources

                {
                    v4 = null;
                }
                responseBody = v4;
                NetworkResponseHandler.INSTANCE.universalHandleResponse(responseContentType, responseBody, this.getFeatureName(), this.getTag());
                if (responseCode != 200) {
                    v5 = Log.e((String)"Tracer", (String)(responseMessage + " , " + responseBody));
                } else {
                    var18_37 = new Object[]{"Result: " + responseBody};
                    Logger.d((String)"Tracer", (Object[])var18_37);
                    v5 = Unit.INSTANCE;
                }
                var11_19 = v5;
            }
            catch (Throwable var11_20) {
                var9_17 = var11_20;
                throw var11_20;
            }
            finally {
                CloseableKt.closeFinally((Closeable)this_$iv /* !! */ , (Throwable)var9_17);
            }
        }
        catch (Exception e) {
            Logger.e((Throwable)e);
        }
        finally {
            tmpFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getUploadToken() {
        Map properties;
        String appToken = Tracer.INSTANCE.getAppToken();
        if (appToken == null) {
            Logger.w$default((String)"No app token", null, (int)2, null);
            return null;
        }
        SystemState systemState = Tracer.INSTANCE.getStateStorage().getCurrentSystemState();
        String[] propertiesKeys = this.getInputData().getStringArray(PARAM_CUSTOM_PROPERTIES_KEYS);
        JSONObject json = new JSONObject();
        json.put("versionName", (Object)systemState.getVersionName());
        json.put("versionCode", systemState.getVersionCode());
        json.put("buildUuid", (Object)systemState.getBuildUuid());
        json.put("sessionUuid", (Object)systemState.getSessionUuid());
        json.put("deviceId", (Object)systemState.getDeviceId());
        json.put("feature", (Object)this.getFeatureName());
        if (this.getInputData().getBoolean(PARAM_HAS_ATTR1, false)) {
            json.put("attr1", this.getInputData().getLong(PARAM_ATTR1, 0L));
        }
        if (this.getTag() != null) {
            json.put("tag", (Object)this.getTag());
        }
        Map customProperties = new LinkedHashMap();
        if (propertiesKeys != null) {
            String[] $this$forEach$iv = propertiesKeys;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                String throwable;
                String it = throwable = $this$forEach$iv[i];
                boolean bl = false;
                String value = this.getInputData().getString(it);
                if (value == null) continue;
                Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                customProperties.put(it, value);
            }
        }
        if (!(properties = MapsKt.plus((Map)systemState.getProperties(), (Map)customProperties)).isEmpty()) {
            JSONObject jsonProperties = new JSONObject();
            Map $this$forEach$iv = properties;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry element$iv2;
                Map.Entry it = element$iv2 = iterator.next();
                boolean bl = false;
                jsonProperties.put((String)it.getKey(), it.getValue());
            }
            json.put("properties", (Object)jsonProperties);
        }
        String string = CoreTracerConfiguration.Companion.get().getApiUrl();
        boolean bl = false;
        String string2 = Uri.parse((String)string).buildUpon().appendEncodedPath("api/sample/initUpload").appendQueryParameter("sampleToken", appToken).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"CoreTracerConfiguration.\u2026)\n            .toString()");
        String url = string2;
        String string3 = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"json.toString()");
        HttpRequest request = new HttpRequest(url, HttpRequestBody.Companion.fromString$default((HttpRequestBody.Companion)HttpRequestBody.Companion, (String)"application/json; charset=utf-8", (String)string3, null, (int)4, null));
        Object object = new Object[]{url.toString(), json.toString()};
        Logger.d((String)"Url: %s Args: %s", (Object[])object);
        object = (Closeable)Tracer.INSTANCE.getHttpClient().execute(request);
        Throwable throwable = null;
        try {
            HttpResponse response = (HttpResponse)object;
            boolean bl2 = false;
            HttpResponseBody responseBody = response.getBody();
            if (responseBody != null) {
                JSONObject jsonObject = new JSONObject(StringsKt.decodeToString((byte[])responseBody.getBytes()));
                NetworkResponseHandler.INSTANCE.universalHandleResponse(jsonObject, this.getFeatureName(), this.getTag());
                if (response.getStatusCode() != 200) {
                    String string4 = null;
                    return string4;
                }
                String string5 = jsonObject.getString("uploadToken");
                return string5;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            Throwable throwable3 = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, throwable);
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JS\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u00042\b\u0010\u0016\u001a\u0004\u0018\u00010\u00172\u0006\u0010\u0018\u001a\u00020\u00172\u0012\u0010\u0019\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001a\u00a2\u0006\u0002\u0010\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lru/ok/tracer/upload/SampleUploadWorker$Companion;", "", "()V", "PARAM_ATTR1", "", "PARAM_CUSTOM_PROPERTIES_KEYS", "PARAM_FEATURE_NAME", "PARAM_FEATURE_TAG", "PARAM_FEATURE_TAG_LIMIT", "PARAM_FEATURE_USE_GZIP", "PARAM_HAS_ATTR1", "PARAM_SAMPLE_FILE_PATH", "PARAM_VERSION_CODE", "createData", "Landroidx/work/Data;", "feature", "Lru/ok/tracer/TracerFeature;", "sampleFile", "Ljava/io/File;", "useGzip", "", "tag", "attr1", "", "versionCode", "customProperties", "", "(Lru/ok/tracer/TracerFeature;Ljava/io/File;ZLjava/lang/String;Ljava/lang/Long;JLjava/util/Map;)Landroidx/work/Data;", "tracer-sample-upload_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Data createData(@NotNull TracerFeature feature, @NotNull File sampleFile, boolean useGzip, @Nullable String tag, @Nullable Long attr1, long versionCode, @NotNull Map<String, String> customProperties) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
            Intrinsics.checkNotNullParameter(customProperties, (String)"customProperties");
            Data.Builder dataBuilder = new Data.Builder();
            dataBuilder.putString(SampleUploadWorker.PARAM_FEATURE_NAME, feature.getName());
            dataBuilder.putBoolean(SampleUploadWorker.PARAM_FEATURE_USE_GZIP, useGzip);
            dataBuilder.putString(SampleUploadWorker.PARAM_SAMPLE_FILE_PATH, sampleFile.getPath());
            dataBuilder.putString(SampleUploadWorker.PARAM_FEATURE_TAG, tag);
            if (attr1 != null) {
                dataBuilder.putBoolean(SampleUploadWorker.PARAM_HAS_ATTR1, true);
                dataBuilder.putLong(SampleUploadWorker.PARAM_ATTR1, attr1.longValue());
            }
            Collection $this$toTypedArray$iv = customProperties.keySet();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            dataBuilder.putStringArray(SampleUploadWorker.PARAM_CUSTOM_PROPERTIES_KEYS, stringArray);
            dataBuilder.putAll(customProperties);
            dataBuilder.putLong(SampleUploadWorker.PARAM_VERSION_CODE, versionCode);
            Data data = dataBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"dataBuilder.build()");
            return data;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

