/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.upload;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Build;
import androidx.work.Constraints;
import androidx.work.Data;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.compat.PackageInfoCompat;
import ru.ok.tracer.base.compat.PackageManagerCompat;
import ru.ok.tracer.upload.SampleUploadWorker;
import ru.ok.tracer.upload.SampleUtils;
import ru.ok.tracer.utils.TracerFiles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\b\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002Jg\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0013\u00a2\u0006\u0002\u0010\u0014J]\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0013H\u0001\u00a2\u0006\u0002\u0010\u0015Jo\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u000e2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0013\u00a2\u0006\u0002\u0010\u0018J]\u0010\u0019\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00102\u0014\b\u0002\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020\u000e0\u0013\u00a2\u0006\u0002\u0010\u001a\u00a8\u0006\u001b"}, d2={"Lru/ok/tracer/upload/SampleUploader;", "", "()V", "upload", "", "context", "Landroid/content/Context;", "feature", "Lru/ok/tracer/TracerFeature;", "sampleFile", "Ljava/io/File;", "useGzip", "", "tag", "", "attr1", "", "attr2", "customProperties", "", "(Landroid/content/Context;Lru/ok/tracer/TracerFeature;Ljava/io/File;ZLjava/lang/String;Ljava/lang/Long;Ljava/lang/Long;Ljava/util/Map;)V", "(Landroid/content/Context;Lru/ok/tracer/TracerFeature;Ljava/io/File;ZLjava/lang/String;Ljava/lang/Long;Ljava/util/Map;)V", "sampleFileSize", "sampleFileName", "(Landroid/content/Context;Lru/ok/tracer/TracerFeature;Ljava/io/File;JLjava/lang/String;ZLjava/lang/String;Ljava/lang/Long;Ljava/lang/Long;Ljava/util/Map;)V", "uploadCopy", "(Landroid/content/Context;Lru/ok/tracer/TracerFeature;Ljava/io/File;Ljava/lang/String;Ljava/lang/Long;Ljava/lang/Long;Ljava/util/Map;)V", "tracer-sample-upload_release"})
public final class SampleUploader {
    @NotNull
    public static final SampleUploader INSTANCE = new SampleUploader();

    private SampleUploader() {
    }

    public final void uploadCopy(@NotNull Context context, @NotNull TracerFeature feature, @NotNull File sampleFile, @Nullable String tag, @Nullable Long attr1, @Nullable Long attr2, @NotNull Map<String, String> customProperties) throws IOException {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
        Intrinsics.checkNotNullParameter(customProperties, (String)"customProperties");
        File tmpFile = TracerFiles.INSTANCE.getNewSampleFile(Tracer.INSTANCE.getContext(), feature, "");
        try {
            SampleUtils.gzipTo$default(sampleFile, tmpFile, 0, 2, null);
        }
        catch (IOException ex) {
            tmpFile.delete();
            throw ex;
        }
        long l = sampleFile.length();
        String string = sampleFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sampleFile.name");
        this.upload(context, feature, tmpFile, l, string, false, tag, attr1, attr2, customProperties);
    }

    public static /* synthetic */ void uploadCopy$default(SampleUploader sampleUploader, Context context, TracerFeature tracerFeature, File file, String string, Long l, Long l2, Map map, int n, Object object) throws IOException {
        if ((n & 8) != 0) {
            string = null;
        }
        if ((n & 0x10) != 0) {
            l = null;
        }
        if ((n & 0x20) != 0) {
            l2 = null;
        }
        if ((n & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        sampleUploader.uploadCopy(context, tracerFeature, file, string, l, l2, map);
    }

    @Deprecated(message="Will be removed")
    @PublishedApi
    public final void upload(@NotNull Context context, @NotNull TracerFeature feature, @NotNull File sampleFile, boolean useGzip, @Nullable String tag, @Nullable Long attr1, @NotNull Map<String, String> customProperties) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
        Intrinsics.checkNotNullParameter(customProperties, (String)"customProperties");
        long l = sampleFile.length();
        String string = sampleFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sampleFile.name");
        this.upload(context, feature, sampleFile, l, string, useGzip, tag, attr1, null, customProperties);
    }

    public static /* synthetic */ void upload$default(SampleUploader sampleUploader, Context context, TracerFeature tracerFeature, File file, boolean bl, String string, Long l, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            l = null;
        }
        if ((n & 0x40) != 0) {
            map = MapsKt.emptyMap();
        }
        sampleUploader.upload(context, tracerFeature, file, bl, string, l, map);
    }

    public final void upload(@NotNull Context context, @NotNull TracerFeature feature, @NotNull File sampleFile, boolean useGzip, @Nullable String tag, @Nullable Long attr1, @Nullable Long attr2, @NotNull Map<String, String> customProperties) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
        Intrinsics.checkNotNullParameter(customProperties, (String)"customProperties");
        long l = sampleFile.length();
        String string = sampleFile.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"sampleFile.name");
        this.upload(context, feature, sampleFile, l, string, useGzip, tag, attr1, attr2, customProperties);
    }

    public static /* synthetic */ void upload$default(SampleUploader sampleUploader, Context context, TracerFeature tracerFeature, File file, boolean bl, String string, Long l, Long l2, Map map, int n, Object object) {
        if ((n & 8) != 0) {
            bl = true;
        }
        if ((n & 0x10) != 0) {
            string = null;
        }
        if ((n & 0x20) != 0) {
            l = null;
        }
        if ((n & 0x40) != 0) {
            l2 = null;
        }
        if ((n & 0x80) != 0) {
            map = MapsKt.emptyMap();
        }
        sampleUploader.upload(context, tracerFeature, file, bl, string, l, l2, map);
    }

    public final void upload(@NotNull Context context, @NotNull TracerFeature feature, @NotNull File sampleFile, long sampleFileSize, @NotNull String sampleFileName, boolean useGzip, @Nullable String tag, @Nullable Long attr1, @Nullable Long attr2, @NotNull Map<String, String> customProperties) {
        Constraints.Builder builder;
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
        Intrinsics.checkNotNullParameter((Object)sampleFileName, (String)"sampleFileName");
        Intrinsics.checkNotNullParameter(customProperties, (String)"customProperties");
        Long l = sampleFileSize;
        PackageManager packageManager = context.getPackageManager();
        Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"context.packageManager");
        String string = context.getPackageName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.packageName");
        Data data = SampleUploadWorker.Companion.createData$tracer_sample_upload_release(feature, sampleFile, l, sampleFileName, useGzip, tag, attr1, attr2, PackageInfoCompat.getLongVersionCodeCompat((PackageInfo)PackageManagerCompat.getPackageInfoCompat((PackageManager)packageManager, (String)string, (int)0)), customProperties);
        Constraints.Builder $this$upload_u24lambda_u240 = builder = new Constraints.Builder();
        boolean bl = false;
        if (!CoreTracerConfiguration.Companion.get().getDebugUpload()) {
            if (Build.VERSION.SDK_INT >= 23) {
                $this$upload_u24lambda_u240.setRequiresDeviceIdle(true);
            }
            $this$upload_u24lambda_u240.setRequiredNetworkType(NetworkType.UNMETERED);
            $this$upload_u24lambda_u240.setRequiresBatteryNotLow(true);
        }
        Constraints constraints = builder.build();
        Intrinsics.checkNotNullExpressionValue((Object)constraints, (String)"Builder()\n            .a\u2026   }\n            .build()");
        Constraints constraints2 = constraints;
        WorkRequest workRequest = ((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(SampleUploadWorker.class).setConstraints(constraints2)).setInputData(data)).build();
        Intrinsics.checkNotNullExpressionValue((Object)workRequest, (String)"Builder(SampleUploadWork\u2026ata)\n            .build()");
        OneTimeWorkRequest request = (OneTimeWorkRequest)workRequest;
        WorkManager.getInstance((Context)context).enqueue((WorkRequest)request);
    }

    public static /* synthetic */ void upload$default(SampleUploader sampleUploader, Context context, TracerFeature tracerFeature, File file, long l, String string, boolean bl, String string2, Long l2, Long l3, Map map, int n, Object object) {
        if ((n & 0x200) != 0) {
            map = MapsKt.emptyMap();
        }
        sampleUploader.upload(context, tracerFeature, file, l, string, bl, string2, l2, l3, map);
    }
}

