/*
 * Decompiled with CFR 0.152.
 */
package ru.ok.tracer.upload;

import android.content.Context;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.util.Log;
import androidx.work.Data;
import androidx.work.ListenableWorker;
import androidx.work.Worker;
import androidx.work.WorkerParameters;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.json.JSONObject;
import ru.ok.tracer.CoreTracerConfiguration;
import ru.ok.tracer.SystemState;
import ru.ok.tracer.SystemStateSerializer;
import ru.ok.tracer.Tracer;
import ru.ok.tracer.TracerFeature;
import ru.ok.tracer.base.compat.PackageInfoCompat;
import ru.ok.tracer.base.compat.PackageManagerCompat;
import ru.ok.tracer.base.http.HttpMultipartBodyBuilder;
import ru.ok.tracer.base.http.HttpRequest;
import ru.ok.tracer.base.http.HttpRequestBody;
import ru.ok.tracer.base.http.HttpResponse;
import ru.ok.tracer.base.http.HttpResponseBody;
import ru.ok.tracer.upload.NetworkResponseHandler;
import ru.ok.tracer.upload.SampleUploadWorkerKt;
import ru.ok.tracer.upload.SampleUtils;
import ru.ok.tracer.utils.Logger;
import ru.ok.tracer.utils.TracerFiles;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\b\u0010\r\u001a\u00020\u000eH\u0016J#\u0010\u000f\u001a\u0004\u0018\u00010\b2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\bH\u0002\u00a2\u0006\u0002\u0010\u0013J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002R\u0014\u0010\u0007\u001a\u00020\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0016\u0010\u000b\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\n\u00a8\u0006\u001a"}, d2={"Lru/ok/tracer/upload/SampleUploadWorker;", "Landroidx/work/Worker;", "context", "Landroid/content/Context;", "workerParams", "Landroidx/work/WorkerParameters;", "(Landroid/content/Context;Landroidx/work/WorkerParameters;)V", "featureName", "", "getFeatureName", "()Ljava/lang/String;", "tag", "getTag", "doWork", "Landroidx/work/ListenableWorker$Result;", "getUploadToken", "sampleFileSize", "", "sampleFileName", "(Ljava/lang/Long;Ljava/lang/String;)Ljava/lang/String;", "uploadFile", "", "uploadToken", "sampleFile", "Ljava/io/File;", "Companion", "tracer-sample-upload_release"})
public final class SampleUploadWorker
extends Worker {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final String PARAM_FEATURE_NAME = "tracer_feature_name";
    @NotNull
    private static final String PARAM_FEATURE_USE_GZIP = "tracer_feature_uze_gzip";
    @NotNull
    private static final String PARAM_SAMPLE_FILE_PATH = "tracer_sample_file_path";
    @NotNull
    private static final String PARAM_SAMPLE_FILE_SIZE = "tracer_sample_file_size";
    @NotNull
    private static final String PARAM_SAMPLE_FILE_NAME = "tracer_sample_file_name";
    @NotNull
    private static final String PARAM_FEATURE_TAG = "tracer_feature_tag";
    @NotNull
    private static final String PARAM_VERSION_CODE = "tracer_version_code";
    @NotNull
    private static final String PARAM_ATTR1 = "tracer_attr1";
    @NotNull
    private static final String PARAM_HAS_ATTR1 = "tracer_has_attr1";
    @NotNull
    private static final String PARAM_ATTR2 = "tracer_attr2";
    @NotNull
    private static final String PARAM_HAS_ATTR2 = "tracer_has_attr2";
    @NotNull
    private static final String PARAM_CUSTOM_PROPERTIES_KEYS = "tracer_custom_properties_keys";

    public SampleUploadWorker(@NotNull Context context, @NotNull WorkerParameters workerParams) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)workerParams, (String)"workerParams");
        super(context, workerParams);
    }

    private final String getFeatureName() {
        String string = this.getInputData().getString(PARAM_FEATURE_NAME);
        Intrinsics.checkNotNull((Object)string);
        return string;
    }

    private final String getTag() {
        return this.getInputData().getString(PARAM_FEATURE_TAG);
    }

    @NotNull
    public ListenableWorker.Result doWork() {
        File sampleFile = null;
        try {
            String string = this.getInputData().getString(PARAM_SAMPLE_FILE_PATH);
            Intrinsics.checkNotNull((Object)string);
            sampleFile = new File(string);
            if (!sampleFile.exists()) {
                Logger.w$default((String)("sample file not exists with path: " + sampleFile.getPath()), null, (int)2, null);
                ListenableWorker.Result result = ListenableWorker.Result.success();
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
                return result;
            }
            Long l = this.getInputData().getLong(PARAM_SAMPLE_FILE_SIZE, -1L);
            long it = ((Number)l).longValue();
            boolean bl = false;
            Long sampleFileSize = it > 0L ? l : null;
            String sampleFileName = this.getInputData().getString(PARAM_SAMPLE_FILE_NAME);
            long sampleVersionCode = this.getInputData().getLong(PARAM_VERSION_CODE, 0L);
            PackageManager packageManager = this.getApplicationContext().getPackageManager();
            Intrinsics.checkNotNullExpressionValue((Object)packageManager, (String)"applicationContext.packageManager");
            String string2 = this.getApplicationContext().getPackageName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"applicationContext.packageName");
            long currentVersionCode = PackageInfoCompat.getLongVersionCodeCompat((PackageInfo)PackageManagerCompat.getPackageInfoCompat((PackageManager)packageManager, (String)string2, (int)0));
            if (currentVersionCode != sampleVersionCode) {
                Object[] objectArray = new Object[]{sampleVersionCode, currentVersionCode};
                Logger.d((String)"Version code mismatch. Old: %s, New: %s", (Object[])objectArray);
                sampleFile.delete();
                ListenableWorker.Result result = ListenableWorker.Result.success();
                Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
                return result;
            }
            String uploadToken = this.getUploadToken(sampleFileSize, sampleFileName);
            if (uploadToken != null) {
                this.uploadFile(uploadToken, sampleFile);
            }
        }
        catch (Exception e) {
            if (sampleFile != null && sampleFile.exists()) {
                sampleFile.delete();
            }
            Logger.e((Throwable)e);
        }
        ListenableWorker.Result result = ListenableWorker.Result.success();
        Intrinsics.checkNotNullExpressionValue((Object)result, (String)"success()");
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final void uploadFile(String uploadToken, File sampleFile) {
        useGzip = this.getInputData().getBoolean("tracer_feature_uze_gzip", true);
        if (useGzip) {
            v0 = this.getApplicationContext();
            Intrinsics.checkNotNullExpressionValue((Object)v0, (String)"applicationContext");
            v1 = this.getId().toString();
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"id.toString()");
            tmpFile = TracerFiles.INSTANCE.createTempFile(v0, v1);
            try {
                SampleUtils.gzipTo$default(sampleFile, (File)tmpFile, 0, 2, null);
            }
            catch (IOException ex) {
                tmpFile.delete();
                throw ex;
            }
            ex = new Object[]{sampleFile.length(), tmpFile.length()};
            Logger.d((String)"Sample size: %s. Upload size: %s", (Object[])ex);
            sampleFile.delete();
            v2 = tmpFile;
        } else {
            tmpFile = new Object[]{sampleFile.length()};
            Logger.d((String)"Sample size: %s", (Object[])tmpFile);
            v2 = sampleFile;
        }
        uploadFile = v2;
        p0 = CoreTracerConfiguration.Companion.get().getApiUrl();
        $i$a$-let-SampleUploadWorker$uploadFile$url$1 = false;
        v3 = Uri.parse((String)p0).buildUpon().appendEncodedPath("api/sample/upload").appendQueryParameter("uploadToken", uploadToken).toString();
        Intrinsics.checkNotNullExpressionValue((Object)v3, (String)"CoreTracerConfiguration.\u2026)\n            .toString()");
        url = v3;
        this_$iv /* !! */  = HttpMultipartBodyBuilder.Companion;
        $i$f$build = false;
        var10_18 = $i$a$-let-SampleUploadWorker$uploadFile$url$1 = new HttpMultipartBodyBuilder();
        var16_20 = url;
        $i$a$-build-SampleUploadWorker$uploadFile$request$1 = false;
        $this$uploadFile_u24lambda_u241.add("file", "sample", HttpRequestBody.Companion.fromFile("application/octet-stream", uploadFile));
        var17_22 = $i$a$-let-SampleUploadWorker$uploadFile$url$1.build();
        var18_23 = var16_20;
        request = new HttpRequest(var18_23, var17_22);
        try {
            this_$iv /* !! */  = (Closeable)Tracer.INSTANCE.getHttpClient().execute(request);
            var8_10 = null;
            try {
                it = (HttpResponse)this_$iv /* !! */ ;
                $i$a$-use-SampleUploadWorker$uploadFile$1 = false;
                responseCode = it.getStatusCode();
                responseMessage = it.getMessage();
                v4 = it.getBody();
                responseContentType = v4 != null ? v4.getContentType() : null;
                v5 /* !! */  = it.getBody();
                if (v5 /* !! */  == null) ** GOTO lbl-1000
                v6 = v5 /* !! */ .getBytes();
                v5 /* !! */  = (HttpResponseBody)v6;
                if (v6 != null) {
                    v7 = StringsKt.decodeToString((byte[])v5 /* !! */ );
                } else lbl-1000:
                // 2 sources

                {
                    v7 = null;
                }
                responseBody = v7;
                NetworkResponseHandler.INSTANCE.universalHandleResponse(responseContentType, responseBody, this.getFeatureName(), this.getTag());
                if (responseCode != 200) {
                    v8 = Log.e((String)"Tracer", (String)(responseMessage + " , " + responseBody));
                } else {
                    var15_27 = new Object[]{"Result: " + responseBody};
                    Logger.d((String)"Tracer", (Object[])var15_27);
                    v8 = Unit.INSTANCE;
                }
                var9_12 = v8;
            }
            catch (Throwable var9_13) {
                var8_10 = var9_13;
                throw var9_13;
            }
            finally {
                CloseableKt.closeFinally((Closeable)this_$iv /* !! */ , (Throwable)var8_10);
            }
        }
        catch (Exception e) {
            Logger.e((Throwable)e);
        }
        finally {
            uploadFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final String getUploadToken(Long sampleFileSize, String sampleFileName) {
        String[] stringArray;
        Map map;
        String appToken = Tracer.INSTANCE.getAppToken();
        if (appToken == null) {
            Logger.w$default((String)"No app token", null, (int)2, null);
            return null;
        }
        Map $this$getUploadToken_u24lambda_u243 = map = MapsKt.createMapBuilder();
        boolean bl = false;
        String[] stringArray2 = this.getInputData().getStringArray(PARAM_CUSTOM_PROPERTIES_KEYS);
        if (stringArray2 == null) {
            int $i$f$emptyArray = 0;
            stringArray = (String[])((Object[])new String[0]);
        } else {
            stringArray = stringArray2;
        }
        for (String key : stringArray) {
            String value = this.getInputData().getString(key);
            if (value == null) continue;
            $this$getUploadToken_u24lambda_u243.put(key, value);
        }
        Map customProperties = MapsKt.build((Map)map);
        SystemState systemState = SampleUploadWorkerKt.access$withCustomProperties(Tracer.INSTANCE.getStateStorage().getCurrentSystemState(), customProperties);
        JSONObject $this$getUploadToken_u24lambda_u244 = bl = SystemStateSerializer.INSTANCE.toJsonObject(systemState);
        boolean bl2 = false;
        $this$getUploadToken_u24lambda_u244.put("feature", (Object)this.getFeatureName());
        $this$getUploadToken_u24lambda_u244.put("sampleSize", (Object)sampleFileSize);
        $this$getUploadToken_u24lambda_u244.put("sampleFileName", (Object)sampleFileName);
        if (this.getInputData().getBoolean(PARAM_HAS_ATTR1, false)) {
            $this$getUploadToken_u24lambda_u244.put("attr1", this.getInputData().getLong(PARAM_ATTR1, 0L));
        }
        if (this.getInputData().getBoolean(PARAM_HAS_ATTR2, false)) {
            $this$getUploadToken_u24lambda_u244.put("attr2", this.getInputData().getLong(PARAM_ATTR2, 0L));
        }
        if (this.getTag() != null) {
            $this$getUploadToken_u24lambda_u244.put("tag", (Object)this.getTag());
        }
        JSONObject json = bl;
        String p0 = CoreTracerConfiguration.Companion.get().getApiUrl();
        boolean bl3 = false;
        String string = Uri.parse((String)p0).buildUpon().appendEncodedPath("api/sample/initUpload").appendQueryParameter("sampleToken", appToken).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"CoreTracerConfiguration.\u2026)\n            .toString()");
        String url = string;
        String string2 = json.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"json.toString()");
        HttpRequest request = new HttpRequest(url, HttpRequestBody.Companion.fromString$default((HttpRequestBody.Companion)HttpRequestBody.Companion, (String)"application/json; charset=utf-8", (String)string2, null, (int)4, null));
        Object object = new Object[]{url.toString(), json.toString()};
        Logger.d((String)"Url: %s Args: %s", (Object[])object);
        object = (Closeable)Tracer.INSTANCE.getHttpClient().execute(request);
        Throwable throwable = null;
        try {
            HttpResponse response = (HttpResponse)object;
            boolean bl4 = false;
            HttpResponseBody responseBody = response.getBody();
            if (responseBody != null) {
                JSONObject jsonObject = new JSONObject(StringsKt.decodeToString((byte[])responseBody.getBytes()));
                NetworkResponseHandler.INSTANCE.universalHandleResponse(jsonObject, this.getFeatureName(), this.getTag());
                if (response.getStatusCode() != 200) {
                    String string3 = null;
                    return string3;
                }
                String string4 = jsonObject.getString("uploadToken");
                return string4;
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)object, (Throwable)throwable);
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\b\u0007\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JU\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001dH\u0007\u00a2\u0006\u0002\u0010\u001eJu\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u001f\u001a\u0004\u0018\u00010\u001a2\b\u0010 \u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0016\u001a\u00020\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00042\b\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\b\u0010!\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\u001b\u001a\u00020\u001a2\u0012\u0010\u001c\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u001dH\u0000\u00a2\u0006\u0004\b\"\u0010#R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lru/ok/tracer/upload/SampleUploadWorker$Companion;", "", "()V", "PARAM_ATTR1", "", "PARAM_ATTR2", "PARAM_CUSTOM_PROPERTIES_KEYS", "PARAM_FEATURE_NAME", "PARAM_FEATURE_TAG", "PARAM_FEATURE_USE_GZIP", "PARAM_HAS_ATTR1", "PARAM_HAS_ATTR2", "PARAM_SAMPLE_FILE_NAME", "PARAM_SAMPLE_FILE_PATH", "PARAM_SAMPLE_FILE_SIZE", "PARAM_VERSION_CODE", "createData", "Landroidx/work/Data;", "feature", "Lru/ok/tracer/TracerFeature;", "sampleFile", "Ljava/io/File;", "useGzip", "", "tag", "attr1", "", "versionCode", "customProperties", "", "(Lru/ok/tracer/TracerFeature;Ljava/io/File;ZLjava/lang/String;Ljava/lang/Long;JLjava/util/Map;)Landroidx/work/Data;", "sampleFileSize", "sampleFileName", "attr2", "createData$tracer_sample_upload_release", "(Lru/ok/tracer/TracerFeature;Ljava/io/File;Ljava/lang/Long;Ljava/lang/String;ZLjava/lang/String;Ljava/lang/Long;Ljava/lang/Long;JLjava/util/Map;)Landroidx/work/Data;", "tracer-sample-upload_release"})
    public static final class Companion {
        private Companion() {
        }

        @Deprecated(message="Will be removed")
        @NotNull
        public final Data createData(@NotNull TracerFeature feature, @NotNull File sampleFile, boolean useGzip, @Nullable String tag, @Nullable Long attr1, long versionCode, @NotNull Map<String, String> customProperties) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
            Intrinsics.checkNotNullParameter(customProperties, (String)"customProperties");
            return this.createData$tracer_sample_upload_release(feature, sampleFile, sampleFile.length(), sampleFile.getName(), useGzip, tag, attr1, null, versionCode, customProperties);
        }

        @NotNull
        public final Data createData$tracer_sample_upload_release(@NotNull TracerFeature feature, @NotNull File sampleFile, @Nullable Long sampleFileSize, @Nullable String sampleFileName, boolean useGzip, @Nullable String tag, @Nullable Long attr1, @Nullable Long attr2, long versionCode, @NotNull Map<String, String> customProperties) {
            Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
            Intrinsics.checkNotNullParameter((Object)sampleFile, (String)"sampleFile");
            Intrinsics.checkNotNullParameter(customProperties, (String)"customProperties");
            Data.Builder dataBuilder = new Data.Builder();
            dataBuilder.putString(SampleUploadWorker.PARAM_FEATURE_NAME, feature.getName());
            dataBuilder.putBoolean(SampleUploadWorker.PARAM_FEATURE_USE_GZIP, useGzip);
            dataBuilder.putString(SampleUploadWorker.PARAM_SAMPLE_FILE_PATH, sampleFile.getPath());
            Long l = sampleFileSize;
            dataBuilder.putLong(SampleUploadWorker.PARAM_SAMPLE_FILE_SIZE, l != null ? l : -1L);
            dataBuilder.putString(SampleUploadWorker.PARAM_SAMPLE_FILE_NAME, sampleFileName);
            dataBuilder.putString(SampleUploadWorker.PARAM_FEATURE_TAG, tag);
            if (attr1 != null) {
                dataBuilder.putBoolean(SampleUploadWorker.PARAM_HAS_ATTR1, true);
                dataBuilder.putLong(SampleUploadWorker.PARAM_ATTR1, attr1.longValue());
            }
            if (attr2 != null) {
                dataBuilder.putBoolean(SampleUploadWorker.PARAM_HAS_ATTR2, true);
                dataBuilder.putLong(SampleUploadWorker.PARAM_ATTR2, attr2.longValue());
            }
            Collection $this$toTypedArray$iv = customProperties.keySet();
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            String[] stringArray = thisCollection$iv.toArray(new String[0]);
            Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            dataBuilder.putStringArray(SampleUploadWorker.PARAM_CUSTOM_PROPERTIES_KEYS, stringArray);
            dataBuilder.putAll(customProperties);
            dataBuilder.putLong(SampleUploadWorker.PARAM_VERSION_CODE, versionCode);
            Data data = dataBuilder.build();
            Intrinsics.checkNotNullExpressionValue((Object)data, (String)"dataBuilder.build()");
            return data;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

