/*
 * Decompiled with CFR 0.152.
 */
package ru.romangr.exceptional;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import ru.romangr.exceptional.nullability.NonNullApi;
import ru.romangr.exceptional.type.ExceptionalConsumer;
import ru.romangr.exceptional.type.ExceptionalFunction;
import ru.romangr.exceptional.type.ExceptionalRunnable;
import ru.romangr.exceptional.type.ExceptionalSupplier;
import ru.romangr.exceptional.type.ExceptionalWrappedException;
import ru.romangr.exceptional.type.ProcessingResult;

@NonNullApi
public final class Exceptional<T> {
    private static final Exceptional<?> EMPTY_INSTANCE = Exceptional.exceptional(null);
    @Nullable
    private final Exception exception;
    @Nullable
    private final T value;
    private boolean isExceptionHandled;

    public static <V> Exceptional<V> getExceptional(ExceptionalSupplier<V> supplier) {
        try {
            return Exceptional.exceptional(supplier.get());
        }
        catch (Exception e) {
            return Exceptional.exceptional(e);
        }
    }

    public static <V> Exceptional<V> attempt(ExceptionalSupplier<V> supplier) {
        try {
            return Exceptional.exceptional(supplier.get());
        }
        catch (Exception e) {
            return Exceptional.exceptional(e);
        }
    }

    public static <V> Exceptional<V> exceptional(@Nullable V value) {
        return new Exceptional<V>(value);
    }

    public static <V> Exceptional<V> of(@Nullable V value) {
        return new Exceptional<V>(value);
    }

    public static <V> Exceptional<V> exceptional(Exception exception) {
        return new Exceptional(exception);
    }

    public static <V> Exceptional<V> of(Exception exception) {
        return new Exceptional(exception);
    }

    public static <E, C> Exceptional<ProcessingResult<E>> processCollection(Collection<C> collection, Function<? super C, Exceptional<E>> mapper) {
        Iterator<C> iterator = collection.iterator();
        if (!iterator.hasNext()) {
            return Exceptional.exceptional(new ProcessingResult(Collections.emptyList(), null));
        }
        ArrayList<E> successResults = new ArrayList<E>(collection.size());
        do {
            C element;
            Exceptional<E> result;
            if ((result = mapper.apply(element = iterator.next())).isValuePresent()) {
                successResults.add(result.getValue());
            }
            if (!result.isException()) continue;
            return Exceptional.exceptional(new ProcessingResult(successResults, result.getException()));
        } while (iterator.hasNext());
        return Exceptional.exceptional(new ProcessingResult(successResults, null));
    }

    public static <E> Exceptional<E> empty() {
        return EMPTY_INSTANCE;
    }

    public <V> Exceptional<V> map(Function<? super T, V> mapper) {
        if (this.thisIsNotValue()) {
            return this;
        }
        return new Exceptional<V>(mapper.apply(this.value));
    }

    public <V> Exceptional<V> safelyMap(ExceptionalFunction<? super T, V> mapper) {
        if (this.thisIsNotValue()) {
            return this;
        }
        return Exceptional.getExceptional(() -> mapper.apply((T)this.value));
    }

    public <V> Exceptional<V> flatMap(Function<? super T, Exceptional<V>> mapper) {
        if (this.thisIsNotValue()) {
            return this;
        }
        return mapper.apply(this.value);
    }

    public Exceptional<T> flatMapIfEmpty(Supplier<Exceptional<T>> supplier) {
        if (this.isEmpty()) {
            return supplier.get();
        }
        return this;
    }

    public Exceptional<T> ifValue(Consumer<? super T> consumer) {
        if (this.thisIsNotValue()) {
            return this;
        }
        return this.executeSafely(() -> consumer.accept((T)this.value));
    }

    public Exceptional<T> ifException(Consumer<Exception> consumer) {
        if (this.isException()) {
            return this.executeSafely(() -> consumer.accept(this.exception));
        }
        return this;
    }

    public <E extends Exception> Exceptional<T> ifException(Class<E> clazz, Consumer<E> consumer) {
        if (this.isException() && clazz.isAssignableFrom(this.exception.getClass())) {
            return this.executeSafely(() -> consumer.accept(this.exception));
        }
        return this;
    }

    public Exceptional<T> ifEmpty(ExceptionalRunnable runnable) {
        if (this.isEmpty()) {
            return this.executeSafely(runnable);
        }
        return this;
    }

    public T getValue() throws IllegalStateException {
        if (this.isException()) {
            throw new IllegalStateException();
        }
        if (!this.isValuePresent()) {
            throw new IllegalStateException();
        }
        return this.value;
    }

    public Exception getException() throws IllegalStateException {
        if (!this.isException()) {
            throw new IllegalStateException();
        }
        return this.exception;
    }

    public T getOrDefault(T defaultValue) {
        if (this.thisIsNotValue()) {
            return defaultValue;
        }
        return Objects.requireNonNull(this.value);
    }

    public Exceptional<T> resumeOnException(ExceptionalFunction<Exception, T> mapper) {
        if (!this.isException()) {
            return this;
        }
        return Exceptional.getExceptional(() -> mapper.apply(this.exception));
    }

    public Exceptional<T> mapException(Function<Exception, Exception> mapper) {
        if (!this.isException()) {
            return this;
        }
        return Exceptional.exceptional(mapper.apply(this.exception));
    }

    public <E extends Exception> Exceptional<T> mapException(Class<E> clazz, Function<E, Exception> mapper) {
        if (!this.isException() || !clazz.isAssignableFrom(this.exception.getClass())) {
            return this;
        }
        return Exceptional.exceptional(mapper.apply(this.exception));
    }

    public Exceptional<T> handleException(ExceptionalConsumer<Exception> consumer) {
        if (!this.isException() || this.isExceptionHandled) {
            return this;
        }
        this.isExceptionHandled = true;
        return this.executeSafely(() -> consumer.accept(this.exception));
    }

    public <E extends Exception> Exceptional<T> handleException(Class<E> clazz, ExceptionalConsumer<E> consumer) {
        if (!this.isException() || this.isExceptionHandled || !clazz.isAssignableFrom(this.exception.getClass())) {
            return this;
        }
        this.isExceptionHandled = true;
        return this.executeSafely(() -> consumer.accept(this.exception));
    }

    public boolean isException() {
        return this.exception != null;
    }

    public boolean isValuePresent() {
        return this.value != null;
    }

    public Stream<T> asStream() {
        if (this.thisIsNotValue()) {
            return Stream.empty();
        }
        return Stream.of(this.value);
    }

    public Optional<T> asOptional() {
        return Optional.ofNullable(this.value);
    }

    public T getOrThrow() throws ExceptionalWrappedException, NullPointerException {
        if (this.isValuePresent()) {
            return this.value;
        }
        if (this.isException()) {
            throw new ExceptionalWrappedException(this.exception);
        }
        throw new NullPointerException("Exceptional is empty");
    }

    public boolean isEmpty() {
        return !this.isValuePresent() && !this.isException();
    }

    private Exceptional(Exception exception) {
        this.exception = exception;
        this.value = null;
    }

    private Exceptional(@Nullable T value) {
        this.value = value;
        this.exception = null;
    }

    private boolean thisIsNotValue() {
        return this.isException() || !this.isValuePresent();
    }

    private Exceptional<T> executeSafely(ExceptionalRunnable runnable) {
        try {
            runnable.run();
            return this;
        }
        catch (Exception e) {
            return new Exceptional<T>(e);
        }
    }
}

