/*
 * Decompiled with CFR 0.152.
 */
package ru.sberned.kafkalogback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.contrib.json.classic.JsonLayout;
import ch.qos.logback.core.util.ContextUtil;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class CustomJsonLayout
extends JsonLayout {
    public static final String LINE_NUMBER = "line_number";
    public static final String CLASS_NAME = "class_name";
    public static final String METHOD_NAME = "method_name";
    public static final String FILE_NAME = "file_name";
    public static final String HOST = "host";
    private final String HOST_NAME = this.getHostName();
    private boolean includeLineNumber = true;
    private boolean includeClassName = true;
    private boolean includeMethodName = true;
    private boolean includeHost = true;
    private boolean includeFileName = true;
    private List<String> additionalFields = new ArrayList<String>();

    public void addAdditionalField(String additionalField) {
        this.additionalFields.add(additionalField);
    }

    protected void addCustomDataToJsonMap(Map<String, Object> map, ILoggingEvent event) {
        this.add(HOST, this.includeHost, this.HOST_NAME, map);
        if (event.hasCallerData()) {
            StackTraceElement callerData = event.getCallerData()[0];
            this.addLine(LINE_NUMBER, this.includeLineNumber, callerData.getLineNumber(), map);
            this.add(CLASS_NAME, this.includeClassName, callerData.getClassName(), map);
            this.add(METHOD_NAME, this.includeMethodName, callerData.getMethodName(), map);
            this.add(FILE_NAME, this.includeFileName, callerData.getFileName(), map);
        }
        if (this.additionalFields != null) {
            this.additionalFields.forEach(field -> {
                String[] p = field.split("\\|");
                if (p.length == 2) {
                    this.add(p[0], true, p[1], map);
                } else {
                    this.addWarn("Unable to parse property string: " + field);
                }
            });
        }
    }

    private String getHostName() {
        try {
            return ContextUtil.getLocalHostName();
        }
        catch (SocketException | UnknownHostException e) {
            return "undefined";
        }
    }

    private void addLine(String fieldName, boolean field, int value, Map<String, Object> map) {
        if (field) {
            map.put(fieldName, value);
        }
    }

    public void setIncludeLineNumber(boolean includeLineNumber) {
        this.includeLineNumber = includeLineNumber;
    }

    public void setIncludeClassName(boolean includeClassName) {
        this.includeClassName = includeClassName;
    }

    public void setIncludeMethodName(boolean includeMethodName) {
        this.includeMethodName = includeMethodName;
    }

    public void setIncludeHost(boolean includeHost) {
        this.includeHost = includeHost;
    }

    public void setIncludeFileName(boolean includeFileName) {
        this.includeFileName = includeFileName;
    }

    public void setAdditionalFields(List<String> additionalFields) {
        this.additionalFields = additionalFields;
    }
}

