/*
 * Decompiled with CFR 0.152.
 */
package ru.sberned.kafkalogback;

import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.AppenderBase;
import ch.qos.logback.core.Layout;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Properties;
import org.apache.kafka.clients.producer.KafkaProducer;
import org.apache.kafka.clients.producer.Producer;
import org.apache.kafka.clients.producer.ProducerRecord;

public class KafkaAppender
extends AppenderBase<ILoggingEvent> {
    private String topic;
    private String bootstrapServers;
    private String valueSerializer;
    private boolean failOnStartup;
    Producer<String, String> producer;
    private Layout<ILoggingEvent> layout;
    private List<String> customProps = new ArrayList<String>();

    public void start() {
        Objects.requireNonNull(this.topic, "topic must not be null");
        Objects.requireNonNull(this.bootstrapServers, "bootstrapServers must not be null");
        Objects.requireNonNull(this.valueSerializer, "valueSerializer must not be null");
        Objects.requireNonNull(this.layout, "layout must not be null");
        Properties props = new Properties();
        props.put("bootstrap.servers", this.bootstrapServers);
        props.put("key.serializer", "org.apache.kafka.common.serialization.StringSerializer");
        props.put("value.serializer", this.valueSerializer);
        this.parseProperties(props);
        try {
            this.startProducer(props);
            super.start();
        }
        catch (Exception e) {
            if (this.failOnStartup) {
                this.addError("Unable to start Kafka Producer", e);
            }
            this.addWarn("Unable to start Kafka Producer", e);
        }
    }

    public void stop() {
        super.stop();
        if (this.producer != null) {
            this.producer.close();
        }
    }

    public void addCustomProp(String customProp) {
        this.customProps.add(customProp);
    }

    protected void append(ILoggingEvent event) {
        if (this.producer != null) {
            try {
                this.producer.send(new ProducerRecord(this.topic, (Object)String.valueOf(Math.random()), (Object)this.layout.doLayout((Object)event))).get();
            }
            catch (Exception e) {
                this.addWarn("Unable to send message to Kafka", e);
            }
        }
    }

    void parseProperties(Properties properties) {
        if (this.customProps != null) {
            this.customProps.forEach(property -> {
                String[] p = property.split("\\|");
                if (p.length == 2) {
                    properties.put(p[0], p[1]);
                } else if (this.failOnStartup) {
                    this.addError("Unable to parse property string: " + property);
                } else {
                    this.addWarn("Unable to parse property string: " + property);
                }
            });
        }
    }

    void startProducer(Properties props) throws Exception {
        this.producer = new KafkaProducer(props);
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public void setBootstrapServers(String bootstrapServers) {
        this.bootstrapServers = bootstrapServers;
    }

    public void setValueSerializer(String valueSerializer) {
        this.valueSerializer = valueSerializer;
    }

    public void setFailOnStartup(boolean failOnStartup) {
        this.failOnStartup = failOnStartup;
    }

    public void setProducer(Producer<String, String> producer) {
        this.producer = producer;
    }

    public void setLayout(Layout<ILoggingEvent> layout) {
        this.layout = layout;
    }

    public void setCustomProps(List<String> customProps) {
        this.customProps = customProps;
    }
}

