/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.element;

import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import ru.yandex.qatools.htmlelements.element.CheckBox;
import ru.yandex.qatools.htmlelements.element.FileInput;
import ru.yandex.qatools.htmlelements.element.Radio;
import ru.yandex.qatools.htmlelements.element.Select;
import ru.yandex.qatools.htmlelements.element.TextInput;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;

public class Form
extends TypifiedElement {
    private static final String CHECKBOX_FIELD = "checkbox";
    private static final String RADIO_FIELD = "radio";
    private static final String SELECT_FIELD = "select";
    private static final String INPUT_FIELD = "input";
    private static final String FILE_FIELD = "file";

    public Form(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public void fill(Map<String, Object> data) {
        data.entrySet().stream().map(e -> new AbstractMap.SimpleEntry<WebElement, String>(this.findElementByKey((String)e.getKey()), Objects.toString(e.getValue(), ""))).filter(e -> !Objects.isNull(e.getKey())).forEach(e -> this.fillElement((WebElement)e.getKey(), (String)e.getValue()));
    }

    protected WebElement findElementByKey(String key) {
        List elements = this.getWrappedElement().findElements(By.name((String)key));
        if (elements.isEmpty()) {
            return null;
        }
        return (WebElement)elements.get(0);
    }

    protected void fillElement(WebElement element, String value) {
        String elementType = this.getElementType(element);
        if (CHECKBOX_FIELD.equals(elementType)) {
            this.fillCheckBox(element, value);
        } else if (RADIO_FIELD.equals(elementType)) {
            this.fillRadio(element, value);
        } else if (INPUT_FIELD.equals(elementType)) {
            this.fillInput(element, value);
        } else if (SELECT_FIELD.equals(elementType)) {
            this.fillSelect(element, value);
        } else if (FILE_FIELD.equals(elementType)) {
            this.fillFile(element, value);
        }
    }

    protected String getElementType(WebElement element) {
        String tagName = element.getTagName();
        if (INPUT_FIELD.equals(tagName)) {
            String type = element.getAttribute("type");
            if (CHECKBOX_FIELD.equals(type)) {
                return CHECKBOX_FIELD;
            }
            if (RADIO_FIELD.equals(type)) {
                return RADIO_FIELD;
            }
            if (FILE_FIELD.equals(type)) {
                return FILE_FIELD;
            }
            return INPUT_FIELD;
        }
        if (SELECT_FIELD.equals(tagName)) {
            return SELECT_FIELD;
        }
        if ("textarea".equals(tagName)) {
            return INPUT_FIELD;
        }
        return null;
    }

    protected void fillCheckBox(WebElement element, String value) {
        new CheckBox(element).set(Boolean.parseBoolean(value));
    }

    protected void fillRadio(WebElement element, String value) {
        new Radio(element).selectByValue(value);
    }

    protected void fillInput(WebElement element, String value) {
        TextInput input = new TextInput(element);
        input.sendKeys(input.getClearCharSequence() + value);
    }

    protected void fillSelect(WebElement element, String value) {
        new Select(element).selectByValue(value);
    }

    protected void fillFile(WebElement element, String value) {
        new FileInput(element).setFileToUpload(value);
    }
}

