/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.element;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;

public class Table
extends TypifiedElement {
    public Table(WebElement wrappedElement) {
        super(wrappedElement);
    }

    public List<WebElement> getHeadings() {
        return this.getWrappedElement().findElements(By.xpath((String)".//th"));
    }

    public List<String> getHeadingsAsString() {
        return this.getHeadings().stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public List<List<WebElement>> getRows() {
        return this.getWrappedElement().findElements(By.xpath((String)".//tr")).stream().map(rowElement -> rowElement.findElements(By.xpath((String)".//td"))).filter(row -> row.size() > 0).collect(Collectors.toList());
    }

    public List<List<String>> getRowsAsString() {
        return this.getRows().stream().map(row -> row.stream().map(WebElement::getText).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public List<List<WebElement>> getColumns() {
        ArrayList<List<WebElement>> columns = new ArrayList<List<WebElement>>();
        List<List<WebElement>> rows = this.getRows();
        if (rows.isEmpty()) {
            return columns;
        }
        int columnCount = rows.get(0).size();
        for (int i = 0; i < columnCount; ++i) {
            ArrayList<WebElement> column = new ArrayList<WebElement>();
            for (List<WebElement> row : rows) {
                column.add(row.get(i));
            }
            columns.add(column);
        }
        return columns;
    }

    public List<WebElement> getColumnByIndex(int index) {
        return this.getWrappedElement().findElements(By.cssSelector((String)String.format("tr > td:nth-of-type(%d)", index)));
    }

    public List<List<String>> getColumnsAsString() {
        return this.getColumns().stream().map(row -> row.stream().map(WebElement::getText).collect(Collectors.toList())).collect(Collectors.toList());
    }

    public WebElement getCellAt(int i, int j) {
        return this.getRows().get(i).get(j);
    }

    public List<Map<String, WebElement>> getRowsMappedToHeadings() {
        List<String> headingsAsString = this.getHeadingsAsString();
        return this.getRows().stream().map(row -> row.stream().collect(Collectors.toMap(e -> (String)headingsAsString.get(row.indexOf(e)), Function.identity()))).collect(Collectors.toList());
    }

    public List<Map<String, WebElement>> getRowsMappedToHeadings(List<String> headings) {
        return this.getRowsMappedToHeadings().stream().map(e -> e.entrySet().stream().filter(m -> headings.contains(m.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue))).collect(Collectors.toList());
    }

    public List<Map<String, String>> getRowsAsStringMappedToHeadings() {
        return this.getRowsMappedToHeadings().stream().map(m -> m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((WebElement)e.getValue()).getText()))).collect(Collectors.toList());
    }

    public List<Map<String, String>> getRowsAsStringMappedToHeadings(List<String> headings) {
        return this.getRowsMappedToHeadings(headings).stream().map(m -> m.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((WebElement)e.getValue()).getText()))).collect(Collectors.toList());
    }
}

