/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.qatools.htmlelements.loader;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import org.openqa.selenium.SearchContext;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.PageFactory;
import org.openqa.selenium.support.pagefactory.ElementLocator;
import org.openqa.selenium.support.pagefactory.FieldDecorator;
import ru.yandex.qatools.htmlelements.element.HtmlElement;
import ru.yandex.qatools.htmlelements.element.TypifiedElement;
import ru.yandex.qatools.htmlelements.exceptions.HtmlElementsException;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementDecorator;
import ru.yandex.qatools.htmlelements.loader.decorator.HtmlElementLocatorFactory;
import ru.yandex.qatools.htmlelements.loader.decorator.ProxyFactory;
import ru.yandex.qatools.htmlelements.loader.decorator.proxyhandlers.WebElementNamedProxyHandler;
import ru.yandex.qatools.htmlelements.pagefactory.CustomElementLocatorFactory;
import ru.yandex.qatools.htmlelements.utils.HtmlElementUtils;

public class HtmlElementLoader {
    public static <T> T create(Class<T> clazz, WebDriver driver) {
        if (HtmlElementUtils.isHtmlElement(clazz)) {
            return HtmlElementLoader.createHtmlElement(clazz, (SearchContext)driver);
        }
        if (HtmlElementUtils.isTypifiedElement(clazz)) {
            return HtmlElementLoader.createTypifiedElement(clazz, (SearchContext)driver);
        }
        return HtmlElementLoader.createPageObject(clazz, driver);
    }

    public static <T> void populate(T instance, WebDriver driver) {
        if (HtmlElementUtils.isHtmlElement(instance)) {
            HtmlElementLoader.populateHtmlElement((HtmlElement)instance, (SearchContext)driver);
        } else {
            HtmlElementLoader.populatePageObject(instance, (SearchContext)driver);
        }
    }

    public static <T extends HtmlElement> T createHtmlElement(Class<T> clazz, SearchContext searchContext) {
        ElementLocator locator = new HtmlElementLocatorFactory(searchContext).createLocator(clazz);
        String elementName = HtmlElementUtils.getElementName(clazz);
        WebElementNamedProxyHandler handler = new WebElementNamedProxyHandler(locator, elementName);
        Object elementToWrap = ProxyFactory.createWebElementProxy(clazz.getClassLoader(), (InvocationHandler)((Object)handler));
        return HtmlElementLoader.createHtmlElement(clazz, elementToWrap, elementName);
    }

    public static <T extends HtmlElement> T createHtmlElement(Class<T> elementClass, WebElement elementToWrap, String name) {
        try {
            HtmlElement instance = (HtmlElement)HtmlElementUtils.newInstance(elementClass, new Object[0]);
            instance.setWrappedElement(elementToWrap);
            instance.setName(name);
            HtmlElementLoader.populatePageObject((Object)instance, (SearchContext)elementToWrap);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HtmlElementsException(e);
        }
    }

    public static <T extends TypifiedElement> T createTypifiedElement(Class<T> clazz, SearchContext searchContext) {
        ElementLocator locator = new HtmlElementLocatorFactory(searchContext).createLocator(clazz);
        String elementName = HtmlElementUtils.getElementName(clazz);
        WebElementNamedProxyHandler handler = new WebElementNamedProxyHandler(locator, elementName);
        Object elementToWrap = ProxyFactory.createWebElementProxy(clazz.getClassLoader(), (InvocationHandler)((Object)handler));
        return HtmlElementLoader.createTypifiedElement(clazz, elementToWrap, elementName);
    }

    public static <T extends TypifiedElement> T createTypifiedElement(Class<T> elementClass, WebElement elementToWrap, String name) {
        try {
            TypifiedElement instance = (TypifiedElement)HtmlElementUtils.newInstance(elementClass, elementToWrap);
            instance.setName(name);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HtmlElementsException(e);
        }
    }

    public static <T> T createPageObject(Class<T> clazz, WebDriver driver) {
        try {
            T instance = HtmlElementUtils.newInstance(clazz, driver);
            HtmlElementLoader.populatePageObject(instance, (SearchContext)driver);
            return instance;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new HtmlElementsException(e);
        }
    }

    public static void populateHtmlElement(HtmlElement htmlElement, SearchContext searchContext) {
        HtmlElementLoader.populateHtmlElement(htmlElement, new HtmlElementLocatorFactory(searchContext));
    }

    public static void populateHtmlElement(HtmlElement htmlElement, CustomElementLocatorFactory locatorFactory) {
        Class<?> elementClass = htmlElement.getClass();
        ElementLocator locator = locatorFactory.createLocator(elementClass);
        ClassLoader elementClassLoader = htmlElement.getClass().getClassLoader();
        String elementName = HtmlElementUtils.getElementName(elementClass);
        WebElementNamedProxyHandler handler = new WebElementNamedProxyHandler(locator, elementName);
        Object elementToWrap = ProxyFactory.createWebElementProxy(elementClassLoader, (InvocationHandler)((Object)handler));
        htmlElement.setWrappedElement((WebElement)elementToWrap);
        htmlElement.setName(elementName);
        HtmlElementLoader.populatePageObject((Object)htmlElement, elementToWrap);
    }

    public static void populatePageObject(Object page, SearchContext searchContext) {
        HtmlElementLoader.populatePageObject(page, new HtmlElementLocatorFactory(searchContext));
    }

    public static void populatePageObject(Object page, CustomElementLocatorFactory locatorFactory) {
        PageFactory.initElements((FieldDecorator)new HtmlElementDecorator(locatorFactory), (Object)page);
    }
}

